/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.models;

import android.util.Log;
import com.bambora.nativepayment.interfaces.IJsonRequest;
import com.bambora.nativepayment.logging.BNLog;
import com.bambora.nativepayment.models.PaymentType;
import org.json.JSONException;
import org.json.JSONObject;

public class PaymentSettings
implements IJsonRequest {
    private static final String KEY_AMOUNT = "amount";
    private static final String KEY_CURRENCY = "currency";
    private static final String KEY_COMMENT = "comment";
    private static final String KEY_TOKEN = "token";
    private static final String KEY_CVC_CODE = "cvcCode";
    private static final String KEY_PAYMENT_JSON_DATA = "paymentJsonData";
    private static final String KEY_CARD_PAYMENT_JSON_DATA = "cardJsonData";
    private String KEY_TRANSACTION_TYPE = "TrnType";
    public Integer amount;
    public String currency;
    public String comment;
    public String creditCardToken;
    public String cvcCode;
    public JSONObject paymentJsonData;
    public JSONObject cardPaymentJsonData;
    public Boolean enableVisaCheckout = false;
    public PaymentType.PaymentTypeEnum paymentType;

    @Override
    public String getSerialized() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(KEY_AMOUNT, (Object)this.amount);
            jsonObject.put(KEY_CURRENCY, (Object)this.currency);
            jsonObject.put(KEY_COMMENT, (Object)this.comment);
            jsonObject.put(KEY_TOKEN, (Object)this.creditCardToken);
            if (this.cvcCode != null) {
                jsonObject.put(KEY_CVC_CODE, (Object)this.cvcCode);
            }
            if (this.paymentJsonData != null) {
                this.setTransactionType();
                jsonObject.put(KEY_PAYMENT_JSON_DATA, (Object)this.paymentJsonData);
            }
            if (this.isCardPayment() && this.cardPaymentJsonData != null) {
                jsonObject.put(KEY_CARD_PAYMENT_JSON_DATA, (Object)this.cardPaymentJsonData);
            }
        }
        catch (JSONException e) {
            BNLog.jsonParseError(this.getClass().getSimpleName(), (Exception)((Object)e));
        }
        return jsonObject.toString();
    }

    private void setTransactionType() {
        if (this.paymentJsonData != null) {
            try {
                this.paymentJsonData.put(this.KEY_TRANSACTION_TYPE, (Object)PaymentType.PaymentTypeHash().get((Object)this.paymentType));
            }
            catch (JSONException e) {
                Log.e((String)"Set Payment Type", (String)"unexpected JSON exception", (Throwable)e);
            }
        }
    }

    private boolean isCardPayment() {
        return this.paymentType != null && (this.paymentType == PaymentType.PaymentTypeEnum.PaymentCard || this.paymentType == PaymentType.PaymentTypeEnum.PreAuthCard);
    }
}

