/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.managers;

import android.content.Context;
import com.bambora.nativepayment.interfaces.ICertificateLoadCallback;
import com.bambora.nativepayment.security.EncryptionCertificate;
import com.bambora.nativepayment.security.MasterCertificates;
import com.bambora.nativepayment.services.CertificateApiService;
import com.bambora.nativepayment.storage.FileStorage;
import com.bambora.nativepayment.storage.TransactionFileStorage;
import java.io.Serializable;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CertificateManager {
    private static CertificateManager instance = new CertificateManager();
    private TransactionFileStorage fileStorage = new TransactionFileStorage();
    private List<EncryptionCertificate> encryptionCertificates;

    public static CertificateManager getInstance() {
        return instance;
    }

    private CertificateManager() {
    }

    public void getEncryptionCertificates(final Context context, final ICertificateLoadCallback callback) {
        this.getStoredCertificates(context, new CertificateApiService.ICertificateCallback(){

            @Override
            public void onCertificatesLoaded(List<EncryptionCertificate> certificates) {
                if (certificates == null || certificates.isEmpty() || CertificateManager.this.closeToExpiry(certificates)) {
                    CertificateManager.this.downloadCertificates(context, callback);
                } else {
                    CertificateManager.this.encryptionCertificates = certificates;
                    if (callback != null) {
                        callback.onCertificatesLoaded(CertificateManager.this.encryptionCertificates);
                    }
                }
            }
        });
    }

    public List<Certificate> getMasterCertificates() {
        return MasterCertificates.getMasterCertificates();
    }

    private boolean closeToExpiry(List<EncryptionCertificate> certificates) {
        if (certificates == null || certificates.isEmpty()) {
            return true;
        }
        for (EncryptionCertificate certificate : certificates) {
            if (!certificate.isCloseToExpiry()) continue;
            return true;
        }
        return false;
    }

    private void downloadCertificates(final Context context, final ICertificateLoadCallback callback) {
        CertificateApiService.CertificateService.getCertificates(new ICertificateLoadCallback(){

            @Override
            public void onCertificatesLoaded(List<EncryptionCertificate> certificates) {
                CertificateManager.this.encryptionCertificates = CertificateManager.this.getTrustedCertificates(certificates);
                CertificateManager.this.storeCertificates(context, CertificateManager.this.encryptionCertificates);
                if (callback != null) {
                    if (!CertificateManager.this.encryptionCertificates.isEmpty()) {
                        callback.onCertificatesLoaded(CertificateManager.this.encryptionCertificates);
                    } else {
                        callback.onError();
                    }
                }
            }

            @Override
            public void onError() {
                if (callback != null) {
                    callback.onError();
                }
            }
        });
    }

    private void getStoredCertificates(Context context, final CertificateApiService.ICertificateCallback callback) {
        this.fileStorage.getEncryptionCertificates(context, new FileStorage.IOnObjectRead(){

            @Override
            public void notifyOnObjectRead(Serializable object) {
                EncryptionCertificate[] certs = object instanceof EncryptionCertificate[] ? (EncryptionCertificate[])object : new EncryptionCertificate[]{};
                callback.onCertificatesLoaded(new ArrayList<EncryptionCertificate>(Arrays.asList(certs)));
            }
        });
    }

    private List<EncryptionCertificate> getTrustedCertificates(List<EncryptionCertificate> certificatesToValidate) {
        ArrayList<EncryptionCertificate> validCerts = new ArrayList<EncryptionCertificate>();
        for (EncryptionCertificate certificate : certificatesToValidate) {
            validCerts.add(certificate);
        }
        return validCerts;
    }

    private void storeCertificates(Context context, List<EncryptionCertificate> certificates) {
        this.fileStorage = new TransactionFileStorage();
        EncryptionCertificate[] certificateArray = new EncryptionCertificate[certificates.size()];
        certificates.toArray(certificateArray);
        this.fileStorage.saveEncryptionCertificates(context, certificateArray, null);
    }
}

