/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.handlers;

import android.content.Context;
import android.content.SharedPreferences;
import com.bambora.nativepayment.interfaces.ICardRegistrationCallback;
import com.bambora.nativepayment.interfaces.ITransactionExtListener;
import com.bambora.nativepayment.interfaces.ITransactionListener;
import com.bambora.nativepayment.interfaces.VisaCheckoutDataCallback;
import com.bambora.nativepayment.interfaces.VisaCheckoutTransactionCallback;
import com.bambora.nativepayment.logging.BNLog;
import com.bambora.nativepayment.managers.CertificateManager;
import com.bambora.nativepayment.managers.CreditCardManager;
import com.bambora.nativepayment.models.PaymentSettings;
import com.bambora.nativepayment.models.PaymentType;
import com.bambora.nativepayment.models.VisaCheckoutTransactionParams;
import com.bambora.nativepayment.models.creditcard.RegistrationFormSettings;
import com.bambora.nativepayment.models.creditcard.RegistrationParams;
import com.bambora.nativepayment.network.ApiService;
import com.bambora.nativepayment.network.BNHttpClient;
import com.bambora.nativepayment.network.HttpClient;
import com.bambora.nativepayment.network.Request;
import com.bambora.nativepayment.security.Crypto;
import com.bambora.nativepayment.services.PaymentApiService;
import com.bambora.nativepayment.services.VisaCheckoutApiService;
import java.lang.reflect.Constructor;
import org.json.JSONException;
import org.json.JSONObject;

public class BNPaymentHandler {
    private String mBaseUrl;
    private static BNPaymentHandler ourInstance = new BNPaymentHandler();
    private BNHttpClient mHttpClient;
    private String mApiToken;
    private String mMerchantAccount;
    public static final String sharedPreferencesKey = "Bambora_APAC_SDK";
    public static final String existingMerchantAccountKey = "BamboraMerchantAccount";
    public static final String existingBaseURLKey = "BamboraBaseURL";
    private boolean mDebug;
    private CreditCardManager creditCardManager = new CreditCardManager();
    private CertificateManager certificateManager = CertificateManager.getInstance();
    private JSONObject registrationJsonData;

    private BNPaymentHandler() {
    }

    public JSONObject getRegistrationJsonData() {
        return this.registrationJsonData;
    }

    public void setRegistrationJsonData(JSONObject registrationJsonData) {
        this.registrationJsonData = registrationJsonData;
    }

    public static BNPaymentHandler getInstance() {
        return ourInstance;
    }

    public static void setupBNPayments(BNPaymentBuilder builder) {
        BNPaymentHandler.ourInstance.mBaseUrl = builder.baseUrl;
        BNPaymentHandler.ourInstance.mApiToken = builder.apiToken;
        BNPaymentHandler.ourInstance.mMerchantAccount = builder.merchantAccount;
        BNPaymentHandler.ourInstance.mDebug = builder.debug;
        BNPaymentHandler.ourInstance.mHttpClient = BNPaymentHandler.ourInstance.mApiToken != null && !"".equals(BNPaymentHandler.ourInstance.mApiToken) ? new BNHttpClient(builder.context, builder.apiToken) : new BNHttpClient(builder.merchantAccount);
        BNPaymentHandler.ourInstance.certificateManager.getEncryptionCertificates(builder.context, null);
        ourInstance.checkMerchantAndEnvironment(BNPaymentHandler.ourInstance.mMerchantAccount, BNPaymentHandler.ourInstance.mBaseUrl, builder.context);
    }

    private void checkMerchantAndEnvironment(String merchantAccount, String baseUrl, Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(sharedPreferencesKey, 0);
        String existingMerchantAccount = sharedPreferences.getString(existingMerchantAccountKey, "");
        String existingBaseURL = sharedPreferences.getString(existingBaseURLKey, "");
        if (existingMerchantAccount.equalsIgnoreCase("") || existingBaseURL.equalsIgnoreCase("")) {
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(existingMerchantAccountKey, merchantAccount);
            editor.putString(existingBaseURLKey, baseUrl);
            editor.apply();
        } else if (!existingMerchantAccount.equalsIgnoreCase(merchantAccount) || !existingBaseURL.equalsIgnoreCase(baseUrl)) {
            ourInstance.deleteAllCards(context);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(existingMerchantAccountKey, merchantAccount);
            editor.putString(existingBaseURLKey, baseUrl);
            editor.apply();
        }
    }

    private void deleteAllCards(Context context) {
        this.creditCardManager.deleteAllCreditCards(context, null);
    }

    public Request initiateHostedPaymentPage(RegistrationFormSettings formSettings, PaymentApiService.IHppResultListener listener) {
        return PaymentApiService.PaymentService.initiateHppRegistration(formSettings, listener);
    }

    public void registerCreditCard(Context context, String cardNumber, String expiryMonth, String expiryYear, String securityCode, ICardRegistrationCallback listener) {
        this.creditCardManager.registerCreditCard(context, cardNumber, expiryMonth, expiryYear, securityCode, listener);
    }

    public void registerCreditCard(Context context, String cardHolder, String cardNumber, String expiryMonth, String expiryYear, String securityCode, ICardRegistrationCallback listener) {
        this.creditCardManager.registerCreditCard(context, cardHolder, cardNumber, expiryMonth, expiryYear, securityCode, listener);
    }

    public void getRegisteredCreditCards(Context context, CreditCardManager.IOnCreditCardRead listener) {
        this.creditCardManager.getCreditCards(context, listener);
    }

    public void deleteCreditCard(Context context, String creditCardToken, CreditCardManager.IOnCreditCardDeleted listener) {
        this.creditCardManager.deleteCreditCard(context, creditCardToken, listener);
    }

    public void setCreditCardAlias(Context context, String alias, String token, CreditCardManager.IOnCreditCardSaved listener) {
        this.creditCardManager.setAlias(context, alias, token, listener);
    }

    public Request makeTransaction(String paymentIdentifier, PaymentSettings paymentSettings, ITransactionListener callBack) {
        return PaymentApiService.PaymentService.makeTransaction(paymentIdentifier, paymentSettings, callBack);
    }

    public Request submitSinglePaymentCard(Context context, String paymentIdentifier, PaymentSettings paymentSettings, ITransactionExtListener callBack, CreditCardManager.IOnCreditCardSaved onSavedListener) {
        paymentSettings.paymentType = PaymentType.PaymentTypeEnum.PaymentCard;
        return PaymentApiService.PaymentService.makeTransactionCard(context, paymentIdentifier, paymentSettings, callBack, onSavedListener);
    }

    public Request submitSinglePaymentToken(String paymentIdentifier, PaymentSettings paymentSettings, ITransactionExtListener callBack) {
        paymentSettings.paymentType = PaymentType.PaymentTypeEnum.PaymentToken;
        return PaymentApiService.PaymentService.makeTransactionToken(paymentIdentifier, paymentSettings, callBack);
    }

    public Request submitPreAuthToken(String paymentIdentifier, PaymentSettings paymentSettings, ITransactionExtListener callBack) {
        paymentSettings.paymentType = PaymentType.PaymentTypeEnum.PreAuthToken;
        return PaymentApiService.PaymentService.makeTransactionToken(paymentIdentifier, paymentSettings, callBack);
    }

    public Request submitPreAuthCard(Context context, String paymentIdentifier, PaymentSettings paymentSettings, ITransactionExtListener callBack, CreditCardManager.IOnCreditCardSaved onSavedListener) {
        paymentSettings.paymentType = PaymentType.PaymentTypeEnum.PreAuthCard;
        return PaymentApiService.PaymentService.makeTransactionCard(context, paymentIdentifier, paymentSettings, callBack, onSavedListener);
    }

    public void submitSinglePreAuthCard(Context context, String paymentIdentifier, PaymentSettings paymentSettings, String cardHolderName, String cardNumber, String expiryMonth, String expiryYear, String securityCode, boolean requestToken, ITransactionExtListener callBack, CreditCardManager.IOnCreditCardSaved onSavedListener) {
        paymentSettings.paymentType = PaymentType.PaymentTypeEnum.PreAuthCard;
        this.submitSingleTransactionCard(context, paymentIdentifier, paymentSettings, cardHolderName, cardNumber, expiryMonth, expiryYear, securityCode, requestToken, callBack, onSavedListener);
    }

    public void submitSinglePaymentCard(Context context, String paymentIdentifier, PaymentSettings paymentSettings, String cardHolderName, String cardNumber, String expiryMonth, String expiryYear, String securityCode, boolean requestToken, ITransactionExtListener callBack, CreditCardManager.IOnCreditCardSaved onSavedListener) {
        paymentSettings.paymentType = PaymentType.PaymentTypeEnum.PaymentCard;
        this.submitSingleTransactionCard(context, paymentIdentifier, paymentSettings, cardHolderName, cardNumber, expiryMonth, expiryYear, securityCode, requestToken, callBack, onSavedListener);
    }

    public void submitSingleTransactionCard(final Context context, final String paymentIdentifier, final PaymentSettings paymentSettings, String cardHolderName, String cardNumber, String expiryMonth, String expiryYear, String securityCode, final boolean requestToken, final ITransactionExtListener callBack, final CreditCardManager.IOnCreditCardSaved onSavedListener) {
        final RegistrationParams params = new RegistrationParams(new Crypto(), CertificateManager.getInstance());
        params.setParametersAndEncrypt(context, cardHolderName, cardNumber, expiryMonth, expiryYear, securityCode, new RegistrationParams.IOnEncryptionListener(){

            @Override
            public void onEncryptionComplete() {
                JSONObject cardObject = new JSONObject();
                try {
                    RegistrationParams.EncryptedSessionKey encryptedSessionKeyObj = params.encryptedSessionKeys.get(0);
                    cardObject.put("cardholderName", (Object)params.encryptedCard.cardHolder);
                    cardObject.put("cardNumber", (Object)params.encryptedCard.cardNumber);
                    cardObject.put("expiryMonth", (Object)params.encryptedCard.expiryMonth);
                    cardObject.put("expiryYear", (Object)params.encryptedCard.expiryYear);
                    cardObject.put("sessionKey", (Object)encryptedSessionKeyObj.sessionKey);
                    cardObject.put("isTokenRequested", requestToken);
                    paymentSettings.cardPaymentJsonData = cardObject;
                    PaymentApiService.PaymentService.makeTransactionCard(context, paymentIdentifier, paymentSettings, callBack, onSavedListener);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onEncryptionError() {
                if (callBack != null) {
                    callBack.onTransactionError(null);
                }
            }
        });
    }

    public void getVisaCheckoutData(Context context, VisaCheckoutDataCallback callBack) {
        VisaCheckoutApiService.VisaCheckoutService.getVisaCheckoutData(context, callBack);
    }

    public void processTransaction(Context context, VisaCheckoutTransactionParams visaCheckoutTransactionParams, VisaCheckoutTransactionCallback callBack) {
        VisaCheckoutApiService.VisaCheckoutService.processTransaction(context, visaCheckoutTransactionParams, callBack);
    }

    public <T extends ApiService> T createService(Class<T> serviceClass) {
        try {
            Constructor<T> constructor = serviceClass.getConstructor(new Class[0]);
            ApiService instance = (ApiService)constructor.newInstance(new Object[0]);
            instance.initiate(this.mBaseUrl, this.mHttpClient);
            return (T)instance;
        }
        catch (Exception e) {
            BNLog.e(this.getClass().getSimpleName(), "Internal error; failed to generate API service.", e);
            return null;
        }
    }

    @Deprecated
    public String getApiToken() {
        return this.mApiToken;
    }

    public String getMerchantAccount() {
        return this.mMerchantAccount;
    }

    public boolean getDebug() {
        return this.mDebug;
    }

    public HttpClient getHttpClient() {
        return this.mHttpClient;
    }

    public void setCertificateManager(CertificateManager certificateManager) {
        BNPaymentHandler.ourInstance.certificateManager = certificateManager;
    }

    public void clearSetup() {
        ourInstance = new BNPaymentHandler();
    }

    public static class BNPaymentBuilder {
        private String baseUrl = "https://eu-native.bambora.com/";
        private boolean debug;
        private String apiToken;
        private String merchantAccount;
        private Context context;

        @Deprecated
        public BNPaymentBuilder(Context context, String apiToken) {
            this.context = context;
            this.apiToken = apiToken;
        }

        public BNPaymentBuilder(Context context) {
            this.context = context;
        }

        public BNPaymentBuilder merchantAccount(String merchantAccount) {
            this.merchantAccount = merchantAccount;
            return this;
        }

        public BNPaymentBuilder debug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public BNPaymentBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }
    }
}

