/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.widget.edittext;

import android.annotation.TargetApi;
import android.content.Context;
import android.text.InputFilter;
import android.util.AttributeSet;
import android.view.View;
import android.widget.EditText;
import com.bambora.nativepayment.widget.CardInputValidator;
import com.bambora.nativepayment.widget.FormInputHelper;
import java.util.regex.Pattern;

public abstract class CardFormEditText
extends EditText
implements CardInputValidator,
View.OnFocusChangeListener {
    private Pattern validationPattern;
    private IOnValidationEventListener validationEventListener;

    public CardFormEditText(Context context) {
        super(context);
        this.setupView();
    }

    public CardFormEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setupView();
    }

    public CardFormEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setupView();
    }

    @TargetApi(value=21)
    public CardFormEditText(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setupView();
    }

    public abstract Integer getDefaultMaxLength();

    public abstract String getDefaultHint();

    public void setValidationListener(IOnValidationEventListener validationListener) {
        this.validationEventListener = validationListener;
    }

    @Override
    public void setValidationPattern(String validationPattern) {
        if (validationPattern != null) {
            this.validationPattern = Pattern.compile(validationPattern);
        }
    }

    @Override
    public boolean isValid() {
        String input = this.getText().toString();
        return this.validationPattern == null || this.validationPattern.matcher(FormInputHelper.clearNonDigits(input)).matches();
    }

    public void onFocusChange(View view, boolean hasFocus) {
        if (this.validationEventListener != null) {
            this.validationEventListener.onFocusChanged(this, hasFocus, this.isValid());
        }
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        super.onTextChanged(text, start, lengthBefore, lengthAfter);
        if (this.validationEventListener != null) {
            this.validationEventListener.onInputValidated(this, this.isValid());
        }
    }

    private void setupView() {
        this.setInputType(3);
        this.setOnFocusChangeListener(this);
        this.setMaxLengthFilter(this.getDefaultMaxLength());
        this.setDefaultHint();
    }

    private void setDefaultHint() {
        CharSequence hint = this.getHint();
        if (hint == null) {
            this.setHint(this.getDefaultHint());
        }
    }

    protected void setMaxLengthFilter(int maxLength) {
        InputFilter[] filterArray = new InputFilter[]{new InputFilter.LengthFilter(maxLength)};
        this.setFilters(filterArray);
    }

    public static interface IOnValidationEventListener {
        public void onFocusChanged(EditText var1, boolean var2, boolean var3);

        public void onInputValidated(EditText var1, boolean var2);
    }
}

