/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.PorterDuff;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import com.bambora.nativepayment.models.VisaCheckoutLaunchParams;
import com.visa.checkout.hybrid.VisaCheckoutPlugin;
import java.io.IOException;
import java.io.InputStream;

public class VisaCheckoutButton
extends WebView {
    ProgressBar progressBar;
    Context layOutContext;
    VisaCheckOutResult visaCheckOutResult;

    public VisaCheckoutButton(Context context) {
        super(context);
        this.setupView(context);
    }

    public VisaCheckoutButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setupView(context);
    }

    public VisaCheckoutButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setupView(context);
    }

    @TargetApi(value=21)
    public VisaCheckoutButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setupView(context);
    }

    private void setupView(Context context) {
        this.layOutContext = context;
    }

    public void loadUI(VisaCheckoutLaunchParams visaCheckoutLaunchParams, RelativeLayout visaCheckoutLayout, int loadingBarColor) {
        if (Build.VERSION.SDK_INT >= 21) {
            CookieManager.getInstance().setAcceptThirdPartyCookies((WebView)this, true);
        }
        this.setVisibility(4);
        this.progressBar = new ProgressBar(this.layOutContext, null, 16842874);
        this.progressBar.setVisibility(0);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(13);
        this.progressBar.getIndeterminateDrawable().setColorFilter(loadingBarColor, PorterDuff.Mode.MULTIPLY);
        visaCheckoutLayout.addView((View)this.progressBar, (ViewGroup.LayoutParams)params);
        this.getSettings().setJavaScriptEnabled(true);
        this.addJavascriptInterface(new VisaCheckoutCallBack(), "visaCheckoutCallBack");
        VisaCheckoutPlugin.configure((WebView)this);
        this.setWebViewClient(new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                VisaCheckoutButton.this.progressBar.setVisibility(8);
                VisaCheckoutButton.this.visaCheckOutResult.visaCheckoutSetupComplete();
                view.setVisibility(0);
            }
        });
        try {
            AssetManager am = this.getResources().getAssets();
            InputStream is = am.open("VisaCheckOutConnector.html");
            int size = is.available();
            byte[] buffer = new byte[size];
            is.read(buffer);
            String content = new String(buffer);
            is.close();
            content = String.format(content, visaCheckoutLaunchParams.apikey, visaCheckoutLaunchParams.externalClientId, visaCheckoutLaunchParams.externalProfileId, visaCheckoutLaunchParams.currencyCode, visaCheckoutLaunchParams.subtotal, visaCheckoutLaunchParams.total, visaCheckoutLaunchParams.locale, visaCheckoutLaunchParams.collectShipping, visaCheckoutLaunchParams.message, visaCheckoutLaunchParams.buttonAction, visaCheckoutLaunchParams.buttonImageUrl, visaCheckoutLaunchParams.jsLibraryUrl);
            this.loadDataWithBaseURL("blarg://ignored", content, "text/html", "utf-8", "");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class VisaCheckoutCallBack {
        @JavascriptInterface
        public void Success(String response) {
            VisaCheckoutButton.this.visaCheckOutResult.visaCheckoutSuccess(response);
        }

        @JavascriptInterface
        public void Cancel(String response) {
        }

        @JavascriptInterface
        public void Error(String response) {
            VisaCheckoutButton.this.visaCheckOutResult.visaCheckoutFail(response);
        }
    }

    public static interface VisaCheckOutResult {
        public void visaCheckoutSuccess(String var1);

        public void visaCheckoutFail(String var1);

        public void visaCheckoutSetupComplete();
    }
}

