/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.widget;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.ToggleButton;
import com.bambora.nativepayment.R;
import com.bambora.nativepayment.handlers.BNPaymentHandler;
import com.bambora.nativepayment.interfaces.ITransactionExtListener;
import com.bambora.nativepayment.interfaces.VisaCheckoutDataCallback;
import com.bambora.nativepayment.interfaces.VisaCheckoutTransactionCallback;
import com.bambora.nativepayment.managers.CreditCardManager;
import com.bambora.nativepayment.models.PaymentSettings;
import com.bambora.nativepayment.models.SubmitPaymentCardFormGuiSetting;
import com.bambora.nativepayment.models.VisaCheckoutLaunchParams;
import com.bambora.nativepayment.models.VisaCheckoutResponse;
import com.bambora.nativepayment.models.VisaCheckoutTransactionParams;
import com.bambora.nativepayment.network.RequestError;
import com.bambora.nativepayment.utils.CompatHelper;
import com.bambora.nativepayment.widget.VisaCheckoutButton;
import com.bambora.nativepayment.widget.edittext.CardFormEditText;
import com.bambora.nativepayment.widget.edittext.CardHolderEditText;
import com.bambora.nativepayment.widget.edittext.CardNumberEditText;
import com.bambora.nativepayment.widget.edittext.ExpiryDateEditText;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class TransactionCardFormLayout
extends RelativeLayout
implements CardFormEditText.IOnValidationEventListener,
ITransactionExtListener,
VisaCheckoutDataCallback,
VisaCheckoutTransactionCallback {
    private ITransactionExtListener resultListenerForInternal;
    private ITransactionExtListener resultListenerForExternal;
    private VisaCheckoutDataCallback visaCheckoutDataCallback;
    private VisaCheckoutTransactionCallback visaCheckoutTransactionCallback;
    private CreditCardManager.IOnCreditCardSaved onSavedCardListener;
    private PaymentSettings paymentSettings;
    private String paymentId;
    private TextView pageTitle;
    private CardHolderEditText cardHolderEditText;
    private CardNumberEditText cardNumberEditText;
    private ExpiryDateEditText expiryDateEditText;
    private CardFormEditText securityCodeEditText;
    private ToggleButton isSaveCardButton;
    private Map<EditText, Boolean> inputValidStates = new HashMap<EditText, Boolean>();
    private Button registrationButton;
    private SubmitPaymentCardFormGuiSetting submitPaymentCardFormGuiSetting;
    private ProgressBar progressBar;
    private VisaCheckoutButton visaCheckoutButton;
    private RelativeLayout visaCheckoutLayout;
    private Activity activity;
    private LinearLayout or_UI;
    private View.OnClickListener onSubmitSinglePaymentCardButtonClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            TransactionCardFormLayout.this.hideKeyboard();
            TransactionCardFormLayout.this.startLoadingUI();
            BNPaymentHandler.getInstance().submitSingleTransactionCard(TransactionCardFormLayout.this.getContext(), TransactionCardFormLayout.this.paymentId, TransactionCardFormLayout.this.paymentSettings, TransactionCardFormLayout.this.cardHolderEditText.getText().toString(), TransactionCardFormLayout.this.cardNumberEditText.getText().toString(), TransactionCardFormLayout.this.expiryDateEditText.getEnteredExpiryMonth(), TransactionCardFormLayout.this.expiryDateEditText.getEnteredExpiryYear(), TransactionCardFormLayout.this.securityCodeEditText.getText().toString(), TransactionCardFormLayout.this.isSaveCardButton.isChecked(), TransactionCardFormLayout.this.resultListenerForInternal, TransactionCardFormLayout.this.onSavedCardListener);
        }
    };

    public TransactionCardFormLayout(Context context) {
        super(context);
        this.setupView(context);
    }

    public TransactionCardFormLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setupView(context);
    }

    public TransactionCardFormLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setupView(context);
    }

    @TargetApi(value=21)
    public TransactionCardFormLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setupView(context);
    }

    public void setTransactionCardResultListener(ITransactionExtListener resultListener) {
        this.resultListenerForExternal = resultListener;
    }

    public void setSavedCardListener(CreditCardManager.IOnCreditCardSaved onSavedListener) {
        this.onSavedCardListener = onSavedListener;
    }

    public void setTransactionParams(PaymentSettings paymentSettings, String paymentId) {
        this.paymentId = paymentId;
        this.paymentSettings = paymentSettings;
        if (paymentSettings.enableVisaCheckout.booleanValue() && this.hasVisaCheckoutSDK()) {
            this.launchVisaCheckOut();
        } else {
            this.or_UI.setVisibility(8);
            this.visaCheckoutLayout.setVisibility(8);
        }
    }

    public void launchVisaCheckOut() {
        this.progressBar.setVisibility(0);
        this.visaCheckoutDataCallback = this;
        BNPaymentHandler.getInstance().getVisaCheckoutData(this.getContext(), this.visaCheckoutDataCallback);
    }

    @Override
    public void onVisaCheckoutDataSuccess(VisaCheckoutLaunchParams visaCheckoutLaunchParams) {
        this.progressBar.setVisibility(4);
        visaCheckoutLaunchParams.setAmount(this.paymentSettings.amount);
        this.setupVisaCheckOutButtonWithData(visaCheckoutLaunchParams);
    }

    @Override
    public void onVisaCheckoutDataError(RequestError error) {
        this.progressBar.setVisibility(4);
    }

    public void setTitle(String title) {
        TextView titleTextView = (TextView)this.findViewById(R.id.tv_title);
        if (titleTextView != null) {
            titleTextView.setText((CharSequence)title);
        }
    }

    @Override
    public void onFocusChanged(EditText view, boolean hasFocus, boolean inputValid) {
        if (hasFocus) {
            view.setTextColor(CompatHelper.getColor(this.getContext(), R.color.bn_black, null));
        } else if (!inputValid) {
            view.setTextColor(CompatHelper.getColor(this.getContext(), R.color.bn_red, null));
        }
    }

    @Override
    public void onInputValidated(EditText view, boolean inputValid) {
        this.inputValidStates.put(view, inputValid);
        this.updateButtonState();
    }

    private void setupView(Context context) {
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        inflater.inflate(R.layout.native_submit_single_payment_card_form, (ViewGroup)this);
        this.pageTitle = (TextView)this.findViewById(R.id.tv_title);
        this.cardHolderEditText = (CardHolderEditText)this.findViewById(R.id.et_card_holder);
        this.cardNumberEditText = (CardNumberEditText)this.findViewById(R.id.et_card_number);
        this.expiryDateEditText = (ExpiryDateEditText)this.findViewById(R.id.et_expiry_date);
        this.securityCodeEditText = (CardFormEditText)this.findViewById(R.id.et_security_code);
        this.isSaveCardButton = (ToggleButton)this.findViewById(R.id.togg_is_save_card_btn);
        this.registrationButton = (Button)this.findViewById(R.id.btn_register);
        this.registrationButton.setOnClickListener(this.onSubmitSinglePaymentCardButtonClickListener);
        this.visaCheckoutLayout = (RelativeLayout)this.findViewById(R.id.visa_checkout_layout);
        this.visaCheckoutButton = (VisaCheckoutButton)this.findViewById(R.id.visa_checkout_button);
        this.or_UI = (LinearLayout)this.findViewById(R.id.or_UI);
        this.cardHolderEditText.setValidationListener(this);
        this.cardNumberEditText.setValidationListener(this);
        this.expiryDateEditText.setValidationListener(this);
        this.securityCodeEditText.setValidationListener(this);
        this.inputValidStates.put(this.cardHolderEditText, true);
        this.inputValidStates.put(this.cardNumberEditText, false);
        this.inputValidStates.put(this.expiryDateEditText, false);
        this.inputValidStates.put(this.securityCodeEditText, true);
        this.progressBar = new ProgressBar(context, null, 16842874);
        this.progressBar.getIndeterminateDrawable().setColorFilter(this.getResources().getColor(R.color.bn_purple), PorterDuff.Mode.MULTIPLY);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(13);
        this.addView((View)this.progressBar, (ViewGroup.LayoutParams)params);
        this.progressBar.setVisibility(4);
        this.resultListenerForInternal = this;
        this.activity = (Activity)context;
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                TransactionCardFormLayout.this.hideKeyboard();
                return false;
            }
        });
    }

    public void setFormGuiSetting(SubmitPaymentCardFormGuiSetting guiSetting) {
        this.submitPaymentCardFormGuiSetting = guiSetting;
        this.viewCustomization();
    }

    private void setupVisaCheckOutButtonWithData(VisaCheckoutLaunchParams visaCheckoutLaunchParams) {
        this.visaCheckoutButton.requestLayout();
        int loadingBarColor = this.submitPaymentCardFormGuiSetting != null && this.submitPaymentCardFormGuiSetting.PayLoadingBarColor != null && this.submitPaymentCardFormGuiSetting.PayLoadingBarColor.trim().length() == 7 ? Color.parseColor((String)this.submitPaymentCardFormGuiSetting.PayLoadingBarColor) : this.getResources().getColor(R.color.bn_purple);
        this.visaCheckoutButton.loadUI(visaCheckoutLaunchParams, this.visaCheckoutLayout, loadingBarColor);
        this.visaCheckoutTransactionCallback = this;
        this.visaCheckoutButton.visaCheckOutResult = new VisaCheckoutButton.VisaCheckOutResult(){

            @Override
            public void visaCheckoutSuccess(String info) {
                try {
                    JSONObject jsonObject = new JSONObject(info);
                    final VisaCheckoutTransactionParams VisaCheckoutTransactionParams2 = new VisaCheckoutTransactionParams();
                    VisaCheckoutTransactionParams2.callid = jsonObject.getString("callid");
                    VisaCheckoutTransactionParams2.encKey = jsonObject.getString("encKey");
                    VisaCheckoutTransactionParams2.encPaymentData = jsonObject.getString("encPaymentData");
                    VisaCheckoutTransactionParams2.paymentJsonData = ((TransactionCardFormLayout)TransactionCardFormLayout.this).paymentSettings.paymentJsonData;
                    TransactionCardFormLayout.this.activity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            TransactionCardFormLayout.this.progressBar.setVisibility(0);
                            BNPaymentHandler.getInstance().processTransaction(TransactionCardFormLayout.this.getContext(), VisaCheckoutTransactionParams2, TransactionCardFormLayout.this.visaCheckoutTransactionCallback);
                        }
                    });
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void visaCheckoutFail(String info) {
            }

            @Override
            public void visaCheckoutSetupComplete() {
            }
        };
    }

    @Override
    public void onVisaCheckoutTransactionSuccess(VisaCheckoutResponse visaCheckoutResponse) {
        this.progressBar.setVisibility(4);
        HashMap<String, String> responseMap = new HashMap<String, String>();
        if (visaCheckoutResponse.receipt != null) {
            responseMap.put("receipt", visaCheckoutResponse.receipt);
        }
        this.resultListenerForExternal.onTransactionSuccess(responseMap);
    }

    @Override
    public void onVisaCheckoutTransactionError(RequestError error) {
        this.progressBar.setVisibility(4);
    }

    private boolean hasVisaCheckoutSDK() {
        try {
            Class.forName("com.visa.checkout.hybrid.VisaCheckoutPlugin");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void viewCustomization() {
        if (this.submitPaymentCardFormGuiSetting == null) {
            return;
        }
        this.TitleCustomization();
        this.SubmitSinglePaymentCardButtonCustomization();
        this.SubmitSinglePaymentCardSwitchButtonCustomization();
        this.CardHolderCustomization();
        this.CardNumberCustomization();
        this.ExpiryDateCustomization();
        this.SecurityCodeCustomization();
        this.SubmitSinglePaymentCardLoadingBarCustomization();
    }

    private void TitleCustomization() {
        if (this.submitPaymentCardFormGuiSetting.TitleText != null && this.submitPaymentCardFormGuiSetting.TitleText.trim().length() > 0 && this.pageTitle != null) {
            this.pageTitle.setText((CharSequence)this.submitPaymentCardFormGuiSetting.TitleText);
        }
    }

    private void SubmitSinglePaymentCardButtonCustomization() {
        if (this.registrationButton != null) {
            if (this.submitPaymentCardFormGuiSetting.PayByCardButtonText != null && this.submitPaymentCardFormGuiSetting.PayByCardButtonText.trim().length() > 0 && this.registrationButton != null) {
                this.registrationButton.setText((CharSequence)this.submitPaymentCardFormGuiSetting.PayByCardButtonText);
            }
            if (this.submitPaymentCardFormGuiSetting.PayByCardButtonColor != null && this.submitPaymentCardFormGuiSetting.PayByCardButtonColor.trim().length() == 7) {
                int colorValue = Color.parseColor((String)this.submitPaymentCardFormGuiSetting.PayByCardButtonColor);
                this.registrationButton.setBackgroundColor(colorValue);
            }
        }
    }

    private void SubmitSinglePaymentCardLoadingBarCustomization() {
        if (this.progressBar != null && this.submitPaymentCardFormGuiSetting.PayLoadingBarColor != null && this.submitPaymentCardFormGuiSetting.PayLoadingBarColor.trim().length() == 7) {
            int colorValue = Color.parseColor((String)this.submitPaymentCardFormGuiSetting.PayLoadingBarColor);
            this.progressBar.getIndeterminateDrawable().setColorFilter(colorValue, PorterDuff.Mode.MULTIPLY);
        }
    }

    private void SubmitSinglePaymentCardSwitchButtonCustomization() {
        if (this.isSaveCardButton != null && this.submitPaymentCardFormGuiSetting.SwitchButtonColor != null && this.submitPaymentCardFormGuiSetting.SwitchButtonColor.trim().length() == 7) {
            int colorValue = Color.parseColor((String)this.submitPaymentCardFormGuiSetting.SwitchButtonColor);
            this.isSaveCardButton.setBackgroundColor(colorValue);
        }
    }

    private void CardHolderCustomization() {
        if (this.cardHolderEditText != null && this.submitPaymentCardFormGuiSetting.CardHolderWatermark != null && this.submitPaymentCardFormGuiSetting.CardHolderWatermark.trim().length() > 0) {
            this.cardHolderEditText.setHint(this.submitPaymentCardFormGuiSetting.CardHolderWatermark);
        }
    }

    private void CardNumberCustomization() {
        if (this.submitPaymentCardFormGuiSetting.CardNumberWatermark != null && this.submitPaymentCardFormGuiSetting.CardNumberWatermark.trim().length() > 0 && this.cardNumberEditText != null) {
            this.cardNumberEditText.setHint(this.submitPaymentCardFormGuiSetting.CardNumberWatermark);
        }
    }

    private void ExpiryDateCustomization() {
        if (this.submitPaymentCardFormGuiSetting.ExpiryDateWatermark != null && this.submitPaymentCardFormGuiSetting.ExpiryDateWatermark.trim().length() > 0 && this.expiryDateEditText != null) {
            this.expiryDateEditText.setHint(this.submitPaymentCardFormGuiSetting.ExpiryDateWatermark);
        }
    }

    private void SecurityCodeCustomization() {
        if (this.submitPaymentCardFormGuiSetting.SecurityCodeWatermark != null && this.submitPaymentCardFormGuiSetting.SecurityCodeWatermark.trim().length() > 0 && this.securityCodeEditText != null) {
            this.securityCodeEditText.setHint(this.submitPaymentCardFormGuiSetting.SecurityCodeWatermark);
        }
    }

    private void updateButtonState() {
        boolean enabled = true;
        for (EditText key : this.inputValidStates.keySet()) {
            if (this.inputValidStates.get(key).booleanValue()) continue;
            enabled = false;
            break;
        }
        this.registrationButton.setEnabled(enabled);
    }

    private void startLoadingUI() {
        this.registrationButton.setEnabled(false);
        this.progressBar.setVisibility(0);
    }

    private void stopLoadingUI() {
        this.registrationButton.setEnabled(true);
        this.updateButtonState();
        this.progressBar.setVisibility(4);
    }

    private void hideKeyboard() {
        View view = this.activity.getCurrentFocus();
        if (view != null) {
            InputMethodManager imm = (InputMethodManager)this.activity.getSystemService("input_method");
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    @Override
    public void onTransactionSuccess(Map<String, String> response) {
        this.stopLoadingUI();
        this.resultListenerForExternal.onTransactionSuccess(response);
    }

    @Override
    public void onTransactionError(RequestError error) {
        this.stopLoadingUI();
        this.resultListenerForExternal.onTransactionError(error);
    }
}

