/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.bambora.nativepayment.R;
import com.bambora.nativepayment.handlers.BNPaymentHandler;
import com.bambora.nativepayment.interfaces.ICardRegistrationCallback;
import com.bambora.nativepayment.models.CardRegistrationFormGuiSetting;
import com.bambora.nativepayment.models.creditcard.CreditCard;
import com.bambora.nativepayment.network.RequestError;
import com.bambora.nativepayment.utils.CompatHelper;
import com.bambora.nativepayment.widget.edittext.CardFormEditText;
import com.bambora.nativepayment.widget.edittext.CardHolderEditText;
import com.bambora.nativepayment.widget.edittext.CardNumberEditText;
import com.bambora.nativepayment.widget.edittext.ExpiryDateEditText;
import java.util.HashMap;
import java.util.Map;

public class CardRegistrationFormLayout
extends RelativeLayout
implements CardFormEditText.IOnValidationEventListener,
ICardRegistrationCallback {
    private ICardRegistrationCallback resultListenerForInternal;
    private ICardRegistrationCallback resultListenerForExternal;
    private TextView pageTitle;
    private CardHolderEditText cardHolderEditText;
    private CardNumberEditText cardNumberEditText;
    private ExpiryDateEditText expiryDateEditText;
    private CardFormEditText securityCodeEditText;
    private Map<EditText, Boolean> inputValidStates = new HashMap<EditText, Boolean>();
    private Button registrationButton;
    private CardRegistrationFormGuiSetting registrationGuiSetting;
    private ProgressBar progressBar;
    private View.OnClickListener onRegisterButtonClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            CardRegistrationFormLayout.this.startLoadingUI();
            BNPaymentHandler.getInstance().registerCreditCard(CardRegistrationFormLayout.this.getContext(), CardRegistrationFormLayout.this.cardHolderEditText.getText().toString(), CardRegistrationFormLayout.this.cardNumberEditText.getText().toString(), CardRegistrationFormLayout.this.expiryDateEditText.getEnteredExpiryMonth(), CardRegistrationFormLayout.this.expiryDateEditText.getEnteredExpiryYear(), CardRegistrationFormLayout.this.securityCodeEditText.getText().toString(), CardRegistrationFormLayout.this.resultListenerForInternal);
        }
    };

    public CardRegistrationFormLayout(Context context) {
        super(context);
        this.setupView(context);
    }

    public CardRegistrationFormLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setupView(context);
    }

    public CardRegistrationFormLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setupView(context);
    }

    @TargetApi(value=21)
    public CardRegistrationFormLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setupView(context);
    }

    public void setRegistrationResultListener(ICardRegistrationCallback resultListener) {
        this.resultListenerForExternal = resultListener;
    }

    public void setTitle(String title) {
        TextView titleTextView = (TextView)this.findViewById(R.id.tv_title);
        if (titleTextView != null) {
            titleTextView.setText((CharSequence)title);
        }
    }

    public void setFormGuiSetting(CardRegistrationFormGuiSetting registrationGuiSetting) {
        this.registrationGuiSetting = registrationGuiSetting;
        this.viewCustomization();
    }

    @Override
    public void onFocusChanged(EditText view, boolean hasFocus, boolean inputValid) {
        if (hasFocus) {
            view.setTextColor(CompatHelper.getColor(this.getContext(), R.color.bn_black, null));
        } else if (!inputValid) {
            view.setTextColor(CompatHelper.getColor(this.getContext(), R.color.bn_red, null));
        }
    }

    @Override
    public void onInputValidated(EditText view, boolean inputValid) {
        this.inputValidStates.put(view, inputValid);
        this.updateButtonState();
    }

    private void setupView(Context context) {
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        inflater.inflate(R.layout.native_card_registration_form, (ViewGroup)this);
        this.pageTitle = (TextView)this.findViewById(R.id.tv_title);
        this.cardHolderEditText = (CardHolderEditText)this.findViewById(R.id.et_card_holder);
        this.cardNumberEditText = (CardNumberEditText)this.findViewById(R.id.et_card_number);
        this.expiryDateEditText = (ExpiryDateEditText)this.findViewById(R.id.et_expiry_date);
        this.securityCodeEditText = (CardFormEditText)this.findViewById(R.id.et_security_code);
        this.registrationButton = (Button)this.findViewById(R.id.btn_register);
        this.registrationButton.setOnClickListener(this.onRegisterButtonClickListener);
        this.cardHolderEditText.setValidationListener(this);
        this.cardNumberEditText.setValidationListener(this);
        this.expiryDateEditText.setValidationListener(this);
        this.securityCodeEditText.setValidationListener(this);
        this.inputValidStates.put(this.cardHolderEditText, true);
        this.inputValidStates.put(this.cardNumberEditText, false);
        this.inputValidStates.put(this.expiryDateEditText, false);
        this.inputValidStates.put(this.securityCodeEditText, true);
        this.progressBar = new ProgressBar(context, null, 16842874);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(13);
        this.addView((View)this.progressBar, (ViewGroup.LayoutParams)params);
        this.progressBar.setVisibility(4);
        this.resultListenerForInternal = this;
    }

    private void viewCustomization() {
        if (this.registrationGuiSetting == null) {
            return;
        }
        this.TitleCustomization();
        this.RegisterButtonCustomization();
        this.CardHolderCustomization();
        this.CardNumberCustomization();
        this.ExpiryDateCustomization();
        this.SecurityCodeCustomization();
    }

    private void TitleCustomization() {
        if (this.registrationGuiSetting.TitleText != null && this.registrationGuiSetting.TitleText.trim().length() > 0 && this.pageTitle != null) {
            this.pageTitle.setText((CharSequence)this.registrationGuiSetting.TitleText);
        }
    }

    private void RegisterButtonCustomization() {
        if (this.registrationButton != null) {
            if (this.registrationGuiSetting.RegisterButtonText != null && this.registrationGuiSetting.RegisterButtonText.trim().length() > 0 && this.registrationButton != null) {
                this.registrationButton.setText((CharSequence)this.registrationGuiSetting.RegisterButtonText);
            }
            if (this.registrationGuiSetting.RegisterButtonColor != null && this.registrationGuiSetting.RegisterButtonColor.trim().length() == 7) {
                int colorValue = Color.parseColor((String)this.registrationGuiSetting.RegisterButtonColor);
                this.registrationButton.setBackgroundColor(colorValue);
            }
        }
    }

    private void CardHolderCustomization() {
        if (this.cardHolderEditText != null && this.registrationGuiSetting.CardHolderWatermark != null && this.registrationGuiSetting.CardHolderWatermark.trim().length() > 0) {
            this.cardHolderEditText.setHint(this.registrationGuiSetting.CardHolderWatermark);
        }
    }

    private void CardNumberCustomization() {
        if (this.registrationGuiSetting.CardNumberWatermark != null && this.registrationGuiSetting.CardNumberWatermark.trim().length() > 0 && this.cardNumberEditText != null) {
            this.cardNumberEditText.setHint(this.registrationGuiSetting.CardNumberWatermark);
        }
    }

    private void ExpiryDateCustomization() {
        if (this.registrationGuiSetting.ExpiryDateWatermark != null && this.registrationGuiSetting.ExpiryDateWatermark.trim().length() > 0 && this.expiryDateEditText != null) {
            this.expiryDateEditText.setHint(this.registrationGuiSetting.ExpiryDateWatermark);
        }
    }

    private void SecurityCodeCustomization() {
        if (this.registrationGuiSetting.SecurityCodeWatermark != null && this.registrationGuiSetting.SecurityCodeWatermark.trim().length() > 0 && this.securityCodeEditText != null) {
            this.securityCodeEditText.setHint(this.registrationGuiSetting.SecurityCodeWatermark);
        }
    }

    private void updateButtonState() {
        boolean enabled = true;
        for (EditText key : this.inputValidStates.keySet()) {
            if (this.inputValidStates.get(key).booleanValue()) continue;
            enabled = false;
            break;
        }
        this.registrationButton.setEnabled(enabled);
    }

    private void startLoadingUI() {
        this.registrationButton.setEnabled(false);
        this.progressBar.setVisibility(0);
    }

    private void stopLoadingUI() {
        this.registrationButton.setEnabled(true);
        this.updateButtonState();
        this.progressBar.setVisibility(4);
    }

    @Override
    public void onRegistrationSuccess(CreditCard creditCard) {
        this.stopLoadingUI();
        this.resultListenerForExternal.onRegistrationSuccess(creditCard);
    }

    @Override
    public void onRegistrationError(RequestError error) {
        this.stopLoadingUI();
        this.resultListenerForExternal.onRegistrationError(error);
    }
}

