/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.utils;

import com.bambora.nativepayment.logging.BNLog;
import com.bambora.nativepayment.security.EncryptionCertificate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;

public class CertificateUtils {
    public static final String CERT_TYPE_X509 = "X.509";
    public static final String CERT_TYPE_PKCS7 = "PKCS7";
    public static final String UTF8_ENCODING = "UTF-8";

    public static Certificate loadCertificateFromResources(ClassLoader classLoader, String path) throws CertificateException {
        InputStream inputStream = classLoader.getResourceAsStream(path);
        CertificateFactory certificateFactory = CertificateFactory.getInstance(CERT_TYPE_X509);
        return certificateFactory.generateCertificate(inputStream);
    }

    public static X509Certificate[] loadCertChainFromResources(ClassLoader classLoader, String path) throws CertificateException {
        InputStream inputStream = classLoader.getResourceAsStream(path);
        CertificateFactory certificateFactory = CertificateFactory.getInstance(CERT_TYPE_X509);
        Collection<? extends Certificate> certs = certificateFactory.generateCertificates(inputStream);
        return CertificateUtils.toX509CertificateArray(certs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Certificate parseCertificate(String certificateString) {
        InputStream inputStream = null;
        Certificate certificate = null;
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance(CERT_TYPE_X509);
            inputStream = new ByteArrayInputStream(certificateString.getBytes(UTF8_ENCODING));
            certificate = certificateFactory.generateCertificate(inputStream);
        }
        catch (UnsupportedEncodingException | CertificateException e) {
            BNLog.e(EncryptionCertificate.class.getSimpleName(), "Failed to parse encryption certificate.", e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                BNLog.e(EncryptionCertificate.class.getSimpleName(), "Failed to close InputStream.", e);
            }
        }
        return certificate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate[] parseCertificateChain(String certificateString) {
        InputStream inputStream = null;
        Collection<? extends Certificate> certificates = null;
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance(CERT_TYPE_X509);
            inputStream = new ByteArrayInputStream(certificateString.getBytes(UTF8_ENCODING));
            certificates = certificateFactory.generateCertificates(inputStream);
        }
        catch (UnsupportedEncodingException | CertificateException e) {
            BNLog.e(EncryptionCertificate.class.getSimpleName(), "Failed to parse encryption certificate.", e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                BNLog.e(EncryptionCertificate.class.getSimpleName(), "Failed to close InputStream.", e);
            }
        }
        return CertificateUtils.toX509CertificateArray(certificates);
    }

    private static X509Certificate[] toX509CertificateArray(Collection<? extends Certificate> collection) {
        if (collection == null) {
            return new X509Certificate[0];
        }
        X509Certificate[] x509Certificates = new X509Certificate[collection.size()];
        Iterator<? extends Certificate> iterator = collection.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Certificate cert = iterator.next();
            if (!(cert instanceof X509Certificate)) continue;
            x509Certificates[i] = (X509Certificate)cert;
            ++i;
        }
        return x509Certificates;
    }
}

