/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.storage;

import android.content.Context;
import com.bambora.nativepayment.models.creditcard.CreditCard;
import com.bambora.nativepayment.security.EncryptionCertificate;
import com.bambora.nativepayment.storage.FileStorage;
import java.io.Serializable;

public class TransactionFileStorage
extends FileStorage {
    private static final String CREDIT_CARD_FILE_NAME = "credit-card";
    private static final String CERTIFICATES_FILE_NAME = "certificates";

    public void saveCreditCards(Context context, CreditCard[] creditCards, FileStorage.IOnObjectSaved listener) {
        this.saveObjectToDisk(context, CREDIT_CARD_FILE_NAME, (Serializable)creditCards, listener);
    }

    public void saveCreditCards(Context context, CreditCard[] creditCards) {
        this.saveCreditCards(context, creditCards, null);
    }

    public void getCreditCards(Context context, FileStorage.IOnObjectRead listener) {
        this.getObjectFromDisk(context, CREDIT_CARD_FILE_NAME, listener);
    }

    public void getEncryptionCertificates(Context context, FileStorage.IOnObjectRead listener) {
        this.getObjectFromDisk(context, CERTIFICATES_FILE_NAME, listener);
    }

    public void saveEncryptionCertificates(Context context, EncryptionCertificate[] certificates, FileStorage.IOnObjectSaved listener) {
        this.saveObjectToDisk(context, CERTIFICATES_FILE_NAME, (Serializable)certificates, listener);
    }
}

