/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.security;

import com.bambora.nativepayment.json.BNJsonObject;
import com.bambora.nativepayment.logging.BNLog;
import com.bambora.nativepayment.utils.CertificateUtils;
import com.bambora.nativepayment.utils.DateUtils;
import java.io.Serializable;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import org.json.JSONObject;

public class EncryptionCertificate
implements Serializable {
    private static final String KEY_FINGERPRINT = "fingerprint";
    private static final String KEY_CERTIFICATE = "certificate";
    private static final String KEY_VALID_FROM = "validFrom";
    private static final String KEY_VALID_TO = "validTo";
    private static final String KEY_UPDATE_INTERVAL = "updateInterval";
    private String fingerprint;
    private X509Certificate[] certificateChain;
    private Date validFrom;
    private Date validTo;
    private int updateInterval;

    public EncryptionCertificate(JSONObject jsonObject) {
        BNJsonObject bnJsonObject = BNJsonObject.copyFrom(jsonObject);
        this.fingerprint = bnJsonObject.optString(KEY_FINGERPRINT);
        this.certificateChain = CertificateUtils.parseCertificateChain(bnJsonObject.optString(KEY_CERTIFICATE));
        this.validFrom = bnJsonObject.optDate(KEY_VALID_FROM);
        this.validTo = bnJsonObject.optDate(KEY_VALID_TO);
        this.updateInterval = bnJsonObject.optInt(KEY_UPDATE_INTERVAL);
    }

    public EncryptionCertificate(String fingerprint, X509Certificate[] certificateChain, Date validTo, int updateInterval) {
        this.fingerprint = fingerprint;
        this.certificateChain = certificateChain;
        this.validTo = validTo;
        this.updateInterval = updateInterval;
    }

    public String getFingerprint() {
        return this.fingerprint.toUpperCase();
    }

    public Certificate getCertificate() {
        if (this.certificateChain != null && this.certificateChain.length > 0) {
            return this.certificateChain[0];
        }
        return null;
    }

    public PublicKey getPublicKey() {
        Certificate certificate = this.getCertificate();
        return certificate != null ? certificate.getPublicKey() : null;
    }

    public boolean isCloseToExpiry() {
        if (this.validTo != null) {
            Date now = new Date();
            return DateUtils.getDifferenceInDays(now, this.validTo) < this.updateInterval;
        }
        return true;
    }

    private boolean isTrusted(List<Certificate> masterCertificates, Certificate certificateToVerify) {
        for (Certificate masterCertificate : masterCertificates) {
            try {
                certificateToVerify.verify(masterCertificate.getPublicKey());
                return true;
            }
            catch (Exception exception) {
            }
        }
        BNLog.d(this.getClass().getSimpleName(), "No trusted certificate could be found");
        return false;
    }

    public boolean isChainTrusted(List<Certificate> masterCertificates) {
        for (X509Certificate certificate : this.certificateChain) {
            if (!this.isTrusted(masterCertificates, certificate)) continue;
            return true;
        }
        return false;
    }
}

