/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.network;

import com.bambora.nativepayment.interfaces.IJsonResponse;
import com.bambora.nativepayment.json.JsonContainer;
import com.bambora.nativepayment.logging.BNLog;
import com.bambora.nativepayment.network.HttpHeader;
import com.bambora.nativepayment.network.RequestError;

public class Response<T extends IJsonResponse<T>> {
    private static final String LOG_TAG = "BNNetworkResponse";
    public HttpHeader header;
    public RequestError error;
    private int responseCode;
    private String rawBody;
    private T body;

    public void setBody(String json, Class<T> bodyClass) {
        this.rawBody = json;
        this.body = this.parseBody(json, bodyClass);
    }

    public T getBody() {
        return this.body;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public String getRawBody() {
        return this.rawBody;
    }

    public String toString() {
        int maxBodySize = 500;
        StringBuilder builder = new StringBuilder().append("Response code: ").append(this.responseCode).append("\n\n");
        if (this.error != null) {
            builder.append(this.error.toString());
        }
        if (this.header != null) {
            builder.append("Response header:\n").append(this.header.toString()).append("\n");
        }
        if (this.rawBody != null && this.rawBody.length() > 0) {
            String truncatedBody = this.rawBody.length() > 500 ? this.rawBody.substring(0, 500) : this.rawBody;
            builder.append("Response body: (first 500 characters)\n").append(truncatedBody).append("\n");
        }
        return builder.toString();
    }

    private T parseBody(String json, Class<T> bodyClass) {
        try {
            IJsonResponse instance = (IJsonResponse)bodyClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            return (T)((IJsonResponse)instance.fromJson(new JsonContainer(json)));
        }
        catch (Exception exception) {
            BNLog.e(LOG_TAG, "Failed to parse JSON object " + bodyClass.getSimpleName() + " from string.", exception);
            return null;
        }
    }
}

