/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.network;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import com.bambora.nativepayment.interfaces.IJsonResponse;
import com.bambora.nativepayment.logging.BNLog;
import com.bambora.nativepayment.network.Callback;
import com.bambora.nativepayment.network.HttpClient;
import com.bambora.nativepayment.network.HttpHeader;
import com.bambora.nativepayment.network.Request;
import com.bambora.nativepayment.network.RequestError;
import com.bambora.nativepayment.network.Response;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import javax.net.ssl.HttpsURLConnection;

public class RequestExecutor<T extends IJsonResponse<T>> {
    private static final int BUFFER_SIZE = 5000;
    private static final String LOG_TAG = "BNRequestExecutor";
    private static final String UTF8_CHAR_ENCODING = "UTF-8";
    private Class<T> responseBodyClass;
    private Callback<T> callback;
    private HttpClient httpClient;

    public RequestExecutor(HttpClient client) {
        this.httpClient = client;
    }

    public void executeRequest(final Request<T> request, Class<T> responseClass, final Callback<T> callback) {
        this.callback = callback;
        this.responseBodyClass = responseClass;
        this.processRequest(request, new HttpClient.IProcessRequestListener(){

            @Override
            public void onRequestProcessed() {
                new DownloadJsonTask(request).executeOnExecutor(Executors.newCachedThreadPool(), null);
            }

            @Override
            public void onRequestError(RequestError error) {
                callback.onError(error);
            }
        });
    }

    private void processRequest(Request request, HttpClient.IProcessRequestListener listener) {
        if (this.httpClient != null) {
            this.httpClient.processRequest(request, listener);
        } else {
            listener.onRequestProcessed();
        }
    }

    private void notifyListener(final Response<T> response) {
        if (this.callback == null) {
            return;
        }
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (response.error != null) {
                    RequestExecutor.this.callback.onError(response.error);
                } else {
                    RequestExecutor.this.callback.onSuccess(response);
                }
            }
        });
    }

    class DownloadJsonTask
    extends AsyncTask<Void, Void, Response<T>> {
        private Request<T> request;

        public DownloadJsonTask(Request<T> request) {
            this.request = request;
        }

        protected Response<T> doInBackground(Void ... params) {
            if (this.request.getUrl().getPath().equalsIgnoreCase("/rapi/visacheckout_params")) {
                return this.mockVisaCheckParams();
            }
            if (this.request.getUrl().getPath().equalsIgnoreCase("/rapi/visacheckout_transaction")) {
                return this.mockVisaCheckoutTransaction();
            }
            return this.downloadJson();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Response<T> mockVisaCheckParams() {
            Response response = new Response();
            HttpsURLConnection connection = null;
            try {
                connection = (HttpsURLConnection)this.request.getUrl().openConnection();
                connection.setRequestMethod(this.request.getMethod());
                this.addHttpHeader(connection, this.request.getHeader());
                this.addRequestBody(connection, this.request.getRawBody());
                response.setResponseCode(200);
                response.header = new HttpHeader(this.request.getHeader());
                String jsonBody = "{\n    \"apikey\": \"ZW06OP7C8MA8S1NM9J79136ZKOZs_hlr-SdJPOEax5Ri9eBb4\",\n    \"currencyCode\": \"AUD\",\n    \"externalClientId\": \"c182d487-d94b-4907-bd74-eaa107b05ec7\",\n    \"externalProfileId\": \"IPPMerchant147942\",\n    \"locale\": \"en_AU\",\n    \"collectShipping\": \"true\",\n    \"message\" : \"Click to Pay Now\",\n    \"buttonAction\": \"Pay\",\n    \"buttonImageUrl\": \"https://sandbox.secure.checkout.visa.com/wallet-services-web/xo/button.png\",\n    \"jsLibraryUrl\" : \"https://sandbox-assets.secure.checkout.visa.com/checkout-widget/resources/js/integration/v1/sdk.js\"\n}\n";
                response.setBody(jsonBody, RequestExecutor.this.responseBodyClass);
                Thread.sleep(1000L);
            }
            catch (IOException exception) {
                response.error = new RequestError(exception);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
            BNLog.requestResult(RequestExecutor.LOG_TAG, this.request, response);
            return response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Response<T> mockVisaCheckoutTransaction() {
            Response response = new Response();
            HttpsURLConnection connection = null;
            try {
                connection = (HttpsURLConnection)this.request.getUrl().openConnection();
                connection.setRequestMethod(this.request.getMethod());
                this.addHttpHeader(connection, this.request.getHeader());
                this.addRequestBody(connection, this.request.getRawBody());
                response.setResponseCode(200);
                response.header = new HttpHeader(this.request.getHeader());
                String jsonBody = "{\n    \"currency\": \"AUD\",\n    \"operations\":\"\",\n    \"payment\": \"217001832\",\n    \"captures\": \"\",\n    \"state\": \"\",\n    \"region\": \"\",\n    \"operationInProgress\": \"false\",\n    \"amount\": 12000,\n    \"refunds\" : \"\",\n    \"comment\": \"\",\n    \"merchant\": \"d7e4e8e4-8e44-4895-9731-c6031792e3a3\",\n    \"receipt\": \"92055816\",\n    \"cardType\": \"\",\n    \"creditCardToken\": \"\",\n    \"cardHolderName\" : \"Mark\",\n    \"truncatedCard\": \"\"\n}\n";
                response.setBody(jsonBody, RequestExecutor.this.responseBodyClass);
                Thread.sleep(3000L);
            }
            catch (IOException exception) {
                response.error = new RequestError(exception);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
            BNLog.requestResult(RequestExecutor.LOG_TAG, this.request, response);
            return response;
        }

        protected void onPostExecute(Response<T> response) {
            RequestExecutor.this.notifyListener(response);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Response<T> downloadJson() {
            Response response = new Response();
            HttpsURLConnection connection = null;
            try {
                connection = (HttpsURLConnection)this.request.getUrl().openConnection();
                connection.setRequestMethod(this.request.getMethod());
                this.addHttpHeader(connection, this.request.getHeader());
                this.addRequestBody(connection, this.request.getRawBody());
                connection.connect();
                this.readErrorResponse(connection, response);
                response.setResponseCode(connection.getResponseCode());
                response.header = new HttpHeader((Map<? extends String, ? extends List<String>>)connection.getHeaderFields());
                if (response.error == null) {
                    this.readResponseBody(connection, response);
                }
            }
            catch (IOException exception) {
                response.error = new RequestError(exception);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
            BNLog.requestResult(RequestExecutor.LOG_TAG, this.request, response);
            return response;
        }

        private void addHttpHeader(URLConnection connection, HttpHeader header) {
            for (String key : header.keySet()) {
                for (String value : (List)header.get(key)) {
                    connection.addRequestProperty(key, value);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addRequestBody(URLConnection connection, String body) {
            if (body != null) {
                DataOutputStream outputStream = null;
                try {
                    outputStream = new DataOutputStream(connection.getOutputStream());
                    outputStream.write(body.getBytes(RequestExecutor.UTF8_CHAR_ENCODING));
                    outputStream.flush();
                }
                catch (IOException e) {
                    BNLog.e(RequestExecutor.LOG_TAG, "Failed to write to output stream.", e);
                }
                finally {
                    try {
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        BNLog.e(RequestExecutor.LOG_TAG, "Failed to close output stream.", e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readResponseBody(HttpsURLConnection connection, Response<T> response) {
            if (connection == null) {
                return;
            }
            BufferedInputStream inputStream = null;
            try {
                inputStream = new BufferedInputStream(connection.getInputStream());
                String jsonBody = this.readInputStream(inputStream);
                if (jsonBody == null || jsonBody.isEmpty() || "null".equalsIgnoreCase(jsonBody)) {
                    BNLog.d(RequestExecutor.LOG_TAG, "Null or emoty response body received. (" + jsonBody + ")");
                } else {
                    response.setBody(jsonBody, RequestExecutor.this.responseBodyClass);
                }
            }
            catch (IOException e) {
                BNLog.d(RequestExecutor.LOG_TAG, "No response body received. (" + e.getMessage() + ")");
            }
            finally {
                try {
                    if (inputStream != null) {
                        ((InputStream)inputStream).close();
                    }
                }
                catch (IOException e) {
                    BNLog.e(RequestExecutor.LOG_TAG, "Failed to close input stream.", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readErrorResponse(HttpsURLConnection connection, Response<T> response) {
            if (connection == null) {
                return;
            }
            InputStream errorInputStream = connection.getErrorStream();
            if (errorInputStream == null) {
                return;
            }
            RequestError error = new RequestError();
            try {
                String jsonBody = this.readInputStream(errorInputStream);
                error.setBody(jsonBody);
            }
            catch (IOException e) {
                BNLog.e(RequestExecutor.LOG_TAG, "Failed to read error input stream.", e);
            }
            finally {
                try {
                    errorInputStream.close();
                }
                catch (IOException e) {
                    BNLog.e(RequestExecutor.LOG_TAG, "Failed to close error input stream.", e);
                }
            }
            response.error = error;
        }

        private String readInputStream(InputStream inputStream) throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            InputStreamReader reader = new InputStreamReader(inputStream, RequestExecutor.UTF8_CHAR_ENCODING);
            this.readNext(reader, stringBuilder);
            return stringBuilder.toString();
        }

        private void readNext(Reader reader, StringBuilder stringBuilder) throws IOException {
            boolean endOfReader;
            char[] buffer = new char[5000];
            int count = reader.read(buffer);
            boolean bl = endOfReader = count < 0;
            if (!endOfReader) {
                stringBuilder.append(buffer, 0, count);
                this.readNext(reader, stringBuilder);
            }
        }
    }
}

