/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.network;

import com.bambora.nativepayment.logging.BNLog;
import com.bambora.nativepayment.network.ErrorBody;
import org.json.JSONException;

public class RequestError {
    private static final String LOG_TAG = "BNRequestError";
    private Throwable throwable;
    private ErrorBody body;
    private String rawBody;

    public RequestError() {
    }

    public RequestError(Throwable throwable) {
        this.throwable = throwable;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public ErrorBody getBody() {
        return this.body;
    }

    public void setBody(String jsonBody) {
        try {
            this.rawBody = jsonBody;
            this.body = ErrorBody.fromJson(jsonBody);
        }
        catch (JSONException e) {
            BNLog.e(LOG_TAG, "Failed to parse JSON object " + ErrorBody.class.getSimpleName() + " from string.", e);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.body != null) {
            builder.append("Error body:\n");
            builder.append("\t\tError status: ").append(this.body.status).append("\n");
            if (this.body.title != null) {
                builder.append("\t\t").append(this.body.title).append("\n");
            }
            if (this.body.detail != null) {
                builder.append("\t\t").append(this.body.detail).append("\n");
            }
            if (this.body.type != null) {
                builder.append("\t\t").append(this.body.type).append("\n");
            }
        } else {
            builder.append("Raw error body:\n").append(this.rawBody).append("\n");
        }
        if (this.throwable != null) {
            builder.append("Exception:");
            builder.append("\t\t").append(this.throwable.getMessage()).append(":\n").append(this.throwable.getClass());
        }
        return builder.toString();
    }
}

