/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.network;

import com.bambora.nativepayment.interfaces.IJsonRequest;
import com.bambora.nativepayment.interfaces.IJsonResponse;
import com.bambora.nativepayment.logging.BNLog;
import com.bambora.nativepayment.network.ApiService;
import com.bambora.nativepayment.network.Callback;
import com.bambora.nativepayment.network.HttpHeader;
import com.bambora.nativepayment.network.RequestExecutor;
import com.bambora.nativepayment.network.RequestMethod;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class Request<T extends IJsonResponse<T>> {
    private static final String LOG_TAG = "BNNetworkRequest";
    private ApiService service;
    private String endpoint;
    private Map<String, String> endpointParameters;
    private RequestMethod method = RequestMethod.GET;
    private HttpHeader header = new HttpHeader();
    private Class<T> responseClass;
    private IJsonRequest body;

    public Request(ApiService service, Class<T> responseClass) {
        this.service = service;
        this.responseClass = responseClass;
    }

    public Request<T> endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public Request<T> endpointParameter(String key, String value) {
        if (this.endpointParameters == null) {
            this.endpointParameters = new HashMap<String, String>();
        }
        this.endpointParameters.put(key, value);
        return this;
    }

    public Request<T> method(RequestMethod method) {
        this.method = method;
        return this;
    }

    public Request<T> header(String key, String value) {
        this.header.addField(key, value);
        return this;
    }

    public Request<T> body(IJsonRequest body) {
        this.body = body;
        return this;
    }

    public URL getUrl() {
        try {
            String formattedEndpoint = this.setEndpointParameters(this.endpoint);
            return new URL(this.service.createUrl(formattedEndpoint));
        }
        catch (MalformedURLException e) {
            BNLog.e(LOG_TAG, "Failed to create request. Invalid URL. ", e);
            return null;
        }
    }

    public String getMethod() {
        return this.method.value();
    }

    public HttpHeader getHeader() {
        return this.header;
    }

    public String getRawBody() {
        if (this.body != null) {
            return this.body.getSerialized();
        }
        return null;
    }

    public Class<T> getResponseClass() {
        return this.responseClass;
    }

    public void execute(Callback<T> callback) {
        new RequestExecutor<T>(this.service.getClient()).executeRequest(this, this.responseClass, callback);
    }

    public String toString() {
        int maxBodySize = 800;
        StringBuilder builder = new StringBuilder();
        builder.append("URL: ").append(this.getUrl()).append("\n").append("Request method: ").append((Object)this.method).append("\n").append("Request header:\n").append(this.header.toString());
        String rawBody = this.getRawBody();
        if (rawBody != null) {
            String truncatedBody = rawBody.length() > 800 ? rawBody.substring(0, 800) : rawBody;
            builder.append("Request body (first 800 characters):\n").append("\t\t").append(truncatedBody).append("\n");
        }
        return builder.toString();
    }

    private String setEndpointParameters(String endpoint) {
        String placeholderFormat = "{value}";
        if (this.endpointParameters != null) {
            for (String key : this.endpointParameters.keySet()) {
                String placeholder = placeholderFormat.replace("value", key);
                endpoint = endpoint.replace(placeholder, this.endpointParameters.get(key));
            }
        }
        return endpoint;
    }
}

