/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.models.creditcard;

import com.bambora.nativepayment.models.creditcard.RegistrationResultAction;
import com.bambora.nativepayment.models.creditcard.RegistrationResultMeta;
import com.bambora.nativepayment.utils.JsonUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class RegistrationResult {
    private static final String KEY_META = "meta";
    private static final String KEY_CARD_NUMBER = "truncatedcardnumber";
    private static final String KEY_CARD_HOLDER_NAME = "cardHolderName";
    private static final String KEY_EXPIRY_MONTH = "expmonth";
    private static final String KEY_EXPIRY_YEAR = "expyear";
    private static final String KEY_PAYMENT_TYPE = "paymenttype";
    private static final String KEY_TRANSACTION_ID = "transactionid";
    private static final String KEY_SUBSCRIPTION_ID = "subscriptionid";
    private static final String KEY_ORIGIN_IP = "originip";
    public final RegistrationResultMeta meta;
    public final String truncatedCardNumber;
    public final String cardHolderName;
    public final Integer expiryMonth;
    public final Integer expiryYear;
    public final String paymentType;
    public final String transactionId;
    public final String subscriptionId;
    public final String originIp;

    public RegistrationResult(JSONObject jsonObject) throws JSONException {
        JSONObject metaJson = JsonUtils.getJSONObjectIfExists(jsonObject, KEY_META);
        this.meta = metaJson != null ? new RegistrationResultMeta(metaJson) : null;
        this.truncatedCardNumber = JsonUtils.getStringIfExists(jsonObject, KEY_CARD_NUMBER);
        this.cardHolderName = JsonUtils.getStringIfExists(jsonObject, KEY_CARD_HOLDER_NAME);
        this.expiryMonth = JsonUtils.getIntIfExists(jsonObject, KEY_EXPIRY_MONTH);
        this.expiryYear = JsonUtils.getIntIfExists(jsonObject, KEY_EXPIRY_YEAR);
        this.paymentType = JsonUtils.getStringIfExists(jsonObject, KEY_PAYMENT_TYPE);
        this.transactionId = JsonUtils.getStringIfExists(jsonObject, KEY_TRANSACTION_ID);
        this.subscriptionId = JsonUtils.getStringIfExists(jsonObject, KEY_SUBSCRIPTION_ID);
        this.originIp = JsonUtils.getStringIfExists(jsonObject, KEY_ORIGIN_IP);
    }

    public static RegistrationResult fromJson(String jsonString) throws JSONException {
        JSONObject jsonObject = new JSONObject(jsonString);
        return new RegistrationResult(jsonObject);
    }

    public RegistrationResultAction.ActionCode getActionCode() {
        if (this.meta != null && this.meta.action != null) {
            return this.meta.action.getActionCode();
        }
        return RegistrationResultAction.ActionCode.UNKNOWN;
    }
}

