/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.models.creditcard;

import android.content.Context;
import android.util.Base64;
import com.bambora.nativepayment.handlers.BNPaymentHandler;
import com.bambora.nativepayment.interfaces.ICertificateLoadCallback;
import com.bambora.nativepayment.interfaces.IJsonRequest;
import com.bambora.nativepayment.logging.BNLog;
import com.bambora.nativepayment.managers.CertificateManager;
import com.bambora.nativepayment.security.Crypto;
import com.bambora.nativepayment.security.EncryptionCertificate;
import com.bambora.nativepayment.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RegistrationParams
implements IJsonRequest {
    private static final String KEY_ENCRYPTED_CARD = "encryptedCard";
    private static final String KEY_ENCRYPTED_SESSION_KEYS = "encryptedSessionKeys";
    private static final String KEY_BIN_NUMBER = "binNumber";
    private static final String KEY_REGISTRATION_DATA = "registrationJsonData";
    private static final int BIN_NUMBER_LENGTH = 6;
    public CardDetails encryptedCard;
    public List<EncryptedSessionKey> encryptedSessionKeys;
    public String binNumber;
    private final Crypto crypto;
    private final CertificateManager certificateManager;

    public RegistrationParams(Crypto crypto, CertificateManager certificateManager) {
        this.crypto = crypto;
        this.certificateManager = certificateManager;
    }

    public void setParametersAndEncrypt(Context context, String cardNumber, String expiryMonth, String expiryYear, String securityCode, final IOnEncryptionListener listener) {
        block3: {
            if (cardNumber != null) {
                cardNumber = StringUtils.stripAllNonDigits(cardNumber);
            }
            try {
                SecretKey sessionKey = this.generateSessionKey();
                this.encryptedCard = new CardDetails(cardNumber, securityCode, expiryMonth, expiryYear).encrypt(sessionKey);
                this.encryptSessionKey(context, sessionKey, new ISessionKeyEncryptionListener(){

                    @Override
                    public void onEncryptionComplete(List<EncryptedSessionKey> encryptedKeys) {
                        RegistrationParams.this.encryptedSessionKeys = encryptedKeys;
                        if (listener != null) {
                            listener.onEncryptionComplete();
                        }
                    }

                    @Override
                    public void onError() {
                        if (listener != null) {
                            listener.onEncryptionError();
                        }
                    }
                });
                this.binNumber = this.parseBinNumber(cardNumber);
            }
            catch (Exception exception) {
                BNLog.e(this.getClass().getSimpleName(), "Failed to encrypt card registration parameters.", exception);
                this.encryptedCard = null;
                this.encryptedSessionKeys = null;
                if (listener == null) break block3;
                listener.onEncryptionError();
            }
        }
    }

    public void setParametersAndEncrypt(Context context, String cardHolder, String cardNumber, String expiryMonth, String expiryYear, String securityCode, final IOnEncryptionListener listener) {
        block3: {
            if (cardNumber != null) {
                cardNumber = StringUtils.stripAllNonDigits(cardNumber);
            }
            try {
                SecretKey sessionKey = this.generateSessionKey();
                this.encryptedCard = new CardDetails(cardHolder, cardNumber, securityCode, expiryMonth, expiryYear).encrypt(sessionKey);
                this.encryptSessionKey(context, sessionKey, new ISessionKeyEncryptionListener(){

                    @Override
                    public void onEncryptionComplete(List<EncryptedSessionKey> encryptedKeys) {
                        RegistrationParams.this.encryptedSessionKeys = encryptedKeys;
                        if (listener != null) {
                            listener.onEncryptionComplete();
                        }
                    }

                    @Override
                    public void onError() {
                        if (listener != null) {
                            listener.onEncryptionError();
                        }
                    }
                });
                this.binNumber = this.parseBinNumber(cardNumber);
            }
            catch (Exception exception) {
                BNLog.e(this.getClass().getSimpleName(), "Failed to encrypt card registration parameters.", exception);
                this.encryptedCard = null;
                this.encryptedSessionKeys = null;
                if (listener == null) break block3;
                listener.onEncryptionError();
            }
        }
    }

    @Override
    public String getSerialized() {
        JSONObject jsonObject = new JSONObject();
        try {
            JSONObject registrationJsonData;
            if (this.encryptedCard != null) {
                jsonObject.put(KEY_ENCRYPTED_CARD, (Object)this.encryptedCard.getJsonObject());
            }
            if (this.encryptedSessionKeys != null) {
                JSONArray sessionKeys = new JSONArray();
                for (EncryptedSessionKey key : this.encryptedSessionKeys) {
                    sessionKeys.put((Object)key.getJsonObject());
                }
                jsonObject.put(KEY_ENCRYPTED_SESSION_KEYS, (Object)sessionKeys);
            }
            if ((registrationJsonData = BNPaymentHandler.getInstance().getRegistrationJsonData()) != null) {
                jsonObject.put(KEY_REGISTRATION_DATA, (Object)registrationJsonData);
            }
            jsonObject.putOpt(KEY_BIN_NUMBER, (Object)this.binNumber);
        }
        catch (JSONException e) {
            BNLog.jsonParseError(this.getClass().getSimpleName(), (Exception)((Object)e));
        }
        return jsonObject.toString();
    }

    private void encryptSessionKey(Context context, final SecretKey sessionKey, final ISessionKeyEncryptionListener listener) {
        this.certificateManager.getEncryptionCertificates(context, new ICertificateLoadCallback(){

            @Override
            public void onCertificatesLoaded(List<EncryptionCertificate> certificates) {
                if (certificates == null || certificates.isEmpty()) {
                    BNLog.e(RegistrationParams.class.getSimpleName(), "No valid encryption certificates. Encryption aborted.");
                    listener.onError();
                    return;
                }
                ArrayList<EncryptedSessionKey> sessionKeyList = new ArrayList<EncryptedSessionKey>();
                try {
                    for (EncryptionCertificate certificate : certificates) {
                        byte[] encryptedKey = RegistrationParams.this.crypto.RSAEncrypt(sessionKey.getEncoded(), certificate.getPublicKey());
                        String encodedKey = Base64.encodeToString((byte[])encryptedKey, (int)2);
                        sessionKeyList.add(new EncryptedSessionKey(certificate.getFingerprint(), encodedKey));
                    }
                    listener.onEncryptionComplete(sessionKeyList);
                }
                catch (UnsupportedEncodingException | GeneralSecurityException e) {
                    BNLog.e(RegistrationParams.class.getSimpleName(), "Failed to encrypt data.", e);
                    listener.onError();
                }
            }

            @Override
            public void onError() {
                listener.onError();
            }
        });
    }

    private SecretKey generateSessionKey() throws NoSuchAlgorithmException {
        return this.crypto.generateRandomAES128();
    }

    private String parseBinNumber(String cardNumber) {
        if (cardNumber.length() >= 6) {
            return cardNumber.substring(0, 6);
        }
        return null;
    }

    public class EncryptedSessionKey {
        private static final String KEY_FINGERPRINT = "fingerprint";
        private static final String KEY_SESSION_KEY = "sessionKey";
        public String fingerprint;
        public String sessionKey;

        public EncryptedSessionKey(String fingerprint, String sessionKey) {
            this.fingerprint = fingerprint;
            this.sessionKey = sessionKey;
        }

        public JSONObject getJsonObject() {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put(KEY_FINGERPRINT, (Object)this.fingerprint);
                jsonObject.put(KEY_SESSION_KEY, (Object)this.sessionKey);
            }
            catch (JSONException e) {
                BNLog.jsonParseError(this.getClass().getSimpleName(), (Exception)((Object)e));
            }
            return jsonObject;
        }
    }

    public class CardDetails {
        private static final String KEY_CARD_HOLDER = "cardholderName";
        private static final String KEY_CARD_NUMBER = "cardNumber";
        private static final String KEY_CVC_CODE = "cvcCode";
        private static final String KEY_EXPIRY_MONTH = "expiryMonth";
        private static final String KEY_EXPIRY_YEAR = "expiryYear";
        public String cardHolder;
        public String cardNumber;
        public String securityCode;
        public String expiryMonth;
        public String expiryYear;

        public CardDetails(String cardNumber, String securityCode, String expiryMonth, String expiryYear) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, UnsupportedEncodingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
            this("", cardNumber, securityCode, expiryMonth, expiryYear);
        }

        public CardDetails(String cardHolder, String cardNumber, String securityCode, String expiryMonth, String expiryYear) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, UnsupportedEncodingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
            this.cardHolder = cardHolder;
            this.cardNumber = cardNumber;
            this.securityCode = securityCode;
            this.expiryMonth = expiryMonth;
            this.expiryYear = expiryYear;
        }

        public JSONObject getJsonObject() {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put(KEY_CARD_HOLDER, (Object)this.cardHolder);
                jsonObject.put(KEY_CARD_NUMBER, (Object)this.cardNumber);
                jsonObject.put(KEY_CVC_CODE, (Object)this.securityCode);
                jsonObject.put(KEY_EXPIRY_MONTH, (Object)this.expiryMonth);
                jsonObject.put(KEY_EXPIRY_YEAR, (Object)this.expiryYear);
            }
            catch (JSONException e) {
                BNLog.jsonParseError(this.getClass().getSimpleName(), (Exception)((Object)e));
            }
            return jsonObject;
        }

        public CardDetails encrypt(SecretKey privateKey) throws NoSuchPaddingException, BadPaddingException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IllegalBlockSizeException, UnsupportedEncodingException, InvalidKeyException {
            this.cardHolder = RegistrationParams.this.crypto.AESEncryptAndEncode(this.cardHolder, privateKey);
            this.cardNumber = RegistrationParams.this.crypto.AESEncryptAndEncode(this.cardNumber, privateKey);
            this.expiryYear = RegistrationParams.this.crypto.AESEncryptAndEncode(this.expiryYear, privateKey);
            this.expiryMonth = RegistrationParams.this.crypto.AESEncryptAndEncode(this.expiryMonth, privateKey);
            this.securityCode = RegistrationParams.this.crypto.AESEncryptAndEncode(this.securityCode, privateKey);
            return this;
        }
    }

    public static interface ISessionKeyEncryptionListener {
        public void onEncryptionComplete(List<EncryptedSessionKey> var1);

        public void onError();
    }

    public static interface IOnEncryptionListener {
        public void onEncryptionComplete();

        public void onEncryptionError();
    }
}

