/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.models.creditcard;

import com.bambora.nativepayment.interfaces.IJsonRequest;
import com.bambora.nativepayment.logging.BNLog;
import org.json.JSONException;
import org.json.JSONObject;

public class RegistrationFormSettings
implements IJsonRequest {
    private static final String INPUT_GROUP_CARD_NUMBER = "cardnumber";
    private static final String INPUT_GROUP_EXPIRY_DATE = "cardexpiry";
    private static final String INPUT_GROUP_CVV = "cardverification";
    private static final String KEY_PLATFORM = "platform";
    private static final String KEY_CSS_URL = "cssurl";
    private static final String KEY_CARD_NUMBER = "cardNumber";
    private static final String KEY_CARD_EXPIRY = "cardExpiry";
    private static final String KEY_CARD_VERIFICATION = "cardVerification";
    private static final String KEY_SUBMIT_BUTTON = "submitbutton";
    private InputGroup cardNumberInputGroup = new InputGroup("cardnumber");
    private InputGroup cardExpiryDateInputGroup = new InputGroup("cardexpiry");
    private InputGroup cardCvvInputGroup = new InputGroup("cardverification");
    private static final String PLATFORM = "android";
    private String cssUrl;
    private String submitButtonText;

    public void setCssUrl(String cssUrl) {
        this.cssUrl = cssUrl;
    }

    public void setCardNumberInputHint(String text) {
        this.cardNumberInputGroup.placeholder = text;
    }

    public void setCardExpiryInputHint(String text) {
        this.cardExpiryDateInputGroup.placeholder = text;
    }

    public void setCvvInputHint(String text) {
        this.cardCvvInputGroup.placeholder = text;
    }

    public void setSubmitButtonText(String text) {
        this.submitButtonText = text;
    }

    @Override
    public String getSerialized() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(KEY_PLATFORM, (Object)PLATFORM);
            jsonObject.put(KEY_CSS_URL, (Object)this.cssUrl);
            jsonObject.put(KEY_CARD_NUMBER, (Object)new JSONObject(this.cardNumberInputGroup.getSerialized()));
            jsonObject.put(KEY_CARD_EXPIRY, (Object)new JSONObject(this.cardExpiryDateInputGroup.getSerialized()));
            jsonObject.put(KEY_CARD_VERIFICATION, (Object)new JSONObject(this.cardCvvInputGroup.getSerialized()));
            jsonObject.put(KEY_SUBMIT_BUTTON, (Object)this.submitButtonText);
        }
        catch (JSONException e) {
            BNLog.jsonParseError(this.getClass().getSimpleName(), (Exception)((Object)e));
        }
        return jsonObject.toString().replace("\\", "");
    }

    public class InputGroup
    implements IJsonRequest {
        private static final String KEY_NAME = "name";
        private static final String KEY_PLACEHOLDER = "placeholder";
        private String name;
        private String placeholder;

        public InputGroup(String name) {
            this(name, "");
        }

        public InputGroup(String name, String placeholder) {
            this.name = name;
            this.placeholder = placeholder;
        }

        @Override
        public String getSerialized() {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put(KEY_NAME, (Object)this.name);
                jsonObject.put(KEY_PLACEHOLDER, (Object)this.placeholder);
            }
            catch (JSONException e) {
                BNLog.jsonParseError(this.getClass().getSimpleName(), (Exception)((Object)e));
            }
            return jsonObject.toString();
        }
    }
}

