/*
 * Decompiled with CFR 0.152.
 */
package com.bambora.nativepayment.managers;

import android.content.Context;
import com.bambora.nativepayment.interfaces.ICardRegistrationCallback;
import com.bambora.nativepayment.managers.CertificateManager;
import com.bambora.nativepayment.models.creditcard.CreditCard;
import com.bambora.nativepayment.models.creditcard.RegistrationParams;
import com.bambora.nativepayment.network.RequestError;
import com.bambora.nativepayment.security.Crypto;
import com.bambora.nativepayment.services.PaymentApiService;
import com.bambora.nativepayment.storage.FileStorage;
import com.bambora.nativepayment.storage.TransactionFileStorage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class CreditCardManager {
    private TransactionFileStorage fileStorage = new TransactionFileStorage();

    public void registerCreditCard(final Context context, String cardNumber, String expiryMonth, String expiryYear, String securityCode, final ICardRegistrationCallback listener) {
        final RegistrationParams params = new RegistrationParams(new Crypto(), CertificateManager.getInstance());
        params.setParametersAndEncrypt(context, cardNumber, expiryMonth, expiryYear, securityCode, new RegistrationParams.IOnEncryptionListener(){

            @Override
            public void onEncryptionComplete() {
                CreditCardManager.this.registerCreditCard(context, params, listener);
            }

            @Override
            public void onEncryptionError() {
                if (listener != null) {
                    listener.onRegistrationError(null);
                }
            }
        });
    }

    public void registerCreditCard(final Context context, String cardHolder, String cardNumber, String expiryMonth, String expiryYear, String securityCode, final ICardRegistrationCallback listener) {
        final RegistrationParams params = new RegistrationParams(new Crypto(), CertificateManager.getInstance());
        params.setParametersAndEncrypt(context, cardHolder, cardNumber, expiryMonth, expiryYear, securityCode, new RegistrationParams.IOnEncryptionListener(){

            @Override
            public void onEncryptionComplete() {
                CreditCardManager.this.registerCreditCard(context, params, listener);
            }

            @Override
            public void onEncryptionError() {
                if (listener != null) {
                    listener.onRegistrationError(null);
                }
            }
        });
    }

    private void registerCreditCard(final Context context, RegistrationParams params, final ICardRegistrationCallback listener) {
        PaymentApiService.PaymentService.registerCreditCard(params, new ICardRegistrationCallback(){

            @Override
            public void onRegistrationSuccess(CreditCard creditCard) {
                CreditCardManager.this.saveCreditCard(context, creditCard, new IOnCreditCardSaved(){

                    @Override
                    public void onCreditCardSaved(CreditCard creditCard) {
                        if (listener != null) {
                            listener.onRegistrationSuccess(creditCard);
                        }
                    }
                });
            }

            @Override
            public void onRegistrationError(RequestError error) {
                if (listener != null) {
                    listener.onRegistrationError(error);
                }
            }
        });
    }

    public void saveCreditCard(final Context context, final CreditCard creditCard, final IOnCreditCardSaved onSavedListener) {
        this.getCreditCards(context, new IOnCreditCardRead(){

            @Override
            public void onCreditCardRead(List<CreditCard> storedCreditCards) {
                int location = CreditCardManager.this.getLocationInList(storedCreditCards, creditCard);
                if (location >= 0) {
                    storedCreditCards.remove(location);
                    storedCreditCards.add(location, creditCard);
                } else {
                    storedCreditCards.add(creditCard);
                }
                OnCardSavedNotifier onCardSaved = new OnCardSavedNotifier(creditCard, onSavedListener);
                CreditCardManager.this.fileStorage.saveCreditCards(context, CreditCardManager.this.toArray(storedCreditCards), onCardSaved);
            }
        });
    }

    public void getCreditCards(Context context, final IOnCreditCardRead listener) {
        if (listener == null) {
            return;
        }
        this.fileStorage.getCreditCards(context, new FileStorage.IOnObjectRead(){

            @Override
            public void notifyOnObjectRead(Serializable object) {
                CreditCard[] creditCards = object instanceof CreditCard[] ? (CreditCard[])object : new CreditCard[]{};
                listener.onCreditCardRead(new ArrayList<CreditCard>(Arrays.asList(creditCards)));
            }
        });
    }

    public void deleteCreditCard(final Context context, final String creditCardToken, final IOnCreditCardDeleted listener) {
        final FileStorage.IOnObjectSaved onObjectSavedListener = new FileStorage.IOnObjectSaved(){

            @Override
            public void notifyOnObjectSaved() {
                if (listener != null) {
                    listener.onCreditCardDeleted();
                }
            }
        };
        this.getCreditCards(context, new IOnCreditCardRead(){

            @Override
            public void onCreditCardRead(List<CreditCard> creditCards) {
                List newList = CreditCardManager.this.removeFromList(creditCards, creditCardToken);
                CreditCardManager.this.fileStorage.saveCreditCards(context, CreditCardManager.this.toArray(newList), onObjectSavedListener);
            }
        });
    }

    public void deleteAllCreditCards(final Context context, final IOnCreditCardDeleted listener) {
        final FileStorage.IOnObjectSaved onObjectSavedListener = new FileStorage.IOnObjectSaved(){

            @Override
            public void notifyOnObjectSaved() {
                if (listener != null) {
                    listener.onCreditCardDeleted();
                }
            }
        };
        this.getCreditCards(context, new IOnCreditCardRead(){

            @Override
            public void onCreditCardRead(List<CreditCard> creditCards) {
                creditCards.clear();
                CreditCardManager.this.fileStorage.saveCreditCards(context, CreditCardManager.this.toArray(creditCards), onObjectSavedListener);
            }
        });
    }

    public void setAlias(final Context context, final String alias, final String token, final IOnCreditCardSaved listener) {
        this.getCreditCards(context, new IOnCreditCardRead(){

            @Override
            public void onCreditCardRead(List<CreditCard> creditCards) {
                CreditCard creditCard = CreditCardManager.this.findCreditCardInList(creditCards, token);
                if (creditCard != null) {
                    creditCard.setAlias(alias);
                    OnCardSavedNotifier onCardUpdated = new OnCardSavedNotifier(creditCard, listener);
                    CreditCardManager.this.fileStorage.saveCreditCards(context, CreditCardManager.this.toArray(creditCards), onCardUpdated);
                }
            }
        });
    }

    private boolean existsIn(List<CreditCard> listToSearch, CreditCard cardToFind) {
        for (CreditCard card : listToSearch) {
            if (!card.isEqualTo(cardToFind)) continue;
            return true;
        }
        return false;
    }

    private CreditCard[] toArray(List<CreditCard> creditCardList) {
        CreditCard[] creditCardArray = new CreditCard[creditCardList.size()];
        return creditCardList.toArray(creditCardArray);
    }

    private List<CreditCard> removeFromList(List<CreditCard> creditCardList, String token) {
        Iterator<CreditCard> iterator = creditCardList.iterator();
        while (iterator.hasNext()) {
            CreditCard creditCard = iterator.next();
            if (!creditCard.getCreditCardToken().equals(token)) continue;
            iterator.remove();
        }
        return creditCardList;
    }

    private int getLocationInList(List<CreditCard> creditCardList, CreditCard creditCard) {
        for (int location = 0; location < creditCardList.size(); ++location) {
            if (!creditCardList.get(location).isEqualTo(creditCard)) continue;
            return location;
        }
        return -1;
    }

    private CreditCard findCreditCardInList(List<CreditCard> creditCardList, String token) {
        for (CreditCard creditCard : creditCardList) {
            if (!creditCard.getCreditCardToken().equals(token)) continue;
            return creditCard;
        }
        return null;
    }

    private class OnCardSavedNotifier
    implements FileStorage.IOnObjectSaved {
        private CreditCard creditCard;
        private IOnCreditCardSaved onCreditCardSaved;

        public OnCardSavedNotifier(CreditCard creditCard, IOnCreditCardSaved onCreditCardSaved) {
            this.creditCard = creditCard;
            this.onCreditCardSaved = onCreditCardSaved;
        }

        @Override
        public void notifyOnObjectSaved() {
            if (this.onCreditCardSaved != null) {
                this.onCreditCardSaved.onCreditCardSaved(this.creditCard);
            }
        }
    }

    public static interface IOnCreditCardDeleted {
        public void onCreditCardDeleted();
    }

    public static interface IOnCreditCardSaved {
        public void onCreditCardSaved(CreditCard var1);
    }

    public static interface IOnCreditCardRead {
        public void onCreditCardRead(List<CreditCard> var1);
    }
}

