/*
 * Decompiled with CFR 0.152.
 */
package com.bakerj.infinitecards;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.BaseAdapter;
import com.bakerj.infinitecards.AnimationTransformer;
import com.bakerj.infinitecards.CardItem;
import com.bakerj.infinitecards.InfiniteCardView;
import com.bakerj.infinitecards.ZIndexTransformer;
import com.bakerj.infinitecards.transformer.DefaultCommonTransformer;
import com.bakerj.infinitecards.transformer.DefaultTransformerAdd;
import com.bakerj.infinitecards.transformer.DefaultTransformerRemove;
import com.bakerj.infinitecards.transformer.DefaultTransformerToBack;
import com.bakerj.infinitecards.transformer.DefaultTransformerToFront;
import com.bakerj.infinitecards.transformer.DefaultZIndexTransformerCommon;
import com.bakerj.infinitecards.transformer.DefaultZIndexTransformerToFront;
import java.util.LinkedList;

class CardAnimationHelper
implements Animator.AnimatorListener,
ValueAnimator.AnimatorUpdateListener {
    static final int ANIM_DURATION = 1000;
    static final int ANIM_ADD_REMOVE_DELAY = 200;
    static final int ANIM_ADD_REMOVE_DURATION = 500;
    private int mAnimType = 0;
    private int mAnimDuration = 1000;
    private int mAnimAddRemoveDelay = 200;
    private int mAnimAddRemoveDuration = 500;
    private InfiniteCardView mCardView;
    private LinkedList<CardItem> mCards;
    private int mCardCount;
    private CardItem mCardToBack;
    private CardItem mCardToFront;
    private int mPositionToBack = 0;
    private int mPositionToFront = 0;
    private int mCardWidth;
    private int mCardHeight;
    private boolean mIsAnim = false;
    private boolean mIsAddRemoveAnim = false;
    private ValueAnimator mValueAnimator;
    private AnimationTransformer mTransformerToFront;
    private AnimationTransformer mTransformerToBack;
    private AnimationTransformer mTransformerCommon;
    private AnimationTransformer mTransformerAnimAdd;
    private AnimationTransformer mTransformerAnimRemove;
    private ZIndexTransformer mZIndexTransformerToFront;
    private ZIndexTransformer mZIndexTransformerToBack;
    private ZIndexTransformer mZIndexTransformerCommon;
    private Interpolator mAnimInterpolator;
    private Interpolator mAnimAddRemoveInterpolator;
    private BaseAdapter mTempAdapter;
    private float mCurrentFraction = 1.0f;
    private InfiniteCardView.CardAnimationListener mCardAnimationListener;

    CardAnimationHelper(int mAnimType, int mAnimDuration, InfiniteCardView infiniteCardView) {
        this.mAnimType = mAnimType;
        this.mAnimDuration = mAnimDuration;
        this.mCardView = infiniteCardView;
        this.initTransformer();
        this.initAnimator();
    }

    private void initTransformer() {
        this.mAnimInterpolator = new LinearInterpolator();
        this.mAnimAddRemoveInterpolator = new LinearInterpolator();
        this.mTransformerToFront = new DefaultTransformerToFront();
        this.mTransformerToBack = new DefaultTransformerToBack();
        this.mTransformerCommon = new DefaultCommonTransformer();
        this.mTransformerAnimAdd = new DefaultTransformerAdd();
        this.mTransformerAnimRemove = new DefaultTransformerRemove();
        this.mZIndexTransformerToFront = new DefaultZIndexTransformerToFront();
        this.mZIndexTransformerToBack = new DefaultZIndexTransformerCommon();
        this.mZIndexTransformerCommon = new DefaultZIndexTransformerCommon();
    }

    private void initAnimator() {
        this.mValueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f}).setDuration((long)this.mAnimDuration);
        this.mValueAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
        this.mValueAnimator.addListener((Animator.AnimatorListener)this);
    }

    public void onAnimationUpdate(ValueAnimator animation) {
        float fractionInterpolated = this.mCurrentFraction = ((Float)animation.getAnimatedValue()).floatValue();
        if (this.mAnimInterpolator != null) {
            fractionInterpolated = this.mAnimInterpolator.getInterpolation(this.mCurrentFraction);
        }
        this.doAnimationBackToFront(this.mCurrentFraction, fractionInterpolated);
        this.doAnimationFrontToBack(this.mCurrentFraction, fractionInterpolated);
        this.doAnimationCommon(this.mCurrentFraction, fractionInterpolated);
        this.bringToFrontByZIndex();
    }

    private void doAnimationBackToFront(float fraction, float fractionInterpolated) {
        this.mTransformerToFront.transformAnimation(this.mCardToFront.view, fraction, this.mCardWidth, this.mCardHeight, this.mPositionToFront, 0);
        if (this.mAnimInterpolator != null) {
            this.mTransformerToFront.transformInterpolatedAnimation(this.mCardToFront.view, fractionInterpolated, this.mCardWidth, this.mCardHeight, this.mPositionToFront, 0);
        }
        this.doAnimationZIndex(this.mZIndexTransformerToFront, this.mCardToFront, fraction, fractionInterpolated, this.mPositionToFront, 0);
    }

    private void doAnimationFrontToBack(float fraction, float fractionInterpolated) {
        if (this.mAnimType == 0) {
            return;
        }
        this.mTransformerToBack.transformAnimation(this.mCardToBack.view, fraction, this.mCardWidth, this.mCardHeight, 0, this.mPositionToBack);
        if (this.mAnimInterpolator != null) {
            this.mTransformerToBack.transformInterpolatedAnimation(this.mCardToBack.view, fractionInterpolated, this.mCardWidth, this.mCardHeight, 0, this.mPositionToBack);
        }
        this.doAnimationZIndex(this.mZIndexTransformerToBack, this.mCardToBack, fraction, fractionInterpolated, 0, this.mPositionToBack);
    }

    private void doAnimationCommon(float fraction, float fractionInterpolated) {
        block3: {
            block2: {
                if (this.mAnimType != 0) break block2;
                for (int i = 0; i < this.mPositionToFront; ++i) {
                    CardItem card = this.mCards.get(i);
                    this.doAnimationCommonView(card.view, fraction, fractionInterpolated, i, i + 1);
                    this.doAnimationZIndex(this.mZIndexTransformerCommon, card, fraction, fractionInterpolated, i, i + 1);
                }
                break block3;
            }
            if (this.mAnimType != 2) break block3;
            for (int i = this.mPositionToFront + 1; i < this.mCardCount; ++i) {
                CardItem card = this.mCards.get(i);
                this.doAnimationCommonView(card.view, fraction, fractionInterpolated, i, i - 1);
                this.doAnimationZIndex(this.mZIndexTransformerCommon, card, fraction, fractionInterpolated, i, i - 1);
            }
        }
    }

    private void doAnimationCommonView(View view, float fraction, float fractionInterpolated, int fromPosition, int toPosition) {
        this.mTransformerCommon.transformAnimation(view, fraction, this.mCardWidth, this.mCardHeight, fromPosition, toPosition);
        if (this.mAnimInterpolator != null) {
            this.mTransformerCommon.transformInterpolatedAnimation(view, fractionInterpolated, this.mCardWidth, this.mCardHeight, fromPosition, toPosition);
        }
    }

    private void doAnimationZIndex(ZIndexTransformer transformer, CardItem card, float fraction, float fractionInterpolated, int fromPosition, int toPosition) {
        transformer.transformAnimation(card, fraction, this.mCardWidth, this.mCardHeight, fromPosition, toPosition);
        if (this.mAnimInterpolator != null) {
            transformer.transformInterpolatedAnimation(card, fractionInterpolated, this.mCardWidth, this.mCardHeight, fromPosition, toPosition);
        }
    }

    private void bringToFrontByZIndex() {
        if (this.mAnimType == 0) {
            for (int i = this.mPositionToFront - 1; i >= 0; --i) {
                CardItem card = this.mCards.get(i);
                if (card.zIndex > this.mCardToFront.zIndex) {
                    this.mCardToFront.view.bringToFront();
                    this.mCardView.updateViewLayout(this.mCardToFront.view, this.mCardToFront.view.getLayoutParams());
                    continue;
                }
                card.view.bringToFront();
                this.mCardView.updateViewLayout(card.view, card.view.getLayoutParams());
            }
        } else {
            boolean cardToFrontBrought = false;
            for (int i = this.mCardCount - 1; i > 0; --i) {
                boolean bringCardToFrontViewToFront;
                CardItem card = this.mCards.get(i);
                CardItem cardPre = i > 1 ? this.mCards.get(i - 1) : null;
                boolean cardToBackBehindCardPre = cardPre == null || this.mCardToBack.zIndex > cardPre.zIndex;
                boolean bringCardToBackViewToFront = this.mCardToBack.zIndex < card.zIndex && cardToBackBehindCardPre;
                boolean cardToFrontBehindCardPre = cardPre == null || this.mCardToFront.zIndex > cardPre.zIndex;
                boolean bl = bringCardToFrontViewToFront = this.mCardToFront.zIndex < card.zIndex && cardToFrontBehindCardPre;
                if (i != this.mPositionToFront) {
                    card.view.bringToFront();
                    this.mCardView.updateViewLayout(card.view, card.view.getLayoutParams());
                    if (bringCardToBackViewToFront) {
                        this.mCardToBack.view.bringToFront();
                        this.mCardView.updateViewLayout(this.mCardToBack.view, this.mCardToBack.view.getLayoutParams());
                    }
                    if (bringCardToFrontViewToFront) {
                        this.mCardToFront.view.bringToFront();
                        this.mCardView.updateViewLayout(this.mCardToFront.view, this.mCardToFront.view.getLayoutParams());
                        cardToFrontBrought = true;
                    }
                    if (!bringCardToBackViewToFront || !bringCardToFrontViewToFront || !(this.mCardToBack.zIndex < this.mCardToFront.zIndex)) continue;
                    this.mCardToBack.view.bringToFront();
                    this.mCardView.updateViewLayout(this.mCardToBack.view, this.mCardToBack.view.getLayoutParams());
                    continue;
                }
                if (!cardToFrontBehindCardPre) continue;
                this.mCardToFront.view.bringToFront();
                this.mCardView.updateViewLayout(this.mCardToFront.view, this.mCardToFront.view.getLayoutParams());
                cardToFrontBrought = true;
                if (!cardToBackBehindCardPre || !(this.mCardToBack.zIndex < this.mCardToFront.zIndex)) continue;
                this.mCardToBack.view.bringToFront();
                this.mCardView.updateViewLayout(this.mCardToBack.view, this.mCardToBack.view.getLayoutParams());
            }
            if (!cardToFrontBrought) {
                this.mCardToFront.view.bringToFront();
                this.mCardView.updateViewLayout(this.mCardToFront.view, this.mCardToFront.view.getLayoutParams());
            }
        }
    }

    public void onAnimationStart(Animator animation) {
        this.mCurrentFraction = 0.0f;
        if (this.mCardAnimationListener != null) {
            this.mCardAnimationListener.onAnimationStart();
        }
    }

    public void onAnimationEnd(Animator animation) {
        if (this.mAnimType == 0) {
            this.mCards.remove(this.mPositionToFront);
            this.mCards.addFirst(this.mCardToFront);
        } else if (this.mAnimType == 1) {
            this.mCards.remove(this.mPositionToFront);
            this.mCards.removeFirst();
            this.mCards.addFirst(this.mCardToFront);
            this.mCards.add(this.mPositionToFront, this.mCardToBack);
        } else {
            this.mCards.remove(this.mPositionToFront);
            this.mCards.removeFirst();
            this.mCards.addFirst(this.mCardToFront);
            this.mCards.addLast(this.mCardToBack);
        }
        this.mPositionToFront = 0;
        this.mPositionToBack = 0;
        this.mCurrentFraction = 1.0f;
        this.mIsAnim = false;
        if (this.mTempAdapter != null) {
            this.notifyDataSetChanged(this.mTempAdapter);
        }
        if (this.mCardAnimationListener != null) {
            this.mCardAnimationListener.onAnimationEnd();
        }
    }

    public void onAnimationCancel(Animator animation) {
    }

    public void onAnimationRepeat(Animator animation) {
    }

    void initAdapterView(BaseAdapter adapter, boolean reset) {
        if (this.mCardWidth > 0 && this.mCardHeight > 0) {
            if (this.mCards == null) {
                this.mCardView.removeAllViews();
                this.firstSetAdapter(adapter);
            } else if (reset || this.mCards.size() != adapter.getCount()) {
                this.resetAdapter(adapter);
            } else {
                this.notifySetAdapter(adapter);
            }
        }
    }

    private void resetAdapter(BaseAdapter adapter) {
        if (this.mTransformerAnimRemove == null) {
            this.mCardView.removeAllViews();
            this.firstSetAdapter(adapter);
        } else {
            this.mIsAddRemoveAnim = true;
            for (int i = 0; i < this.mCardCount; ++i) {
                CardItem cardItem = this.mCards.get(i);
                this.showAnimRemove(cardItem.view, this.mAnimAddRemoveDelay * i, i, i == this.mCardCount - 1, adapter);
            }
        }
    }

    private void showAnimRemove(final View view, int delay, final int position, final boolean isLast, final BaseAdapter adapter) {
        final ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f}).setDuration((long)this.mAnimAddRemoveDuration);
        valueAnimator.setStartDelay((long)delay);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float fraction = ((Float)animation.getAnimatedValue()).floatValue();
                CardAnimationHelper.this.mTransformerAnimRemove.transformAnimation(view, fraction, CardAnimationHelper.this.mCardWidth, CardAnimationHelper.this.mCardHeight, position, position);
                if (CardAnimationHelper.this.mAnimAddRemoveInterpolator != null) {
                    CardAnimationHelper.this.mTransformerAnimRemove.transformInterpolatedAnimation(view, CardAnimationHelper.this.mAnimAddRemoveInterpolator.getInterpolation(fraction), CardAnimationHelper.this.mCardWidth, CardAnimationHelper.this.mCardHeight, position, position);
                }
            }
        });
        valueAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                view.setVisibility(8);
                if (isLast) {
                    CardAnimationHelper.this.mIsAddRemoveAnim = false;
                    CardAnimationHelper.this.mCardView.removeAllViews();
                    if (CardAnimationHelper.this.mTempAdapter != null) {
                        CardAnimationHelper.this.notifyDataSetChanged(CardAnimationHelper.this.mTempAdapter);
                    } else {
                        CardAnimationHelper.this.firstSetAdapter(adapter);
                    }
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        this.mCardView.post(new Runnable(){

            @Override
            public void run() {
                valueAnimator.start();
            }
        });
    }

    private void firstSetAdapter(BaseAdapter adapter) {
        if (this.mTransformerAnimAdd != null) {
            this.mIsAddRemoveAnim = true;
        }
        this.mCards = new LinkedList();
        this.mCardCount = adapter.getCount();
        for (int i = this.mCardCount - 1; i >= 0; --i) {
            View child = adapter.getView(i, null, (ViewGroup)this.mCardView);
            CardItem cardItem = new CardItem(child, 0.0f, i);
            this.mCardView.addCardView(cardItem);
            this.mZIndexTransformerCommon.transformAnimation(cardItem, this.mCurrentFraction, this.mCardWidth, this.mCardHeight, i, i);
            this.mTransformerCommon.transformAnimation(child, this.mCurrentFraction, this.mCardWidth, this.mCardHeight, i, i);
            this.mCards.addFirst(cardItem);
            child.setVisibility(4);
            this.showAnimAdd(child, i * this.mAnimAddRemoveDelay, i, i == this.mCardCount - 1);
        }
    }

    private void showAnimAdd(final View view, int delay, final int position, final boolean isLast) {
        if (this.mTransformerAnimAdd == null) {
            return;
        }
        final ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f}).setDuration((long)this.mAnimAddRemoveDuration);
        valueAnimator.setStartDelay((long)delay);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float fraction = ((Float)animation.getAnimatedValue()).floatValue();
                CardAnimationHelper.this.mTransformerAnimAdd.transformAnimation(view, fraction, CardAnimationHelper.this.mCardWidth, CardAnimationHelper.this.mCardHeight, position, position);
                if (CardAnimationHelper.this.mAnimAddRemoveInterpolator != null) {
                    CardAnimationHelper.this.mTransformerAnimAdd.transformInterpolatedAnimation(view, CardAnimationHelper.this.mAnimAddRemoveInterpolator.getInterpolation(fraction), CardAnimationHelper.this.mCardWidth, CardAnimationHelper.this.mCardHeight, position, position);
                }
            }
        });
        valueAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                view.setVisibility(0);
            }

            public void onAnimationEnd(Animator animation) {
                if (isLast) {
                    CardAnimationHelper.this.mIsAddRemoveAnim = false;
                    if (CardAnimationHelper.this.mTempAdapter != null) {
                        CardAnimationHelper.this.notifyDataSetChanged(CardAnimationHelper.this.mTempAdapter);
                    }
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        this.mCardView.post(new Runnable(){

            @Override
            public void run() {
                valueAnimator.start();
            }
        });
    }

    private void notifySetAdapter(BaseAdapter adapter) {
        int i;
        this.mCardCount = adapter.getCount();
        for (i = 0; i < this.mCardCount; ++i) {
            CardItem cardItem = this.mCards.get(i);
            View child = adapter.getView(cardItem.adapterIndex, cardItem.view, (ViewGroup)this.mCardView);
            if (child == cardItem.view) continue;
            if (cardItem.view != null) {
                this.mCardView.removeView(cardItem.view);
            }
            cardItem.view = child;
            this.mCardView.addCardView(cardItem, i);
            this.mZIndexTransformerCommon.transformAnimation(cardItem, this.mCurrentFraction, this.mCardWidth, this.mCardHeight, i, i);
            this.mTransformerCommon.transformAnimation(child, this.mCurrentFraction, this.mCardWidth, this.mCardHeight, i, i);
        }
        for (i = this.mCardCount - 1; i >= 0; --i) {
            this.mCards.get((int)i).view.bringToFront();
            this.mCardView.updateViewLayout(this.mCards.get((int)i).view, this.mCards.get((int)i).view.getLayoutParams());
        }
    }

    void notifyDataSetChanged(BaseAdapter adapter) {
        if (this.mIsAnim || this.mIsAddRemoveAnim) {
            this.mTempAdapter = adapter;
        } else {
            this.mTempAdapter = null;
            this.initAdapterView(adapter, false);
        }
    }

    void bringCardToFront(CardItem card) {
        if (this.mCards == null || this.mTransformerCommon == null || this.mTransformerToFront == null || this.mTransformerToBack == null) {
            return;
        }
        int position = this.mCards.indexOf(card);
        this.bringCardToFront(position);
    }

    void bringCardToFront(int position) {
        if (position >= 0 && position != this.mPositionToFront && !this.mIsAnim && !this.mIsAddRemoveAnim) {
            this.mPositionToFront = position;
            this.mPositionToBack = this.mAnimType == 1 ? this.mPositionToFront : this.mCardCount - 1;
            this.mCardToBack = this.mCards.getFirst();
            this.mCardToFront = this.mCards.get(this.mPositionToFront);
            if (this.mValueAnimator.isRunning()) {
                this.mValueAnimator.end();
            }
            this.mIsAnim = true;
            this.mValueAnimator.start();
        }
    }

    void setCardSize(int cardWidth, int cardHeight) {
        this.mCardWidth = cardWidth;
        this.mCardHeight = cardHeight;
    }

    void setTransformerToFront(AnimationTransformer toFrontTransformer) {
        if (this.mIsAnim || this.mIsAddRemoveAnim) {
            return;
        }
        this.mTransformerToFront = toFrontTransformer;
    }

    void setTransformerToBack(AnimationTransformer toBackTransformer) {
        if (this.mIsAnim || this.mIsAddRemoveAnim) {
            return;
        }
        this.mTransformerToBack = toBackTransformer;
    }

    void setCommonSwitchTransformer(AnimationTransformer commonTransformer) {
        if (this.mIsAnim || this.mIsAddRemoveAnim) {
            return;
        }
        this.mTransformerCommon = commonTransformer;
    }

    void setTransformerCommon(AnimationTransformer transformerCommon) {
        if (this.mIsAnim || this.mIsAddRemoveAnim) {
            return;
        }
        this.mTransformerCommon = transformerCommon;
    }

    void setZIndexTransformerToFront(ZIndexTransformer zIndexTransformerToFront) {
        if (this.mIsAnim || this.mIsAddRemoveAnim) {
            return;
        }
        this.mZIndexTransformerToFront = zIndexTransformerToFront;
    }

    void setZIndexTransformerToBack(ZIndexTransformer zIndexTransformerToBack) {
        if (this.mIsAnim || this.mIsAddRemoveAnim) {
            return;
        }
        this.mZIndexTransformerToBack = zIndexTransformerToBack;
    }

    void setZIndexTransformerCommon(ZIndexTransformer zIndexTransformerCommon) {
        if (this.mIsAnim || this.mIsAddRemoveAnim) {
            return;
        }
        this.mZIndexTransformerCommon = zIndexTransformerCommon;
    }

    void setAnimInterpolator(Interpolator animInterpolator) {
        if (this.mIsAnim || this.mIsAddRemoveAnim) {
            return;
        }
        this.mAnimInterpolator = animInterpolator;
    }

    void setAnimType(int animType) {
        if (this.mIsAnim || this.mIsAddRemoveAnim) {
            return;
        }
        this.mAnimType = animType;
    }

    void setTransformerAnimAdd(AnimationTransformer transformerAnimAdd) {
        if (this.mIsAnim || this.mIsAddRemoveAnim) {
            return;
        }
        this.mTransformerAnimAdd = transformerAnimAdd;
    }

    void setTransformerAnimRemove(AnimationTransformer transformerAnimRemove) {
        if (this.mIsAnim || this.mIsAddRemoveAnim) {
            return;
        }
        this.mTransformerAnimRemove = transformerAnimRemove;
    }

    void setAnimAddRemoveInterpolator(Interpolator animAddRemoveInterpolator) {
        if (this.mIsAnim || this.mIsAddRemoveAnim) {
            return;
        }
        this.mAnimAddRemoveInterpolator = animAddRemoveInterpolator;
    }

    void setAnimAddRemoveDelay(int animAddRemoveDelay) {
        if (this.mIsAnim || this.mIsAddRemoveAnim) {
            return;
        }
        this.mAnimAddRemoveDelay = animAddRemoveDelay;
    }

    void setAnimAddRemoveDuration(int animAddRemoveDuration) {
        if (this.mIsAnim || this.mIsAddRemoveAnim) {
            return;
        }
        this.mAnimAddRemoveDuration = animAddRemoveDuration;
    }

    boolean isAnimating() {
        return this.mIsAnim || this.mIsAddRemoveAnim;
    }

    void setCardAnimationListener(InfiniteCardView.CardAnimationListener cardAnimationListener) {
        this.mCardAnimationListener = cardAnimationListener;
    }
}

