/*
 * Decompiled with CFR 0.152.
 */
package com.bakerj.infinitecards;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.BaseAdapter;
import com.bakerj.infinitecards.AnimationTransformer;
import com.bakerj.infinitecards.CardAnimationHelper;
import com.bakerj.infinitecards.CardItem;
import com.bakerj.infinitecards.ZIndexTransformer;
import com.bakerj.infinitecards.lib.R;

public class InfiniteCardView
extends ViewGroup {
    public static final int ANIM_TYPE_FRONT = 0;
    public static final int ANIM_TYPE_SWITCH = 1;
    public static final int ANIM_TYPE_FRONT_TO_LAST = 2;
    private static final float CARD_SIZE_RATIO = 0.5f;
    private float mCardRatio = 0.5f;
    private CardAnimationHelper mAnimationHelper;
    private BaseAdapter mAdapter;
    private int mCardWidth;
    private int mCardHeight;

    public InfiniteCardView(@NonNull Context context) {
        this(context, null);
    }

    public InfiniteCardView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public InfiniteCardView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
        this.setClickable(true);
    }

    private void init(Context context, AttributeSet attrs) {
        int animType = 0;
        int animDuration = 1000;
        int animAddRemoveDuration = 500;
        int animAddRemoveDelay = 200;
        if (attrs != null) {
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.InfiniteCardView);
            animType = ta.getInt(R.styleable.InfiniteCardView_animType, 0);
            this.mCardRatio = ta.getFloat(R.styleable.InfiniteCardView_cardRatio, 0.5f);
            animDuration = ta.getInt(R.styleable.InfiniteCardView_animDuration, 1000);
            animAddRemoveDuration = ta.getInt(R.styleable.InfiniteCardView_animAddRemoveDuration, 500);
            animAddRemoveDelay = ta.getInt(R.styleable.InfiniteCardView_animAddRemoveDelay, 200);
            ta.recycle();
        }
        this.mAnimationHelper = new CardAnimationHelper(animType, animDuration, this);
        this.mAnimationHelper.setAnimAddRemoveDuration(animAddRemoveDuration);
        this.mAnimationHelper.setAnimAddRemoveDelay(animAddRemoveDelay);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int sizeWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int sizeHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        if (widthMode != 0x40000000 || heightMode != 0x40000000) {
            int childCount = this.getChildCount();
            int childWidth = 0;
            int childHeight = 0;
            for (int i = 0; i < childCount; ++i) {
                View childView = this.getChildAt(i);
                childWidth = Math.max(childView.getMeasuredWidth(), childWidth);
                childHeight = Math.max(childView.getMeasuredHeight(), childHeight);
            }
            this.setMeasuredDimension(widthMode == 0x40000000 ? sizeWidth : childWidth, heightMode == 0x40000000 ? sizeHeight : childHeight);
        } else {
            this.setMeasuredDimension(sizeWidth, sizeHeight);
        }
        if (this.mCardWidth == 0 || this.mCardHeight == 0) {
            this.setCardSize(true);
        }
    }

    private void setCardSize(boolean resetAdapter) {
        this.mCardWidth = this.getMeasuredWidth();
        this.mCardHeight = (int)((float)this.mCardWidth * this.mCardRatio);
        this.mAnimationHelper.setCardSize(this.mCardWidth, this.mCardHeight);
        this.mAnimationHelper.initAdapterView(this.mAdapter, resetAdapter);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int childCount = this.getChildCount();
        int width = this.getWidth();
        int height = this.getHeight();
        for (int i = 0; i < childCount; ++i) {
            View childView = this.getChildAt(i);
            int childWidth = childView.getMeasuredWidth();
            int childHeight = childView.getMeasuredHeight();
            int childLeft = (width - childWidth) / 2;
            int childTop = (height - childHeight) / 2;
            int childRight = childLeft + childWidth;
            int childBottom = childTop + childHeight;
            childView.layout(childLeft, childTop, childRight, childBottom);
        }
    }

    void addCardView(CardItem card) {
        this.addView(this.getCardView(card));
    }

    void addCardView(CardItem card, int position) {
        this.addView(this.getCardView(card), position);
    }

    private View getCardView(final CardItem card) {
        View view = card.view;
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(this.mCardWidth, this.mCardHeight);
        view.setLayoutParams(layoutParams);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                InfiniteCardView.this.bringCardToFront(card);
            }
        });
        return view;
    }

    private void bringCardToFront(CardItem card) {
        if (!this.isClickable()) {
            return;
        }
        this.mAnimationHelper.bringCardToFront(card);
    }

    public void bringCardToFront(int position) {
        this.mAnimationHelper.bringCardToFront(position);
    }

    public void setAdapter(BaseAdapter adapter) {
        this.mAdapter = adapter;
        this.mAdapter.registerDataSetObserver(new DataSetObserver(){

            public void onChanged() {
                InfiniteCardView.this.mAnimationHelper.notifyDataSetChanged(InfiniteCardView.this.mAdapter);
            }
        });
        this.mAnimationHelper.initAdapterView(adapter, true);
    }

    public void setTransformerToFront(AnimationTransformer toFrontTransformer) {
        this.mAnimationHelper.setTransformerToFront(toFrontTransformer);
    }

    public void setTransformerToBack(AnimationTransformer toBackTransformer) {
        this.mAnimationHelper.setTransformerToBack(toBackTransformer);
    }

    public void setCommonSwitchTransformer(AnimationTransformer commonTransformer) {
        this.mAnimationHelper.setCommonSwitchTransformer(commonTransformer);
    }

    public void setTransformerCommon(AnimationTransformer transformerCommon) {
        this.mAnimationHelper.setTransformerCommon(transformerCommon);
    }

    public void setZIndexTransformerToFront(ZIndexTransformer zIndexTransformerToFront) {
        this.mAnimationHelper.setZIndexTransformerToFront(zIndexTransformerToFront);
    }

    public void setZIndexTransformerToBack(ZIndexTransformer zIndexTransformerToBack) {
        this.mAnimationHelper.setZIndexTransformerToBack(zIndexTransformerToBack);
    }

    public void setZIndexTransformerCommon(ZIndexTransformer zIndexTransformerCommon) {
        this.mAnimationHelper.setZIndexTransformerCommon(zIndexTransformerCommon);
    }

    public void setAnimInterpolator(Interpolator animInterpolator) {
        this.mAnimationHelper.setAnimInterpolator(animInterpolator);
    }

    public void setAnimType(int animType) {
        this.mAnimationHelper.setAnimType(animType);
    }

    void setTransformerAnimAdd(AnimationTransformer transformerAnimAdd) {
        this.mAnimationHelper.setTransformerAnimAdd(transformerAnimAdd);
    }

    void setTransformerAnimRemove(AnimationTransformer transformerAnimRemove) {
        this.mAnimationHelper.setTransformerAnimRemove(transformerAnimRemove);
    }

    void setAnimAddRemoveInterpolator(Interpolator animAddRemoveInterpolator) {
        this.mAnimationHelper.setAnimAddRemoveInterpolator(animAddRemoveInterpolator);
    }

    public void setCardSizeRatio(float cardSizeRatio) {
        this.mCardRatio = cardSizeRatio;
        this.setCardSize(false);
    }

    public boolean isAnimating() {
        return this.mAnimationHelper.isAnimating();
    }

    public void setCardAnimationListener(CardAnimationListener cardAnimationListener) {
        this.mAnimationHelper.setCardAnimationListener(cardAnimationListener);
    }

    public static interface CardAnimationListener {
        public void onAnimationStart();

        public void onAnimationEnd();
    }
}

