/*
 * Decompiled with CFR 0.152.
 */
package com.bakdata.schemaregistrymock;

import com.bakdata.schemaregistrymock.AllSubjectsHandler;
import com.bakdata.schemaregistrymock.AutoRegistrationHandler;
import com.bakdata.schemaregistrymock.DeleteSubjectHandler;
import com.bakdata.schemaregistrymock.GetSubjectSchemaVersionHandler;
import com.bakdata.schemaregistrymock.GetVersionHandler;
import com.bakdata.schemaregistrymock.ListVersionsHandler;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.ResponseDefinitionTransformer;
import com.github.tomakehurst.wiremock.matching.UrlPathPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegistryMock {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchemaRegistryMock.class);
    private static final String ALL_SUBJECT_PATTERN = "/subjects";
    private static final String SCHEMA_PATH_PATTERN = "/subjects/[^/]+/versions";
    private static final String SCHEMA_BY_ID_PATTERN = "/schemas/ids/";
    private static final int IDENTITY_MAP_CAPACITY = 1000;
    private final List<SchemaProvider> schemaProviders;
    private final SchemaRegistryClient client;
    private final ListVersionsHandler listVersionsHandler;
    private final GetVersionHandler getVersionHandler;
    private final GetSubjectSchemaVersionHandler getSubjectSchemaVersionHandler;
    private final AutoRegistrationHandler autoRegistrationHandler;
    private final DeleteSubjectHandler deleteSubjectHandler;
    private final AllSubjectsHandler allSubjectsHandler;
    private final WireMockServer mockSchemaRegistry;

    public SchemaRegistryMock(List<SchemaProvider> schemaProviders) {
        this.schemaProviders = Optional.ofNullable(schemaProviders).orElseGet(() -> Collections.singletonList(new AvroSchemaProvider()));
        this.client = new MockSchemaRegistryClient(schemaProviders);
        this.listVersionsHandler = new ListVersionsHandler(this);
        this.getVersionHandler = new GetVersionHandler(this);
        this.getSubjectSchemaVersionHandler = new GetSubjectSchemaVersionHandler(this);
        this.autoRegistrationHandler = new AutoRegistrationHandler(this);
        this.deleteSubjectHandler = new DeleteSubjectHandler(this);
        this.allSubjectsHandler = new AllSubjectsHandler(this);
        this.mockSchemaRegistry = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().extensions((Extension[])this.extensions()));
    }

    public SchemaRegistryMock() {
        this(null);
    }

    private static UrlPattern getSchemaPattern(Integer id) {
        return WireMock.urlPathEqualTo((String)(SCHEMA_BY_ID_PATTERN + id));
    }

    private static UrlPattern getDeleteSubjectPattern(String subject) {
        return WireMock.urlEqualTo((String)("/subjects/" + subject + "?permanent=false"));
    }

    private static UrlPattern getSubjectSchemaVersionPattern(String subject) {
        return WireMock.urlPathMatching((String)("/subjects/" + subject + "(?:\\?(?:deleted|normalize)=(?:true|false)(?:&(?:deleted|normalize)=(?:true|false))*)?"));
    }

    private static UrlPattern getSubjectVersionsPattern(String subject) {
        return WireMock.urlEqualTo((String)("/subjects/" + subject + "/versions"));
    }

    private static UrlPathPattern getSubjectVersionPattern(String subject) {
        return WireMock.urlPathMatching((String)("/subjects/" + subject + "/versions/(?:latest|\\d+)"));
    }

    private static SchemaString parsedSchemaToSchemaString(ParsedSchema parsedSchema) {
        SchemaString schemaString = new SchemaString(parsedSchema.toString());
        schemaString.setSchemaType(parsedSchema.schemaType());
        schemaString.setReferences(parsedSchema.references());
        return schemaString;
    }

    public void start() {
        if (this.mockSchemaRegistry.isRunning()) {
            return;
        }
        this.mockSchemaRegistry.start();
        this.mockSchemaRegistry.stubFor(WireMock.get((UrlPattern)WireMock.urlPathMatching((String)SCHEMA_PATH_PATTERN)).willReturn(WireMock.aResponse().withStatus(404)));
        this.mockSchemaRegistry.stubFor(WireMock.post((UrlPattern)WireMock.urlPathMatching((String)SCHEMA_PATH_PATTERN)).willReturn(WireMock.aResponse().withTransformers(new String[]{this.autoRegistrationHandler.getName()})));
        this.mockSchemaRegistry.stubFor(WireMock.get((UrlPattern)WireMock.urlPathMatching((String)"/subjects/[^/]+/versions/(?:latest|\\d+)")).willReturn(WireMock.aResponse().withStatus(404)));
        this.mockSchemaRegistry.stubFor(WireMock.get((UrlPattern)WireMock.urlPathMatching((String)"/schemas/ids/\\d+")).willReturn(WireMock.aResponse().withStatus(404)));
        this.mockSchemaRegistry.stubFor(WireMock.delete((UrlPattern)WireMock.urlPathMatching((String)"/subjects/[^/]+")).willReturn(WireMock.aResponse().withStatus(404)));
        this.mockSchemaRegistry.stubFor(WireMock.get((UrlPattern)WireMock.urlPathMatching((String)ALL_SUBJECT_PATTERN)).willReturn(WireMock.aResponse().withTransformers(new String[]{this.allSubjectsHandler.getName()})));
        this.mockSchemaRegistry.stubFor(WireMock.post((UrlPattern)SchemaRegistryMock.getSubjectSchemaVersionPattern("[^/]+")).willReturn(WireMock.aResponse().withStatus(404)));
    }

    public void stop() {
        this.mockSchemaRegistry.stop();
    }

    public int registerKeySchema(String topic, Schema schema) {
        return this.register(topic + "-key", (ParsedSchema)new AvroSchema(schema));
    }

    public int registerValueSchema(String topic, Schema schema) {
        return this.register(topic + "-value", (ParsedSchema)new AvroSchema(schema));
    }

    public int registerKeySchema(String topic, ParsedSchema schema) {
        return this.register(topic + "-key", schema);
    }

    public int registerValueSchema(String topic, ParsedSchema schema) {
        return this.register(topic + "-value", schema);
    }

    public List<Integer> deleteKeySchema(String subject) {
        return this.delete(subject + "-key");
    }

    public List<Integer> deleteValueSchema(String subject) {
        return this.delete(subject + "-value");
    }

    public SchemaRegistryClient getSchemaRegistryClient() {
        return this.getSchemaRegistryClient(Collections.emptyMap());
    }

    public SchemaRegistryClient getSchemaRegistryClient(Map<String, ?> config) {
        return new CachedSchemaRegistryClient(Collections.singletonList(this.getUrl()), 1000, this.schemaProviders, config);
    }

    public String getUrl() {
        return "http://localhost:" + this.mockSchemaRegistry.port();
    }

    int register(String subject, ParsedSchema schema) {
        try {
            int id = this.client.register(subject, schema);
            log.debug("Registered schema {}", (Object)id);
            this.mockSchemaRegistry.stubFor(WireMock.get((UrlPattern)SchemaRegistryMock.getSchemaPattern(id)).withQueryParam("fetchMaxId", WireMock.matching((String)"false|true")).willReturn(ResponseDefinitionBuilder.okForJson((Object)SchemaRegistryMock.parsedSchemaToSchemaString(schema))));
            this.mockSchemaRegistry.stubFor(WireMock.delete((UrlPattern)SchemaRegistryMock.getDeleteSubjectPattern(subject)).willReturn(WireMock.aResponse().withTransformers(new String[]{this.deleteSubjectHandler.getName()})));
            this.mockSchemaRegistry.stubFor(WireMock.get((UrlPattern)SchemaRegistryMock.getSubjectVersionsPattern(subject)).willReturn(WireMock.aResponse().withTransformers(new String[]{this.listVersionsHandler.getName()})));
            this.mockSchemaRegistry.stubFor(WireMock.get((UrlPattern)SchemaRegistryMock.getSubjectVersionPattern(subject)).willReturn(WireMock.aResponse().withTransformers(new String[]{this.getVersionHandler.getName()})));
            this.mockSchemaRegistry.stubFor(WireMock.post((UrlPattern)SchemaRegistryMock.getSubjectSchemaVersionPattern(subject)).willReturn(WireMock.aResponse().withTransformers(new String[]{this.getSubjectSchemaVersionHandler.getName()})));
            return id;
        }
        catch (RestClientException | IOException e) {
            throw new IllegalStateException("Internal error in mock schema registry client", e);
        }
    }

    List<Integer> delete(String subject) {
        try {
            List ids = this.client.deleteSubject(subject);
            ids.forEach(id -> this.mockSchemaRegistry.removeStub(WireMock.get((UrlPattern)SchemaRegistryMock.getSchemaPattern(id))));
            this.mockSchemaRegistry.removeStub(WireMock.delete((UrlPattern)SchemaRegistryMock.getDeleteSubjectPattern(subject)));
            this.mockSchemaRegistry.removeStub(WireMock.get((UrlPattern)SchemaRegistryMock.getSubjectVersionsPattern(subject)));
            this.mockSchemaRegistry.removeStub(WireMock.get((UrlPattern)SchemaRegistryMock.getSubjectVersionPattern(subject)));
            this.mockSchemaRegistry.removeStub(WireMock.post((UrlPattern)SchemaRegistryMock.getSubjectSchemaVersionPattern(subject)));
            return ids;
        }
        catch (RestClientException | IOException e) {
            throw new IllegalStateException("Internal error in mock schema registry client", e);
        }
    }

    List<Integer> listVersions(String subject) {
        log.debug("Listing all versions for subject {}", (Object)subject);
        try {
            return this.client.getAllVersions(subject);
        }
        catch (RestClientException | IOException e) {
            throw new IllegalStateException("Internal error in mock schema registry client", e);
        }
    }

    io.confluent.kafka.schemaregistry.client.rest.entities.Schema getSchema(String subject, ParsedSchema parsedSchema) {
        log.debug("Getting schema version for subject {}", (Object)subject);
        try {
            int version = this.client.getVersion(subject, parsedSchema);
            int id = this.client.getId(subject, parsedSchema);
            return new io.confluent.kafka.schemaregistry.client.rest.entities.Schema(subject, Integer.valueOf(version), Integer.valueOf(id), parsedSchema.schemaType(), parsedSchema.references(), parsedSchema.canonicalString());
        }
        catch (RestClientException | IOException e) {
            throw new IllegalStateException("Internal error in mock schema registry client", e);
        }
    }

    SchemaMetadata getSubjectVersion(String subject, Object version) {
        log.debug("Requesting version {} for subject {}", version, (Object)subject);
        try {
            if (version instanceof String && version.equals("latest")) {
                return this.client.getLatestSchemaMetadata(subject);
            }
            if (version instanceof Number) {
                return this.client.getSchemaMetadata(subject, ((Number)version).intValue());
            }
            throw new IllegalArgumentException("Only 'latest' or integer versions are allowed");
        }
        catch (RestClientException | IOException e) {
            throw new IllegalStateException("Internal error in mock schema registry client", e);
        }
    }

    Collection<String> listAllSubjects() {
        try {
            return this.client.getAllSubjects();
        }
        catch (RestClientException | IOException e) {
            throw new IllegalStateException("Internal error in mock schema registry client", e);
        }
    }

    ParsedSchema parseSchema(RegisterSchemaRequest registerSchemaRequest) {
        String schemaType = registerSchemaRequest.getSchemaType();
        String schema = registerSchemaRequest.getSchema();
        List references = Optional.ofNullable(registerSchemaRequest.getReferences()).orElse(Collections.emptyList());
        Optional schemaOptional = this.client.parseSchema(schemaType, schema, references);
        return (ParsedSchema)schemaOptional.orElseThrow(() -> new RuntimeException("Could not parse schema"));
    }

    private ResponseDefinitionTransformer[] extensions() {
        return new ResponseDefinitionTransformer[]{this.autoRegistrationHandler, this.listVersionsHandler, this.getVersionHandler, this.getSubjectSchemaVersionHandler, this.deleteSubjectHandler, this.allSubjectsHandler};
    }
}

