/*
 * Decompiled with CFR 0.152.
 */
package com.bakdata.schemaregistrymock;

import com.bakdata.schemaregistrymock.SchemaRegistryMock;
import com.bakdata.schemaregistrymock.SubjectsHandler;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.google.common.collect.Iterables;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;

class GetVersionHandler
extends SubjectsHandler {
    private final SchemaRegistryMock schemaRegistryMock;

    GetVersionHandler(SchemaRegistryMock schemaRegistryMock) {
        this.schemaRegistryMock = schemaRegistryMock;
    }

    public ResponseDefinition transform(Request request, ResponseDefinition responseDefinition, FileSource files, Parameters parameters) {
        SchemaMetadata metadata;
        String versionStr = (String)Iterables.get((Iterable)this.urlSplitter.split((CharSequence)GetVersionHandler.removeQueryParameters(request.getUrl())), (int)3);
        if ("latest".equals(versionStr)) {
            metadata = this.schemaRegistryMock.getSubjectVersion(this.getSubject(request), versionStr);
        } else {
            int version = Integer.parseInt(versionStr);
            metadata = this.schemaRegistryMock.getSubjectVersion(this.getSubject(request), version);
        }
        return ResponseDefinitionBuilder.jsonResponse((Object)metadata);
    }

    public String getName() {
        return GetVersionHandler.class.getSimpleName();
    }
}

