/*
 * Decompiled with CFR 0.152.
 */
package com.bajicdusko.fragmentmanager;

import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import com.bajicdusko.fragmentmanager.FragmentTagStack;
import com.bajicdusko.fragmentmanager.IFragment;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\r\u0010\u000f\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u0004\u0018\u00010\u000eJ\u0006\u0010\u0015\u001a\u00020\u0013J\u0010\u0010\u0016\u001a\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0010\u0010\u0019\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0018J\u0006\u0010\u001b\u001a\u00020\fJ\u0006\u0010\u001c\u001a\u00020\fJ\u000e\u0010\u001d\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/bajicdusko/fragmentmanager/SimpleFragmentManager;", "", "fragmentManager", "Landroid/support/v4/app/FragmentManager;", "fragmentContainerId", "", "(Landroid/support/v4/app/FragmentManager;I)V", "KEY_TAGS", "", "fragmentTagStack", "Lcom/bajicdusko/fragmentmanager/FragmentTagStack;", "addFragment", "", "fragment", "Lcom/bajicdusko/fragmentmanager/IFragment;", "dispose", "()Lkotlin/Unit;", "enableLogs", "logsEnabled", "", "getCurrentFragment", "onBackPressed", "onRestoreInstanceState", "savedInstanceState", "Landroid/os/Bundle;", "onSaveInstanceState", "state", "popUp", "popUpAll", "replaceFragment", "fragment-manager_release"})
public final class SimpleFragmentManager {
    private final String KEY_TAGS = "key_tags";
    private FragmentTagStack fragmentTagStack;
    private final FragmentManager fragmentManager;
    private final int fragmentContainerId;

    public final void addFragment(@NotNull IFragment fragment) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        this.fragmentTagStack.push(fragment.getFragmentName());
        this.fragmentManager.beginTransaction().add(this.fragmentContainerId, (Fragment)fragment, fragment.getFragmentName()).addToBackStack(fragment.getFragmentName()).commit();
    }

    public final void replaceFragment(@NotNull IFragment fragment) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        this.fragmentTagStack.push(fragment.getFragmentName());
        this.fragmentManager.beginTransaction().replace(this.fragmentContainerId, (Fragment)fragment, fragment.getFragmentName()).addToBackStack(fragment.getFragmentName()).commit();
    }

    public final boolean onBackPressed() {
        if (this.fragmentManager.getBackStackEntryCount() > 1) {
            IFragment currentFragment;
            this.popUp();
            IFragment iFragment = currentFragment = this.getCurrentFragment();
            if (iFragment != null) {
                iFragment.setTitle();
            }
            return true;
        }
        return false;
    }

    public final void popUp() {
        this.fragmentManager.popBackStackImmediate();
        this.fragmentTagStack.pop();
    }

    public final void popUpAll() {
        this.fragmentManager.popBackStack(null, 1);
        this.fragmentTagStack.popUpAll();
    }

    @Nullable
    public final IFragment getCurrentFragment() {
        return (IFragment)this.fragmentManager.findFragmentByTag(this.fragmentTagStack.getActiveTag());
    }

    @Nullable
    public final Unit dispose() {
        Unit unit;
        IFragment iFragment = this.getCurrentFragment();
        if (iFragment != null) {
            iFragment.dispose();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public final void onSaveInstanceState(@Nullable Bundle state) {
        block0: {
            Bundle bundle = state;
            if (bundle == null) break block0;
            bundle.putParcelable(this.KEY_TAGS, (Parcelable)this.fragmentTagStack);
        }
    }

    public final void onRestoreInstanceState(@Nullable Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            Parcelable parcelable = savedInstanceState.getParcelable(this.KEY_TAGS);
            Intrinsics.checkExpressionValueIsNotNull((Object)parcelable, (String)"savedInstanceState.getParcelable(KEY_TAGS)");
            this.fragmentTagStack = (FragmentTagStack)parcelable;
        } else {
            this.fragmentTagStack = new FragmentTagStack();
        }
    }

    public final void enableLogs(boolean logsEnabled) {
        this.fragmentTagStack.setShowLogs(logsEnabled);
    }

    public SimpleFragmentManager(@NotNull FragmentManager fragmentManager, int fragmentContainerId) {
        Intrinsics.checkParameterIsNotNull((Object)fragmentManager, (String)"fragmentManager");
        this.fragmentManager = fragmentManager;
        this.fragmentContainerId = fragmentContainerId;
        this.KEY_TAGS = "key_tags";
        this.fragmentTagStack = new FragmentTagStack();
    }
}

