/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashUtils {
    public static byte[] computeMd5Hash(InputStream is) throws NoSuchAlgorithmException, IOException {
        return HashUtils.computeHash(is, MessageDigest.getInstance("MD5"));
    }

    public static byte[] computeSha256Hash(InputStream is) throws NoSuchAlgorithmException, IOException {
        return HashUtils.computeHash(is, MessageDigest.getInstance("SHA-256"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] computeHash(InputStream is, MessageDigest messageDigest) throws IOException {
        try {
            byte[] buffer = new byte[16384];
            int bytesRead = -1;
            while ((bytesRead = is.read(buffer, 0, buffer.length)) != -1) {
                messageDigest.update(buffer, 0, bytesRead);
            }
            byte[] byArray = messageDigest.digest();
            return byArray;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }
}

