/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bos.model;

import com.baidubce.model.User;
import com.baidubce.services.bos.model.BosObjectSummary;
import com.baidubce.services.bos.model.BosPrefixInfo;
import com.baidubce.services.bos.model.ListObjectsResponse;
import com.baidubce.util.DateUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ListObjectsResponseDeserializer
extends BeanDeserializer {
    public ListObjectsResponseDeserializer() {
        super((BeanDeserializerBase)ListObjectsResponseDeserializer.createBeanDeserializer(ListObjectsResponse.class), true);
    }

    public ListObjectsResponseDeserializer(Class<? extends ListObjectsResponse> beanClass) {
        super((BeanDeserializerBase)ListObjectsResponseDeserializer.createBeanDeserializer(beanClass), true);
    }

    public ListObjectsResponse deserialize(JsonParser parser, DeserializationContext ctx, Object bean) throws IOException, JsonProcessingException {
        String userMetaKey;
        String name;
        Iterator userMetaIterator;
        HashMap<String, String> userMeta;
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        ListObjectsResponse listObjectsResponse = (ListObjectsResponse)bean;
        if (node.has("name")) {
            listObjectsResponse.setBucketName(node.get("name").asText());
        }
        if (node.has("prefix")) {
            listObjectsResponse.setPrefix(node.get("prefix").asText());
        }
        if (node.has("delimiter")) {
            listObjectsResponse.setDelimiter(node.get("delimiter").asText());
        }
        if (node.has("marker")) {
            listObjectsResponse.setMarker(node.get("marker").asText());
        }
        if (node.has("nextMarker")) {
            listObjectsResponse.setNextMarker(node.get("nextMarker").asText());
        }
        if (node.has("maxKeys")) {
            listObjectsResponse.setMaxKeys(node.get("maxKeys").asInt());
        }
        if (node.has("isTruncated")) {
            listObjectsResponse.setTruncated(node.get("isTruncated").asBoolean());
        }
        if (node.has("contents")) {
            JsonNode contentsNode = node.get("contents");
            ArrayList<BosObjectSummary> contents = new ArrayList<BosObjectSummary>();
            Iterator it = contentsNode.elements();
            while (it.hasNext()) {
                JsonNode content = (JsonNode)it.next();
                BosObjectSummary bosObjectSummary = new BosObjectSummary();
                bosObjectSummary.setBucketName(listObjectsResponse.getBucketName());
                if (content.has("key")) {
                    bosObjectSummary.setKey(content.get("key").asText());
                }
                if (content.has("lastModified") && !content.get("lastModified").asText().isEmpty()) {
                    bosObjectSummary.setLastModified(DateUtils.parseAlternateIso8601Date(content.get("lastModified").asText()));
                }
                if (content.has("eTag")) {
                    bosObjectSummary.setETag(content.get("eTag").asText());
                }
                if (content.has("size")) {
                    bosObjectSummary.setSize(content.get("size").asLong());
                }
                User owner = new User();
                if (content.has("owner")) {
                    if (content.get("owner").has("id")) {
                        owner.setId(content.get("owner").get("id").asText());
                    }
                    if (content.get("owner").has("displayName")) {
                        owner.setDisplayName(content.get("owner").get("displayName").asText());
                    }
                }
                bosObjectSummary.setOwner(owner);
                if (content.has("storageClass")) {
                    bosObjectSummary.setStorageClass(content.get("storageClass").asText());
                }
                if (content.has("userMeta")) {
                    userMeta = new HashMap();
                    userMetaIterator = content.get("userMeta").fieldNames();
                    while (userMetaIterator.hasNext()) {
                        userMetaKey = name = (String)userMetaIterator.next();
                        if (name.startsWith("x-bce-meta-")) {
                            userMetaKey = name.substring("x-bce-meta-".length());
                        }
                        userMeta.put(userMetaKey, content.get("userMeta").get(name).asText());
                    }
                    bosObjectSummary.setUserMeta(userMeta);
                }
                contents.add(bosObjectSummary);
            }
            listObjectsResponse.setContents(contents);
        }
        if (node.has("commonPrefixes")) {
            JsonNode commonPrefixesNode = node.get("commonPrefixes");
            ArrayList<String> commonPrefixes = new ArrayList<String>();
            ArrayList<BosPrefixInfo> commonPrefixesWithExtMeta = new ArrayList<BosPrefixInfo>();
            Iterator it = commonPrefixesNode.elements();
            while (it.hasNext()) {
                JsonNode commonPrefix = (JsonNode)it.next();
                if (commonPrefix.has("prefix")) {
                    commonPrefixes.add(commonPrefix.get("prefix").asText());
                }
                BosPrefixInfo bosPrefixInfo = new BosPrefixInfo();
                if (commonPrefix.has("prefix")) {
                    bosPrefixInfo.setPrefix(commonPrefix.get("prefix").asText());
                }
                if (commonPrefix.has("lastModified") && !commonPrefix.get("lastModified").asText().isEmpty()) {
                    bosPrefixInfo.setLastModified(DateUtils.parseAlternateIso8601Date(commonPrefix.get("lastModified").asText()));
                }
                if (commonPrefix.has("userMeta")) {
                    userMeta = new HashMap<String, String>();
                    userMetaIterator = commonPrefix.get("userMeta").fieldNames();
                    while (userMetaIterator.hasNext()) {
                        userMetaKey = name = (String)userMetaIterator.next();
                        if (name.startsWith("x-bce-meta-")) {
                            userMetaKey = name.substring("x-bce-meta-".length());
                        }
                        userMeta.put(userMetaKey, commonPrefix.get("userMeta").get(name).asText());
                    }
                    bosPrefixInfo.setUserMeta(userMeta);
                }
                commonPrefixesWithExtMeta.add(bosPrefixInfo);
            }
            listObjectsResponse.setCommonPrefixes(commonPrefixes);
            listObjectsResponse.setCommonPrefixesWithExtMeta(commonPrefixesWithExtMeta);
        }
        return listObjectsResponse;
    }

    private static BeanDeserializer createBeanDeserializer(Class<?> listObjectsResponse) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            DefaultDeserializationContext defctx = (DefaultDeserializationContext)mapper.getDeserializationContext();
            DefaultDeserializationContext ctxt = defctx.createInstance(mapper.getDeserializationConfig(), null, null);
            JavaType type = ctxt.constructType(listObjectsResponse);
            BasicBeanDescription beanDesc = (BasicBeanDescription)ctxt.getConfig().introspect(type);
            BeanDeserializerFactory factory = (BeanDeserializerFactory)ctxt.getFactory();
            BeanDeserializer beanDeserializer = (BeanDeserializer)factory.buildBeanDeserializer((DeserializationContext)ctxt, type, (BeanDescription)beanDesc);
            beanDeserializer.resolve((DeserializationContext)ctxt);
            return beanDeserializer;
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

