/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.moladb.model.transform;

import com.baidubce.BceClientException;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.moladb.model.GetInstanceResponse;
import com.baidubce.services.moladb.model.transform.Unmarshaller;
import com.baidubce.services.moladb.model.transform.Unmarshallers;
import com.baidubce.util.JsonUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class GetInstanceResponseUnmarshaller
implements Unmarshaller<GetInstanceResponse, InputStream> {
    private GetInstanceResponse result;

    public GetInstanceResponseUnmarshaller(AbstractBceResponse response) {
        this.result = (GetInstanceResponse)response;
    }

    @Override
    public GetInstanceResponse unmarshall(InputStream inputStream) throws Exception {
        String streamContents = Unmarshallers.readStreamContents(inputStream);
        JsonNode root = JsonUtils.jsonNodeOf(streamContents);
        if (!root.isObject()) {
            throw new BceClientException("input json object:" + root.toString() + " is not an object");
        }
        JsonNode tableObj = root.get("tableNames");
        String desc = root.get("desc").asText();
        String name = root.get("name").asText();
        this.result.setDescription(desc);
        this.result.setInstanceName(name);
        ArrayList<String> tableNames = new ArrayList<String>();
        Iterator tableList = tableObj.elements();
        while (tableList.hasNext()) {
            JsonNode table = (JsonNode)tableList.next();
            tableNames.add(table.asText());
        }
        this.result.setTableNames(tableNames);
        return this.result;
    }
}

