/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.lbsapi.panoramaview;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.baidu.lbsapi.panoramaview.PanoramaRequest;
import com.baidu.lbsapi.panoramaview.PanoramaViewListener;
import com.baidu.lbsapi.tools.CoordinateConverter;
import com.baidu.lbsapi.tools.Point;
import com.baidu.pano.platform.b.a;
import com.baidu.pano.platform.c.e;
import com.baidu.pano.platform.comapi.a.b;
import com.baidu.pano.platform.comapi.map.InnerPanoramaView;
import com.baidu.pano.platform.plugin.indooralbum.IndoorAlbumPlugin;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PanoramaView
extends FrameLayout {
    public static final int PANOTYPE_INTERIOR = 65537;
    public static final int PANOTYPE_STREET = 65538;
    public static final int COORDTYPE_WGS84 = 0;
    public static final int COORDTYPE_GCJ02 = 1;
    public static final int COORDTYPE_BD09LL = 2;
    public static final int COORDTYPE_BD09MC = 3;
    private InnerPanoramaView a;
    private PanoramaViewListener b;

    public PanoramaView(Context context) {
        super(context, null);
        this.a(context);
    }

    public PanoramaView(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
        this.a(context);
    }

    public PanoramaView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    private void a(Context context) {
        FrameLayout.LayoutParams lparam = new FrameLayout.LayoutParams(-1, -1);
        this.setLayoutParams((ViewGroup.LayoutParams)lparam);
        this.a = new InnerPanoramaView(context);
        this.a.a("", this);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
        this.addView((View)this.a, (ViewGroup.LayoutParams)lp);
        com.baidu.pano.platform.b.a.a(this.getContext());
    }

    public void setPoiEntranceBitMap(Bitmap bitmap) {
        com.baidu.pano.platform.b.a.a = bitmap;
    }

    public void setPanorama(String pid) {
        this.a.a(pid);
    }

    public void setPanorama(int x2, int y2) {
        this.a.a(x2, y2);
    }

    public void setPanorama(double longitude, double latitude) {
        this.a.a(longitude, latitude);
    }

    public void setPanorama(double longitude, double latitude, int coordType) {
        switch (coordType) {
            case 0: {
                Point wgsPoint = new Point(longitude, latitude);
                Point bdPointLL = CoordinateConverter.converter(CoordinateConverter.COOR_TYPE.COOR_TYPE_WGS84, wgsPoint);
                this.a.a(bdPointLL.x, bdPointLL.y);
                break;
            }
            case 1: {
                Point gcjPoint = new Point(longitude, latitude);
                Point pointLL = CoordinateConverter.converter(CoordinateConverter.COOR_TYPE.COOR_TYPE_GCJ02, gcjPoint);
                this.a.a(pointLL.x, pointLL.y);
                break;
            }
            case 2: {
                this.a.a(longitude, latitude);
                break;
            }
            case 3: {
                this.a.a((int)longitude, (int)latitude);
                break;
            }
        }
    }

    public void setPanoramaByUid(String uid, int panoType) {
        this.a.a(uid, this);
        final String mUid = uid;
        final int mPanoType = panoType;
        final Context context = this.getContext();
        if (e.c(context)) {
            new AsyncTask<String, Integer, String>(){

                protected void onPreExecute() {
                }

                protected String doInBackground(String ... params) {
                    return PanoramaRequest.getInstance(context).getPoiInfoByUidWithJson(params[0]);
                }

                protected void onPostExecute(String result) {
                    block15: {
                        if (!TextUtils.isEmpty((CharSequence)result)) {
                            try {
                                JSONObject jsonAll = new JSONObject(result);
                                JSONObject resultjson = jsonAll.getJSONObject("result");
                                int resultCode = resultjson.optInt("error");
                                if (resultCode == 0) {
                                    if (null != jsonAll.optString("content") && !"".equals(jsonAll.optString("content"))) {
                                        JSONArray contentArray = jsonAll.getJSONArray("content");
                                        JSONObject poiInfo = contentArray.getJSONObject(0).getJSONObject("poiinfo");
                                        boolean hasInterior = poiInfo.optInt("hasinter") == 1;
                                        boolean hasStreet = poiInfo.optInt("hasstreet") == 1;
                                        String iid = poiInfo.optString("IID");
                                        String pid = poiInfo.optString("PID");
                                        String poiName = poiInfo.optString("name");
                                        double poiX = poiInfo.optDouble("X");
                                        double poiY = poiInfo.optDouble("Y");
                                        if (poiInfo.has("interstartpid")) {
                                            String interStartPid = poiInfo.optString("interstartpid");
                                            switch (mPanoType) {
                                                case 65537: {
                                                    if (hasInterior && !TextUtils.isEmpty((CharSequence)iid)) {
                                                        if (IndoorAlbumPlugin.getInstance().hasPlugin()) {
                                                            PanoramaView.this.setPanorama(interStartPid);
                                                            break;
                                                        }
                                                        PanoramaView.this.b.onLoadPanoramaError(PanoramaView.this.a.a(202));
                                                        break;
                                                    }
                                                    PanoramaView.this.b.onLoadPanoramaError(PanoramaView.this.a.a(201));
                                                    break;
                                                }
                                                case 65538: {
                                                    IndoorAlbumPlugin.getInstance().onDestroyView();
                                                    if (hasStreet && !TextUtils.isEmpty((CharSequence)pid)) {
                                                        b poiMarker = new b(PanoramaView.this.getContext(), hasInterior, poiName);
                                                        poiMarker.setMarkerPosition(new Point(poiX, poiY));
                                                        poiMarker.setMarkerHeight(2.0f);
                                                        PanoramaView.this.a.a(mUid, pid, PanoramaView.this, poiMarker);
                                                        PanoramaView.this.a.b(mUid);
                                                        break;
                                                    }
                                                    PanoramaView.this.b.onLoadPanoramaError(PanoramaView.this.a.a(201));
                                                }
                                            }
                                        } else {
                                            PanoramaView.this.b.onLoadPanoramaError(PanoramaView.this.a.a(201));
                                        }
                                    }
                                    break block15;
                                }
                                PanoramaView.this.b.onLoadPanoramaError(PanoramaView.this.a.a(201));
                            }
                            catch (JSONException e2) {
                                e2.printStackTrace();
                            }
                        } else {
                            PanoramaView.this.b.onLoadPanoramaError(PanoramaView.this.a.a(201));
                        }
                    }
                }
            }.execute((Object[])new String[]{uid, panoType + ""});
        } else {
            this.b.onLoadPanoramaError(this.a.a(201));
        }
    }

    public void reloadPoiMarker(final String uid, final String lastPid) {
        final Context context = this.getContext();
        if (e.c(context)) {
            new AsyncTask<String, Integer, String>(){

                protected void onPreExecute() {
                }

                protected String doInBackground(String ... params) {
                    return PanoramaRequest.getInstance(context).getPoiInfoByUidWithJson(params[0]);
                }

                protected void onPostExecute(String result) {
                    if (!TextUtils.isEmpty((CharSequence)result)) {
                        try {
                            JSONObject jsonAll = new JSONObject(result);
                            JSONObject resultjson = jsonAll.getJSONObject("result");
                            int resultCode = resultjson.optInt("error");
                            if (resultCode == 0 && null != jsonAll.optString("content") && !"".equals(jsonAll.optString("content"))) {
                                JSONArray contentArray = jsonAll.getJSONArray("content");
                                JSONObject poiInfo = contentArray.getJSONObject(0).getJSONObject("poiinfo");
                                boolean hasInterior = poiInfo.optInt("hasinter") == 1;
                                String pid = poiInfo.optString("PID");
                                String poiName = poiInfo.optString("name");
                                double poiX = poiInfo.optDouble("X");
                                double poiY = poiInfo.optDouble("Y");
                                if (poiInfo.has("interstartpid")) {
                                    b poiMarker = new b(PanoramaView.this.getContext(), hasInterior, poiName);
                                    poiMarker.setMarkerPosition(new Point(poiX, poiY));
                                    poiMarker.setMarkerHeight(2.0f);
                                    PanoramaView.this.a.a(uid, pid, PanoramaView.this, poiMarker);
                                    PanoramaView.this.setPanorama(lastPid);
                                }
                            }
                        }
                        catch (JSONException e2) {
                            e2.printStackTrace();
                        }
                    }
                }
            }.execute((Object[])new String[]{uid});
        }
    }

    public void setIndoorAlbumGone() {
        IndoorAlbumPlugin.getInstance().setAlbumViewShow(false);
    }

    public void setIndoorAlbumVisible() {
        IndoorAlbumPlugin.getInstance().setAlbumViewShow(true);
    }

    public void setPanoramaPitch(float pitch) {
        this.a.a(pitch);
    }

    public float getPanoramaPitch() {
        return this.a.a();
    }

    public void setPanoramaHeading(float heading) {
        this.a.b(heading);
    }

    public float getPanoramaHeading() {
        return this.a.b();
    }

    @Deprecated
    public void setPanoramaLevel(int level) {
        this.a.b(level);
    }

    public void setPanoramaZoomLevel(int level) {
        this.a.b(level);
    }

    @Deprecated
    public float getPanoramaLevel() {
        return this.a.c();
    }

    public float getPanoramaZoomLevel() {
        return this.a.c();
    }

    public void setPanoramaImageLevel(ImageDefinition imageDefinition) {
        this.a.a(imageDefinition);
    }

    public boolean setArrowTextureByBitmap(Bitmap bitmap) {
        return this.a.a(bitmap);
    }

    public boolean setArrowTextureByUrl(String url) {
        return this.a.c(url);
    }

    public void setShowTopoLink(boolean isShow) {
        this.a.a(isShow);
    }

    public void setArrowTexture(Bitmap bitmap) {
        this.a.b(bitmap);
    }

    public void destroy() {
        this.a.d();
    }

    public void setCustomMarkerShow(boolean isShow) {
        this.a.b(isShow);
    }

    public boolean addMarker(com.baidu.pano.platform.comapi.a.a marker) {
        return this.a.a(marker);
    }

    public boolean addMarker(String key, double x2, double y2, double z2, Bitmap bitmap) {
        return this.a.a(key, x2, y2, z2, bitmap);
    }

    public void setCustomMarkerAnchor(String key, float x2, float y2) {
        if (this.a != null) {
            this.a.a(key, x2, y2);
        }
    }

    public boolean removeMarker(com.baidu.pano.platform.comapi.a.a marker) {
        return this.a.b(marker);
    }

    public boolean removeAllMarker() {
        return this.a.e();
    }

    public void setPoiMarkerVisibility(boolean isShow) {
        this.a.c(isShow);
    }

    public void removePOIMarker() {
        this.a.f();
    }

    public void enableFastMove(boolean enable) {
        this.a.d(enable);
    }

    public double[] screenPt2Mercator(float screenX, float screenY) {
        return this.a.a(screenX, screenY);
    }

    public void setPanoramaViewListener(PanoramaViewListener listener) {
        this.b = listener;
        this.a.a(this.b);
    }

    public void setZOrderMediaOverlay(boolean isMediaOverlay) {
        this.a.setZOrderMediaOverlay(isMediaOverlay);
    }

    public void setZOrderOnTop(boolean onTop) {
        this.a.setZOrderOnTop(onTop);
    }

    public void onResume() {
        this.a.onResume();
    }

    public void onPause() {
        this.a.onPause();
    }

    public static enum ImageDefinition {
        ImageDefinitionLow(3),
        ImageDefinitionMiddle(4),
        ImageDefinitionHigh(5);

        private int mValue;

        private ImageDefinition(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }
    }
}

