/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.platform.comapi.radar;

import com.baidu.mapapi.CoordType;
import com.baidu.mapapi.SDKInitializer;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapapi.radar.RadarNearbyInfo;
import com.baidu.mapapi.radar.RadarNearbyResult;
import com.baidu.mapapi.radar.RadarSearchError;
import com.baidu.platform.comapi.util.CoordTrans;
import java.util.ArrayList;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class d {
    public static RadarSearchError a(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        JSONObject jSONObject = null;
        try {
            jSONObject = new JSONObject(string);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return null;
        }
        if (jSONObject == null) {
            return null;
        }
        int n2 = jSONObject.optInt("status");
        RadarSearchError radarSearchError = RadarSearchError.RADAR_NO_ERROR;
        switch (n2) {
            case 0: {
                radarSearchError = RadarSearchError.RADAR_NO_ERROR;
                break;
            }
            case 500: 
            case 504: {
                radarSearchError = RadarSearchError.RADAR_AK_ERROR;
                break;
            }
            case 507: {
                radarSearchError = RadarSearchError.RADAR_USERID_NOT_EXIST;
                break;
            }
            case 503: {
                radarSearchError = RadarSearchError.RADAR_FORBID_BY_ADMIN;
                break;
            }
            case 502: {
                radarSearchError = RadarSearchError.RADAR_FORBID_BY_USER;
                break;
            }
            case 506: {
                radarSearchError = RadarSearchError.RADAR_AK_NOT_BIND;
                break;
            }
            case 2: 
            case 404: {
                radarSearchError = RadarSearchError.RADAR_NETWORK_ERROR;
                break;
            }
            case 8: {
                radarSearchError = RadarSearchError.RADAR_NETWORK_TIMEOUT;
                break;
            }
            case 508: {
                radarSearchError = RadarSearchError.RADAR_PERMISSION_UNFINISHED;
                break;
            }
            default: {
                radarSearchError = RadarSearchError.RADAR_NO_RESULT;
            }
        }
        return radarSearchError;
    }

    public static RadarNearbyResult a(String string, int n2, int n3) {
        if (string == null || string.equals("")) {
            return null;
        }
        RadarNearbyResult radarNearbyResult = new RadarNearbyResult();
        try {
            int n4;
            int n5;
            JSONObject jSONObject = new JSONObject(string);
            if (jSONObject == null) {
                return null;
            }
            radarNearbyResult.totalNum = n5 = jSONObject.optInt("total");
            int n6 = 0;
            JSONArray jSONArray = jSONObject.optJSONArray("pois");
            if (jSONArray != null) {
                n6 = jSONArray.length();
            }
            radarNearbyResult.pageNum = n4 = n5 / n3 + (n5 % n3 > 0 ? 1 : 0);
            radarNearbyResult.pageIndex = n2;
            if (n6 > 0) {
                ArrayList<RadarNearbyInfo> arrayList = new ArrayList<RadarNearbyInfo>();
                for (int i2 = 0; i2 < n6; ++i2) {
                    RadarNearbyInfo radarNearbyInfo = new RadarNearbyInfo();
                    JSONObject jSONObject2 = jSONArray.optJSONObject(i2);
                    if (jSONObject2 == null) continue;
                    radarNearbyInfo.userID = jSONObject2.optString("userid");
                    JSONArray jSONArray2 = jSONObject2.optJSONArray("location");
                    if (jSONArray2 != null) {
                        radarNearbyInfo.pt = new LatLng(jSONArray2.optDouble(1), jSONArray2.optDouble(0));
                        if (SDKInitializer.getCoordType() == CoordType.GCJ02) {
                            radarNearbyInfo.pt = CoordTrans.baiduToGcj(radarNearbyInfo.pt);
                        }
                    }
                    radarNearbyInfo.distance = jSONObject2.optInt("distance");
                    radarNearbyInfo.mobileName = jSONObject2.optString("mb");
                    radarNearbyInfo.mobileOS = jSONObject2.optString("os");
                    radarNearbyInfo.comments = jSONObject2.optString("comments");
                    long l2 = (long)jSONObject2.optDouble("ctm");
                    radarNearbyInfo.timeStamp = new Date(l2 * 1000L);
                    arrayList.add(radarNearbyInfo);
                }
                radarNearbyResult.infoList = arrayList;
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return radarNearbyResult;
    }
}

