/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.lbsapi.panoramaview;

import android.content.Context;
import android.text.TextUtils;
import com.baidu.lbsapi.model.BaiduPanoData;
import com.baidu.lbsapi.model.BaiduPoiPanoData;
import com.baidu.pano.platform.c.c;
import com.baidu.pano.platform.c.f;
import com.baidu.pano.platform.c.i;
import com.baidu.pano.platform.comjni.JNITool;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PanoramaRequest {
    private Context a;
    private static PanoramaRequest b;

    private PanoramaRequest(Context context) {
        this.a = context;
    }

    public static PanoramaRequest getInstance(Context context) {
        if (null == b) {
            b = new PanoramaRequest(context);
        }
        return b;
    }

    public String getPanoramaByIIdWithJson(String iid) {
        if (TextUtils.isEmpty((CharSequence)iid)) {
            throw new IllegalArgumentException("The parameter iid can't be null or empty string!");
        }
        String url = i.a + "&iid=" + iid + "&" + f.a(this.a).toString();
        c httpExecutor = c.a(this.a);
        return this.c(httpExecutor.b(url));
    }

    public String getPanoramaRecommendInfo(String pid) {
        if (TextUtils.isEmpty((CharSequence)pid)) {
            throw new IllegalArgumentException("The parameter pid can't be null or empty string!");
        }
        String url = i.b + "&sid=" + pid + "&" + f.a(this.a).toString();
        c httpExecutor = c.a(this.a);
        return httpExecutor.b(url);
    }

    public String getPoiInfoByUidWithJson(String uid) {
        if (TextUtils.isEmpty((CharSequence)uid)) {
            throw new IllegalArgumentException("The parameter uid can't be null or empty string!");
        }
        String url = i.e + "&action=1&uid=" + uid + "&" + f.a(this.a).toString();
        c httpExecutor = c.a(this.a);
        return httpExecutor.b(url);
    }

    public BaiduPanoData getPanoramaInfoByLatLon(double longitude, double latitude) {
        int mercatorX = (int)JNITool.ll2mc((double)longitude, (double)latitude).x;
        int mercatorY = (int)JNITool.ll2mc((double)longitude, (double)latitude).y;
        return this.getPanoramaInfoByMercator(mercatorX, mercatorY);
    }

    public BaiduPanoData getPanoramaInfoByMercator(int x2, int y2) {
        String url = i.d + "&x=" + x2 + "&y=" + y2 + "&action=1&" + f.a(this.a).toString();
        c httpExecutor = c.a(this.a);
        String responseResult = httpExecutor.b(url);
        return this.a(responseResult);
    }

    public BaiduPoiPanoData getPanoramaInfoByUid(String uid) {
        if (TextUtils.isEmpty((CharSequence)uid)) {
            throw new IllegalArgumentException("The parameter uid can't be null or empty string!");
        }
        String url = i.e + "&uid=" + uid + "&action=1&" + f.a(this.a).toString();
        c httpExecutor = c.a(this.a);
        String responseResult = httpExecutor.b(url);
        return this.b(responseResult);
    }

    private BaiduPanoData a(String json) {
        BaiduPanoData mPanoData = new BaiduPanoData();
        if (TextUtils.isEmpty((CharSequence)json)) {
            return mPanoData;
        }
        try {
            JSONArray jsonArray;
            JSONObject jo = new JSONObject(json);
            if (jo.has("content") && (jsonArray = jo.getJSONArray("content")).length() > 0) {
                JSONObject jsonObject = jsonArray.getJSONObject(0);
                String id = jsonObject.optString("ID", "");
                String mode = jsonObject.optString("Mode", "");
                String roadName = jsonObject.optString("Rname", "");
                int x2 = jsonObject.optInt("X", 0);
                int y2 = jsonObject.optInt("Y", 0);
                mPanoData.setX(x2);
                mPanoData.setY(y2);
                mPanoData.setPid(id);
                mPanoData.setName(roadName);
            }
            int errorCode = 404;
            if (jo.has("result")) {
                JSONObject resultJo = jo.getJSONObject("result");
                errorCode = resultJo.optInt("error", 404);
            }
            mPanoData.setErrorCode(errorCode);
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
        return mPanoData;
    }

    private BaiduPoiPanoData b(String json) {
        BaiduPoiPanoData poiPanoData = new BaiduPoiPanoData();
        if (TextUtils.isEmpty((CharSequence)json)) {
            return poiPanoData;
        }
        try {
            JSONObject jsonObject;
            JSONArray contentJsonArray;
            JSONObject jo = new JSONObject(json);
            if (jo.has("content") && (contentJsonArray = jo.getJSONArray("content")).length() > 0 && (jsonObject = contentJsonArray.getJSONObject(0)).has("poiinfo")) {
                JSONObject panoinfo = jsonObject.getJSONObject("poiinfo");
                float dir = panoinfo.optInt("Dir", 0);
                float pitch = panoinfo.optInt("Pitch", 0);
                String iid = panoinfo.optString("IID", "");
                String pid = panoinfo.optString("PID", "");
                String uid = panoinfo.optString("UID", "");
                int x2 = panoinfo.optInt("X", 0);
                int y2 = panoinfo.optInt("Y", 0);
                String name = panoinfo.optString("name", "");
                String stdTag = panoinfo.optString("std_tag", "");
                poiPanoData.setX(x2);
                poiPanoData.setY(y2);
                poiPanoData.setHeading(dir);
                poiPanoData.setPitch(pitch);
                poiPanoData.setPid(pid);
                poiPanoData.setUid(uid);
                poiPanoData.setIid(iid);
                poiPanoData.setName(name);
                poiPanoData.setPanoTag(stdTag);
            }
            int errorCode = 404;
            if (jo.has("result")) {
                JSONObject resultJo = jo.getJSONObject("result");
                errorCode = resultJo.optInt("error", 404);
            }
            poiPanoData.setErrorCode(errorCode);
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
        return poiPanoData;
    }

    private String c(String inStr) {
        String resultStr;
        StringBuffer sbBreakX = new StringBuffer();
        StringBuffer sbBreakY = new StringBuffer();
        StringBuffer sbX = new StringBuffer();
        StringBuffer sbY = new StringBuffer();
        Pattern patternBreakX = Pattern.compile("\"BreakX\":[0-9]{10}");
        Pattern patternBreakY = Pattern.compile("\"BreakY\":[0-9]{9}");
        Pattern patternX = Pattern.compile("\"X\":[0-9]{10}");
        Pattern patternY = Pattern.compile("\"Y\":[0-9]{9}");
        Matcher matcher = patternBreakX.matcher(inStr);
        while (matcher.find()) {
            resultStr = matcher.group(0).substring(0, matcher.group(0).length() - 2);
            matcher.appendReplacement(sbBreakX, resultStr);
        }
        matcher.appendTail(sbBreakX);
        matcher = patternBreakY.matcher(sbBreakX.toString());
        while (matcher.find()) {
            resultStr = matcher.group(0).substring(0, matcher.group(0).length() - 2);
            matcher.appendReplacement(sbBreakY, resultStr);
        }
        matcher.appendTail(sbBreakY);
        matcher = patternX.matcher(sbBreakY.toString());
        while (matcher.find()) {
            resultStr = matcher.group(0).substring(0, matcher.group(0).length() - 2);
            matcher.appendReplacement(sbX, resultStr);
        }
        matcher.appendTail(sbX);
        matcher = patternY.matcher(sbX.toString());
        while (matcher.find()) {
            resultStr = matcher.group(0).substring(0, matcher.group(0).length() - 2);
            matcher.appendReplacement(sbY, resultStr);
        }
        matcher.appendTail(sbY);
        return sbY.toString();
    }
}

