/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.search.route;

import com.baidu.mapapi.model.CoordUtil;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapapi.model.inner.GeoPoint;
import com.baidu.mapapi.search.core.CityInfo;
import com.baidu.mapapi.search.core.PoiInfo;
import com.baidu.mapapi.search.core.RouteNode;
import com.baidu.mapapi.search.core.SearchResult;
import com.baidu.mapapi.search.core.TaxiInfo;
import com.baidu.mapapi.search.core.VehicleInfo;
import com.baidu.mapapi.search.route.BikingRouteLine;
import com.baidu.mapapi.search.route.BikingRouteResult;
import com.baidu.mapapi.search.route.DrivingRouteLine;
import com.baidu.mapapi.search.route.DrivingRouteResult;
import com.baidu.mapapi.search.route.PlanNode;
import com.baidu.mapapi.search.route.SuggestAddrInfo;
import com.baidu.mapapi.search.route.TransitRouteLine;
import com.baidu.mapapi.search.route.TransitRouteResult;
import com.baidu.mapapi.search.route.WalkingRouteLine;
import com.baidu.mapapi.search.route.WalkingRouteResult;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class h {
    public static TransitRouteResult a(String string) {
        TransitRouteResult transitRouteResult = new TransitRouteResult();
        if (string == null || string.length() <= 0) {
            transitRouteResult.error = SearchResult.ERRORNO.RESULT_NOT_FOUND;
            return transitRouteResult;
        }
        JSONObject jSONObject = null;
        try {
            jSONObject = new JSONObject(string);
        }
        catch (JSONException jSONException) {
            transitRouteResult.error = SearchResult.ERRORNO.RESULT_NOT_FOUND;
            jSONException.printStackTrace();
            return transitRouteResult;
        }
        JSONObject jSONObject2 = jSONObject.optJSONObject("taxi");
        if (jSONObject2 != null) {
            transitRouteResult.a(h.e(jSONObject.optString("taxi")));
        }
        RouteNode routeNode = h.c(jSONObject, "start_point");
        RouteNode routeNode2 = h.c(jSONObject, "end_point");
        JSONArray jSONArray = jSONObject.optJSONArray("routes");
        if (jSONArray == null || jSONArray.length() <= 0) {
            transitRouteResult.error = SearchResult.ERRORNO.RESULT_NOT_FOUND;
            return transitRouteResult;
        }
        ArrayList<TransitRouteLine> arrayList = new ArrayList<TransitRouteLine>();
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            JSONObject jSONObject3 = ((JSONObject)jSONArray.opt(i2)).optJSONObject("legs");
            if (jSONObject3 == null) continue;
            TransitRouteLine transitRouteLine = new TransitRouteLine();
            transitRouteLine.setDistance(jSONObject3.optInt("distance"));
            transitRouteLine.setDuration(jSONObject3.optInt("time"));
            transitRouteLine.setStarting(routeNode);
            transitRouteLine.setTerminal(routeNode2);
            JSONArray jSONArray2 = jSONObject3.optJSONArray("steps");
            if (jSONArray2 == null || jSONArray2.length() <= 0) continue;
            ArrayList<TransitRouteLine.TransitStep> arrayList2 = new ArrayList<TransitRouteLine.TransitStep>();
            for (int i3 = 0; i3 < jSONArray2.length(); ++i3) {
                JSONArray jSONArray3 = jSONArray2.optJSONObject(i3).optJSONArray("busline");
                if (jSONArray3 == null || jSONArray3.length() <= 0) continue;
                JSONObject jSONObject4 = jSONArray3.optJSONObject(0);
                TransitRouteLine.TransitStep transitStep = new TransitRouteLine.TransitStep();
                transitStep.a(RouteNode.location(CoordUtil.decodeLocation(jSONObject4.optString("start_location"))));
                transitStep.b(RouteNode.location(CoordUtil.decodeLocation(jSONObject4.optString("end_location"))));
                int n2 = jSONObject4.optInt("type");
                if (n2 == 5) {
                    transitStep.a(TransitRouteLine.TransitStep.TransitRouteStepType.WAKLING);
                } else {
                    transitStep.a(TransitRouteLine.TransitStep.TransitRouteStepType.WAKLING);
                }
                transitStep.a(h.h(jSONObject4.optString("instructions")));
                transitStep.setDistance(jSONObject4.optInt("distance"));
                transitStep.setDuration(jSONObject4.optInt("duration"));
                transitStep.b(jSONObject4.optString("path_geo"));
                if (jSONObject4.has("vehicle")) {
                    transitStep.a(h.f(jSONObject4.optString("vehicle")));
                    JSONObject jSONObject5 = jSONObject4.optJSONObject("vehicle");
                    transitStep.getEntrance().setUid(jSONObject5.optString("start_uid"));
                    transitStep.getEntrance().setTitle(jSONObject5.optString("start_name"));
                    transitStep.getExit().setUid(jSONObject5.optString("end_uid"));
                    transitStep.getExit().setTitle(jSONObject5.optString("end_name"));
                    Integer n3 = jSONObject5.optInt("type");
                    if (n3 != null) {
                        if (n3 == 1) {
                            transitStep.a(TransitRouteLine.TransitStep.TransitRouteStepType.SUBWAY);
                        } else {
                            transitStep.a(TransitRouteLine.TransitStep.TransitRouteStepType.BUSLINE);
                        }
                    } else {
                        transitStep.a(TransitRouteLine.TransitStep.TransitRouteStepType.BUSLINE);
                    }
                }
                arrayList2.add(transitStep);
            }
            transitRouteLine.setSteps(arrayList2);
            arrayList.add(transitRouteLine);
        }
        transitRouteResult.a(arrayList);
        return transitRouteResult;
    }

    public static DrivingRouteResult b(String string) {
        DrivingRouteResult drivingRouteResult = new DrivingRouteResult();
        if (string == null || "".equals(string)) {
            drivingRouteResult.error = SearchResult.ERRORNO.RESULT_NOT_FOUND;
            return drivingRouteResult;
        }
        JSONObject jSONObject = null;
        try {
            jSONObject = new JSONObject(string);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            drivingRouteResult.error = SearchResult.ERRORNO.RESULT_NOT_FOUND;
            return drivingRouteResult;
        }
        ArrayList<DrivingRouteLine> arrayList = new ArrayList<DrivingRouteLine>();
        JSONArray jSONArray = null;
        jSONArray = jSONObject.optJSONArray("routes");
        if (jSONArray == null) {
            return drivingRouteResult;
        }
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            DrivingRouteLine drivingRouteLine = new DrivingRouteLine();
            drivingRouteLine.setStarting(h.e(jSONObject, "start_point"));
            drivingRouteLine.setTerminal(h.e(jSONObject, "end_point"));
            drivingRouteLine.a(h.f(jSONObject, "waypoints"));
            JSONObject jSONObject2 = jSONArray.optJSONObject(i2);
            if (jSONObject2 == null) continue;
            JSONObject jSONObject3 = jSONObject2.optJSONObject("legs");
            if (jSONObject3 == null) {
                return drivingRouteResult;
            }
            drivingRouteLine.setDistance(jSONObject3.optInt("distance"));
            drivingRouteLine.setDuration(jSONObject3.optInt("duration"));
            JSONArray jSONArray2 = null;
            jSONArray2 = jSONObject3.optJSONArray("steps");
            if (jSONArray2 == null) {
                return drivingRouteResult;
            }
            ArrayList<DrivingRouteLine.DrivingStep> arrayList2 = new ArrayList<DrivingRouteLine.DrivingStep>();
            for (int i3 = 0; i3 < jSONArray2.length(); ++i3) {
                Object object;
                int n2;
                JSONArray jSONArray3;
                DrivingRouteLine.DrivingStep drivingStep = new DrivingRouteLine.DrivingStep();
                JSONObject jSONObject4 = jSONArray2.optJSONObject(i3);
                if (jSONObject4 == null) continue;
                JSONArray jSONArray4 = null;
                jSONArray4 = jSONObject4.optJSONArray("paths");
                if (jSONArray4 == null) {
                    return drivingRouteResult;
                }
                if (jSONArray4.length() >= 2) {
                    jSONArray3 = new ArrayList();
                    for (n2 = 0; n2 < jSONArray4.length(); ++n2) {
                        object = jSONArray4.optJSONObject(n2);
                        GeoPoint geoPoint = new GeoPoint(0.0, 0.0);
                        geoPoint.setLongitudeE6(object.optInt("loc_x"));
                        geoPoint.setLatitudeE6(object.optInt("loc_y"));
                        if (n2 == 0) {
                            drivingStep.a(RouteNode.location(CoordUtil.mc2ll(geoPoint)));
                        } else if (n2 == jSONArray4.length() - 1) {
                            drivingStep.b(RouteNode.location(CoordUtil.mc2ll(geoPoint)));
                        }
                        jSONArray3.add(CoordUtil.mc2ll(geoPoint));
                    }
                    drivingStep.a((List<LatLng>)jSONArray3);
                }
                if ((jSONArray3 = jSONObject4.optJSONArray("traffics")) != null && jSONArray3.length() > 0) {
                    n2 = jSONArray3.length();
                    object = new int[n2];
                    for (int i4 = 0; i4 < n2; ++i4) {
                        object[i4] = (JSONObject)Integer.parseInt((String)jSONArray3.opt(i4));
                    }
                    drivingStep.a((int[])object);
                }
                drivingStep.a(jSONObject4.optInt("direction") * 30);
                drivingStep.setDistance(jSONObject4.optInt("distance"));
                drivingStep.setDuration(jSONObject4.optInt("duration"));
                drivingStep.c(jSONObject4.optString("description"));
                drivingStep.a(jSONObject4.optString("start_desc"));
                drivingStep.b(jSONObject4.optString("end_desc"));
                drivingStep.b(jSONObject4.optInt("turn"));
                arrayList2.add(drivingStep);
            }
            drivingRouteLine.setSteps(arrayList2);
            arrayList.add(drivingRouteLine);
        }
        drivingRouteResult.a(arrayList);
        return drivingRouteResult;
    }

    public static WalkingRouteResult c(String string) {
        ArrayList<WalkingRouteLine> arrayList;
        WalkingRouteResult walkingRouteResult = new WalkingRouteResult();
        if (string == null || "".equals(string)) {
            walkingRouteResult.error = SearchResult.ERRORNO.RESULT_NOT_FOUND;
            return walkingRouteResult;
        }
        JSONObject jSONObject = null;
        try {
            jSONObject = new JSONObject(string);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            walkingRouteResult.error = SearchResult.ERRORNO.RESULT_NOT_FOUND;
            return walkingRouteResult;
        }
        if (jSONObject.has("taxi")) {
            walkingRouteResult.a(h.e(jSONObject.optString("taxi")));
        }
        WalkingRouteLine walkingRouteLine = new WalkingRouteLine();
        walkingRouteLine.setStarting(h.c(jSONObject, "start_point"));
        walkingRouteLine.setTerminal(h.c(jSONObject, "end_point"));
        JSONObject jSONObject2 = jSONObject.optJSONObject("routes");
        if (jSONObject2 == null) {
            return walkingRouteResult;
        }
        JSONObject jSONObject3 = jSONObject2.optJSONObject("legs");
        if (jSONObject3 == null) {
            return walkingRouteResult;
        }
        walkingRouteLine.setDistance(jSONObject3.optInt("distance"));
        walkingRouteLine.setDuration(jSONObject3.optInt("duration"));
        JSONArray jSONArray = null;
        jSONArray = jSONObject3.optJSONArray("steps");
        if (jSONArray != null) {
            arrayList = new ArrayList<WalkingRouteLine>();
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                WalkingRouteLine.WalkingStep walkingStep = new WalkingRouteLine.WalkingStep();
                JSONObject jSONObject4 = jSONArray.optJSONObject(i2);
                if (jSONObject4 == null) continue;
                walkingStep.a(jSONObject4.optInt("direction") * 30);
                walkingStep.setDistance(jSONObject4.optInt("distance"));
                walkingStep.setDuration(jSONObject4.optInt("duration"));
                walkingStep.a(RouteNode.location(CoordUtil.decodeLocation(jSONObject4.optString("start_loc"))));
                walkingStep.b(RouteNode.location(CoordUtil.decodeLocation(jSONObject4.optString("end_loc"))));
                walkingStep.d(jSONObject4.optString("description"));
                walkingStep.b(jSONObject4.optString("start_desc"));
                walkingStep.c(jSONObject4.optString("end_desc"));
                walkingStep.a(jSONObject4.optString("path"));
                arrayList.add((WalkingRouteLine)((Object)walkingStep));
            }
            if (arrayList.size() > 0) {
                walkingRouteLine.setSteps(arrayList);
            }
        }
        arrayList = new ArrayList();
        arrayList.add(walkingRouteLine);
        walkingRouteResult.a(arrayList);
        return walkingRouteResult;
    }

    public static BikingRouteResult d(String string) {
        BikingRouteResult bikingRouteResult = new BikingRouteResult();
        if (string == null || "".equals(string)) {
            bikingRouteResult.error = SearchResult.ERRORNO.RESULT_NOT_FOUND;
            return bikingRouteResult;
        }
        JSONObject jSONObject = null;
        try {
            jSONObject = new JSONObject(string);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            bikingRouteResult.error = SearchResult.ERRORNO.RESULT_NOT_FOUND;
            return bikingRouteResult;
        }
        int n2 = jSONObject.optInt("type");
        if (n2 == 1) {
            SuggestAddrInfo suggestAddrInfo = h.a(jSONObject);
            bikingRouteResult.a(suggestAddrInfo);
            bikingRouteResult.error = SearchResult.ERRORNO.AMBIGUOUS_ROURE_ADDR;
        } else {
            if (n2 == 2) {
                JSONArray jSONArray = jSONObject.optJSONArray("routes");
                ArrayList<BikingRouteLine> arrayList = new ArrayList<BikingRouteLine>();
                for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                    BikingRouteLine bikingRouteLine;
                    block11: {
                        bikingRouteLine = new BikingRouteLine();
                        try {
                            JSONObject jSONObject2 = jSONArray.optJSONObject(i2);
                            bikingRouteLine.setStarting(h.d(jSONObject, "start"));
                            bikingRouteLine.setTerminal(h.d(jSONObject, "end"));
                            if (jSONObject2 == null) {
                                return bikingRouteResult;
                            }
                            bikingRouteLine.setDistance(jSONObject2.optInt("distance"));
                            bikingRouteLine.setDuration(jSONObject2.optInt("duration"));
                            JSONArray jSONArray2 = jSONObject2.optJSONArray("steps");
                            if (jSONArray2 == null) break block11;
                            ArrayList<BikingRouteLine.BikingStep> arrayList2 = new ArrayList<BikingRouteLine.BikingStep>();
                            for (int i3 = 0; i3 < jSONArray2.length(); ++i3) {
                                JSONObject jSONObject3 = jSONArray2.optJSONObject(i3);
                                BikingRouteLine.BikingStep bikingStep = new BikingRouteLine.BikingStep();
                                if (jSONObject3 == null || jSONObject3.length() <= 0) continue;
                                bikingStep.a(jSONObject3.optInt("direction") * 30);
                                bikingStep.setDistance(jSONObject3.optInt("distance"));
                                bikingStep.setDuration(jSONObject3.optInt("duration"));
                                JSONObject jSONObject4 = jSONObject3.optJSONObject("start_pt");
                                JSONObject jSONObject5 = jSONObject3.optJSONObject("end_pt");
                                bikingStep.a(RouteNode.location(new LatLng(jSONObject4.optDouble("lat"), jSONObject4.optDouble("lng"))));
                                bikingStep.b(RouteNode.location(new LatLng(jSONObject5.optDouble("lat"), jSONObject5.optDouble("lng"))));
                                bikingStep.d(jSONObject3.optString("instructions"));
                                bikingStep.b(jSONObject3.optString("start_instructions"));
                                bikingStep.c(jSONObject3.optString("end_instructions"));
                                bikingStep.a(jSONObject3.optString("path"));
                                arrayList2.add(bikingStep);
                            }
                            if (arrayList2.size() <= 0) break block11;
                            bikingRouteLine.setSteps(arrayList2);
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    arrayList.add(bikingRouteLine);
                }
                bikingRouteResult.a(arrayList);
                return bikingRouteResult;
            }
            bikingRouteResult.error = SearchResult.ERRORNO.RESULT_NOT_FOUND;
        }
        return bikingRouteResult;
    }

    private static SuggestAddrInfo a(JSONObject jSONObject) {
        List<Object> list;
        int n2;
        SuggestAddrInfo suggestAddrInfo = new SuggestAddrInfo();
        String string = null;
        String string2 = null;
        JSONObject jSONObject2 = jSONObject.optJSONObject("start_sug");
        JSONObject jSONObject3 = jSONObject.optJSONObject("end_sug");
        if (jSONObject2 != null) {
            n2 = jSONObject2.optInt("listType");
            string = jSONObject2.optString("cityName");
            if (n2 == 1) {
                list = h.b(jSONObject2, "list");
                suggestAddrInfo.d(list);
            } else if (n2 == 0) {
                list = h.b(jSONObject2, "list", string);
                suggestAddrInfo.a(list);
            }
        }
        if (jSONObject3 != null) {
            n2 = jSONObject3.optInt("listType");
            string2 = jSONObject3.optString("cityName");
            if (n2 == 1) {
                list = h.b(jSONObject3, "list");
                suggestAddrInfo.e(list);
            } else if (n2 == 0) {
                list = h.b(jSONObject3, "list", string2);
                suggestAddrInfo.b(list);
            }
        }
        return suggestAddrInfo;
    }

    public static TaxiInfo e(String string) {
        JSONObject jSONObject = null;
        try {
            jSONObject = new JSONObject(string);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        if (jSONObject == null) {
            return null;
        }
        TaxiInfo taxiInfo = new TaxiInfo();
        taxiInfo.setDesc(jSONObject.optString("remark"));
        taxiInfo.setDistance(jSONObject.optInt("distance"));
        taxiInfo.setDuration(jSONObject.optInt("duration"));
        String string2 = jSONObject.optString("total_price");
        String string3 = jSONObject.optString("start_price");
        String string4 = jSONObject.optString("km_price");
        if (string2 == null || string2.equals("")) {
            taxiInfo.setTotalPrice(0.0f);
        } else {
            taxiInfo.setTotalPrice(Float.parseFloat(string2));
        }
        if (string2 == null || string3.equals("")) {
            taxiInfo.setStartPrice(0.0f);
        } else {
            taxiInfo.setStartPrice(Float.parseFloat(string3));
        }
        if (string4 == null || string4.equals("")) {
            taxiInfo.setPerKMPrice(0.0f);
        } else {
            taxiInfo.setPerKMPrice(Float.parseFloat(string4));
        }
        return taxiInfo;
    }

    public static VehicleInfo f(String string) {
        JSONObject jSONObject = null;
        try {
            jSONObject = new JSONObject(string);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        if (jSONObject == null) {
            return null;
        }
        VehicleInfo vehicleInfo = new VehicleInfo();
        vehicleInfo.setZonePrice(jSONObject.optInt("zone_price"));
        vehicleInfo.setTotalPrice(jSONObject.optInt("total_price"));
        vehicleInfo.setTitle(jSONObject.optString("name"));
        vehicleInfo.setPassStationNum(jSONObject.optInt("stop_num"));
        vehicleInfo.setUid(jSONObject.optString("uid"));
        return vehicleInfo;
    }

    private static RouteNode c(JSONObject jSONObject, String string) {
        if (jSONObject == null || string == null || "".equals(string)) {
            return null;
        }
        JSONObject jSONObject2 = jSONObject.optJSONObject(string);
        RouteNode routeNode = new RouteNode();
        routeNode.setTitle(jSONObject2.optString("name"));
        routeNode.setUid(jSONObject2.optString("uid"));
        routeNode.setLocation(CoordUtil.decodeLocation(jSONObject2.optString("geo")));
        return routeNode;
    }

    private static RouteNode d(JSONObject jSONObject, String string) {
        if (jSONObject == null || string == null || "".equals(string)) {
            return null;
        }
        JSONObject jSONObject2 = jSONObject.optJSONObject(string);
        RouteNode routeNode = new RouteNode();
        routeNode.setTitle(jSONObject2.optString("name"));
        routeNode.setUid(jSONObject2.optString("uid"));
        routeNode.setLocation(new LatLng(jSONObject2.optDouble("lat"), jSONObject2.optDouble("lng")));
        return routeNode;
    }

    private static RouteNode e(JSONObject jSONObject, String string) {
        if (jSONObject == null || string == null || "".equals(string)) {
            return null;
        }
        JSONObject jSONObject2 = jSONObject.optJSONObject(string);
        RouteNode routeNode = new RouteNode();
        routeNode.setTitle(jSONObject2.optString("name"));
        GeoPoint geoPoint = new GeoPoint(0.0, 0.0);
        geoPoint.setLongitudeE6(jSONObject2.optInt("loc_x"));
        geoPoint.setLatitudeE6(jSONObject2.optInt("loc_y"));
        routeNode.setLocation(CoordUtil.mc2ll(geoPoint));
        return routeNode;
    }

    private static List<RouteNode> f(JSONObject jSONObject, String string) {
        if (jSONObject == null || string == null || "".equals(string)) {
            return null;
        }
        JSONArray jSONArray = jSONObject.optJSONArray(string);
        if (jSONArray == null) {
            return null;
        }
        ArrayList<RouteNode> arrayList = new ArrayList<RouteNode>();
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            RouteNode routeNode = new RouteNode();
            try {
                routeNode.setTitle(jSONArray.getJSONObject(i2).optString("name"));
                routeNode.setUid(jSONArray.getJSONObject(i2).optString("uid"));
                GeoPoint geoPoint = new GeoPoint(0.0, 0.0);
                geoPoint.setLongitudeE6(jSONArray.getJSONObject(i2).optInt("loc_x"));
                geoPoint.setLatitudeE6(jSONArray.getJSONObject(i2).optInt("loc_y"));
                routeNode.setLocation(CoordUtil.mc2ll(geoPoint));
                arrayList.add(routeNode);
                continue;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public static SuggestAddrInfo g(String string) {
        if (string == null || "".equals(string)) {
            return null;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            JSONObject jSONObject2 = jSONObject.optJSONObject("address_info");
            if (jSONObject2 == null) {
                return null;
            }
            SuggestAddrInfo suggestAddrInfo = new SuggestAddrInfo();
            String string2 = null;
            String string3 = null;
            string2 = jSONObject2.optString("st_cityname");
            string3 = jSONObject2.optString("en_cityname");
            if (jSONObject.optBoolean("hasAddrList")) {
                suggestAddrInfo.d(h.a(jSONObject, "startcitys"));
                suggestAddrInfo.a(h.a(jSONObject, "startpoints", string2));
                suggestAddrInfo.e(h.a(jSONObject, "endcitys"));
                suggestAddrInfo.b(h.a(jSONObject, "endpoints", string3));
                JSONArray jSONArray = jSONObject.optJSONArray("waypoints_result");
                if (jSONArray == null || jSONArray.length() <= 0) {
                    return suggestAddrInfo;
                }
                ArrayList<List<CityInfo>> arrayList = new ArrayList<List<CityInfo>>();
                ArrayList<List<PoiInfo>> arrayList2 = new ArrayList<List<PoiInfo>>();
                for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                    List<PoiInfo> list;
                    JSONObject jSONObject3 = jSONArray.getJSONObject(i2);
                    List<CityInfo> list2 = h.a(jSONObject3, "waypointcitys");
                    if (list2 != null) {
                        arrayList.add(list2);
                    }
                    if ((list = h.a(jSONObject3, "waypoints", "")) == null) continue;
                    arrayList2.add(list);
                }
                if (arrayList.size() > 0) {
                    suggestAddrInfo.f(arrayList);
                }
                if (arrayList2.size() > 0) {
                    suggestAddrInfo.c(arrayList2);
                }
            }
            return suggestAddrInfo;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return null;
        }
    }

    public static List<CityInfo> a(JSONObject jSONObject, String string) {
        if (jSONObject == null || string == null || string.equals("")) {
            return null;
        }
        JSONArray jSONArray = jSONObject.optJSONArray(string);
        if (jSONArray != null && jSONArray.length() > 0) {
            ArrayList<CityInfo> arrayList = new ArrayList<CityInfo>();
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                JSONObject jSONObject2 = (JSONObject)jSONArray.opt(i2);
                if (jSONObject2 == null) continue;
                CityInfo cityInfo = new CityInfo();
                cityInfo.num = jSONObject2.optInt("num");
                cityInfo.city = jSONObject2.optString("name");
                arrayList.add(cityInfo);
            }
            arrayList.trimToSize();
            return arrayList;
        }
        return null;
    }

    public static List<CityInfo> b(JSONObject jSONObject, String string) {
        if (jSONObject == null || string == null || string.equals("")) {
            return null;
        }
        JSONArray jSONArray = jSONObject.optJSONArray(string);
        if (jSONArray != null && jSONArray.length() > 0) {
            ArrayList<CityInfo> arrayList = new ArrayList<CityInfo>();
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                JSONObject jSONObject2 = (JSONObject)jSONArray.opt(i2);
                if (jSONObject2 == null) continue;
                CityInfo cityInfo = new CityInfo();
                cityInfo.num = jSONObject2.optInt("number");
                cityInfo.city = jSONObject2.optString("name");
                arrayList.add(cityInfo);
            }
            arrayList.trimToSize();
            return arrayList;
        }
        return null;
    }

    private static List<PoiInfo> a(JSONObject jSONObject, String string, String string2) {
        if (jSONObject == null || string == null || "".equals(string)) {
            return null;
        }
        JSONArray jSONArray = jSONObject.optJSONArray(string);
        if (jSONArray != null) {
            ArrayList<PoiInfo> arrayList = new ArrayList<PoiInfo>();
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                JSONObject jSONObject2 = (JSONObject)jSONArray.opt(i2);
                if (jSONObject2 == null) continue;
                PoiInfo poiInfo = new PoiInfo();
                PlanNode planNode = PlanNode.withCityNameAndPlaceName(string2, jSONObject2.optString("name"));
                poiInfo.address = jSONObject2.optString("addr");
                poiInfo.uid = jSONObject2.optString("uid");
                poiInfo.name = jSONObject2.optString("name");
                poiInfo.location = CoordUtil.decodeLocation(jSONObject2.optString("geo"));
                poiInfo.city = string2;
                arrayList.add(poiInfo);
            }
            if (arrayList.size() > 0) {
                return arrayList;
            }
        }
        return null;
    }

    private static List<PoiInfo> b(JSONObject jSONObject, String string, String string2) {
        if (jSONObject == null || string == null || "".equals(string)) {
            return null;
        }
        JSONArray jSONArray = jSONObject.optJSONArray(string);
        if (jSONArray != null) {
            ArrayList<PoiInfo> arrayList = new ArrayList<PoiInfo>();
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                JSONObject jSONObject2 = (JSONObject)jSONArray.opt(i2);
                if (jSONObject2 == null) continue;
                PoiInfo poiInfo = new PoiInfo();
                if (jSONObject2.has("address")) {
                    poiInfo.address = jSONObject2.optString("address");
                }
                poiInfo.uid = jSONObject2.optString("uid");
                poiInfo.name = jSONObject2.optString("name");
                double d2 = jSONObject2.optDouble("lat");
                double d3 = jSONObject2.optDouble("lng");
                poiInfo.location = new LatLng(d2, d3);
                poiInfo.city = string2;
                arrayList.add(poiInfo);
            }
            if (arrayList.size() > 0) {
                return arrayList;
            }
        }
        return null;
    }

    public static String h(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = string.toCharArray();
        boolean bl = false;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] == '<') {
                bl = true;
                continue;
            }
            if (cArray[i2] == '>') {
                bl = false;
                continue;
            }
            if (bl) continue;
            stringBuilder.append(cArray[i2]);
        }
        return stringBuilder.toString();
    }
}

