/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.baidu.mapapi.common.SysOSUtil;
import com.baidu.mapapi.map.BitmapDescriptor;
import com.baidu.mapapi.map.BitmapDescriptorFactory;
import com.baidu.mapapi.map.HeatMap;
import com.baidu.mapapi.map.InfoWindow;
import com.baidu.mapapi.map.MapPoi;
import com.baidu.mapapi.map.MapStatus;
import com.baidu.mapapi.map.MapStatusUpdate;
import com.baidu.mapapi.map.MapStatusUpdateFactory;
import com.baidu.mapapi.map.MapView;
import com.baidu.mapapi.map.MapViewLayoutParams;
import com.baidu.mapapi.map.Marker;
import com.baidu.mapapi.map.MarkerOptions;
import com.baidu.mapapi.map.MyLocationConfiguration;
import com.baidu.mapapi.map.MyLocationData;
import com.baidu.mapapi.map.Overlay;
import com.baidu.mapapi.map.OverlayOptions;
import com.baidu.mapapi.map.Polyline;
import com.baidu.mapapi.map.Projection;
import com.baidu.mapapi.map.TextureMapView;
import com.baidu.mapapi.map.TileOverlay;
import com.baidu.mapapi.map.TileOverlayOptions;
import com.baidu.mapapi.map.UiSettings;
import com.baidu.mapapi.map.a;
import com.baidu.mapapi.map.b;
import com.baidu.mapapi.map.c;
import com.baidu.mapapi.map.d;
import com.baidu.mapapi.model.CoordUtil;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapapi.model.LatLngBounds;
import com.baidu.mapapi.model.ParcelItem;
import com.baidu.mapapi.model.inner.GeoPoint;
import com.baidu.platform.comapi.map.A;
import com.baidu.platform.comapi.map.B;
import com.baidu.platform.comapi.map.C;
import com.baidu.platform.comapi.map.f;
import com.baidu.platform.comapi.map.g;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.microedition.khronos.opengles.GL10;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BaiduMap {
    public static final int MAP_TYPE_NORMAL = 1;
    public static final int MAP_TYPE_SATELLITE = 2;
    public static final int MAP_TYPE_NONE = 3;
    private static final String d = BaiduMap.class.getSimpleName();
    private Projection e;
    private UiSettings f;
    private g g;
    private com.baidu.platform.comapi.map.c h;
    private C i;
    private List<Overlay> j;
    private List<Marker> k;
    private List<Marker> l;
    private Overlay.a m;
    private OnMapStatusChangeListener n;
    private OnMapTouchListener o;
    private OnMapClickListener p;
    private OnMapLoadedCallback q;
    private OnMapDoubleClickListener r;
    private OnMapLongClickListener s;
    private CopyOnWriteArrayList<OnMarkerClickListener> t = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<OnPolylineClickListener> u = new CopyOnWriteArrayList();
    private OnMarkerDragListener v;
    private OnMyLocationClickListener w;
    private SnapshotReadyCallback x;
    private OnMapDrawFrameCallback y;
    private TileOverlay z;
    private HeatMap A;
    private Lock B = new ReentrantLock();
    private Lock C = new ReentrantLock();
    private InfoWindow D;
    private Marker E;
    private View F;
    private Marker G;
    private MyLocationData H;
    private MyLocationConfiguration I;
    MapView a;
    TextureMapView b;
    A c;
    private boolean J;
    private boolean K;

    private void c() {
        this.j = new CopyOnWriteArrayList<Overlay>();
        this.k = new CopyOnWriteArrayList<Marker>();
        this.l = new CopyOnWriteArrayList<Marker>();
        this.f = new UiSettings(this.h);
        this.m = new a(this);
        b b2 = new b(this);
        this.h.a(b2);
        c c2 = new c(this);
        this.h.a(c2);
        d d2 = new d(this);
        this.h.a(d2);
        this.J = this.h.x();
    }

    BaiduMap(C c2) {
        this.i = c2;
        this.h = this.i.b();
        this.c = com.baidu.platform.comapi.map.A.b;
        this.c();
    }

    BaiduMap(g g2) {
        this.g = g2;
        this.h = this.g.a();
        this.c = com.baidu.platform.comapi.map.A.a;
        this.c();
    }

    public final Overlay addOverlay(OverlayOptions overlayOptions) {
        Marker marker;
        if (overlayOptions == null) {
            return null;
        }
        Overlay overlay = overlayOptions.a();
        overlay.listener = this.m;
        if (overlay instanceof Marker) {
            marker = (Marker)overlay;
            if (marker.n != null && marker.n.size() != 0) {
                this.k.add(marker);
                if (this.h != null) {
                    this.h.b(true);
                }
            }
            this.l.add(marker);
        }
        marker = new Bundle();
        overlay.a((Bundle)marker);
        if (this.h != null) {
            this.h.b((Bundle)marker);
        }
        this.j.add(overlay);
        return overlay;
    }

    public final List<Overlay> addOverlays(List<OverlayOptions> list) {
        Object object;
        if (list == null) {
            return null;
        }
        ArrayList<Overlay> arrayList = new ArrayList<Overlay>();
        Bundle[] bundleArray = new Bundle[list.size()];
        int n2 = 0;
        for (OverlayOptions overlayOptions : list) {
            if (overlayOptions == null) continue;
            object = new Bundle();
            Overlay overlay = overlayOptions.a();
            overlay.listener = this.m;
            if (overlay instanceof Marker) {
                Marker marker = (Marker)overlay;
                if (marker.n != null && marker.n.size() != 0) {
                    this.k.add(marker);
                    if (this.h != null) {
                        this.h.b(true);
                    }
                }
                this.l.add(marker);
                overlay.a((Bundle)object);
                bundleArray[n2] = object;
                arrayList.add(overlay);
            }
            ++n2;
        }
        int n3 = bundleArray.length / 400;
        for (int i2 = 0; i2 < n3 + 1; ++i2) {
            object = new ArrayList();
            for (int i3 = 0; i3 < 400 && i2 * 400 + i3 < bundleArray.length; ++i3) {
                if (bundleArray[i2 * 400 + i3] == null) continue;
                object.add(bundleArray[i2 * 400 + i3]);
            }
            this.h.a((List<Bundle>)object);
        }
        return arrayList;
    }

    public List<Marker> getMarkersInBounds(LatLngBounds latLngBounds) {
        MapStatus mapStatus = this.getMapStatus();
        if (mapStatus == null) {
            return null;
        }
        ArrayList<Marker> arrayList = new ArrayList<Marker>();
        if (this.l.size() == 0) {
            return null;
        }
        for (Marker marker : this.l) {
            if (!latLngBounds.contains(marker.getPosition())) continue;
            arrayList.add(marker);
        }
        return arrayList;
    }

    public final void clear() {
        this.j.clear();
        this.k.clear();
        this.l.clear();
        if (this.h != null) {
            this.h.b(false);
            this.h.m();
        }
        this.hideInfoWindow();
    }

    public final void setMapStatus(MapStatusUpdate mapStatusUpdate) {
        if (mapStatusUpdate == null) {
            return;
        }
        B b2 = this.a(mapStatusUpdate);
        if (this.h == null) {
            return;
        }
        this.h.a(b2);
        if (this.n != null) {
            this.n.onMapStatusChange(this.getMapStatus());
        }
    }

    public final MapStatus getMapStatus() {
        if (this.h == null) {
            return null;
        }
        B b2 = this.h.y();
        return MapStatus.a(b2);
    }

    public final LatLngBounds getMapStatusLimit() {
        if (this.h == null) {
            return null;
        }
        return this.h.z();
    }

    public final void setMapStatusLimits(LatLngBounds latLngBounds) {
        if (this.h == null) {
            return;
        }
        this.h.a(latLngBounds);
        MapStatusUpdate mapStatusUpdate = MapStatusUpdateFactory.newLatLngBounds(latLngBounds);
        this.setMapStatus(mapStatusUpdate);
    }

    public final void animateMapStatus(MapStatusUpdate mapStatusUpdate, int n2) {
        if (mapStatusUpdate == null || n2 <= 0) {
            return;
        }
        B b2 = this.a(mapStatusUpdate);
        if (this.h == null) {
            return;
        }
        if (!this.K) {
            this.h.a(b2);
        } else {
            this.h.a(b2, n2);
        }
    }

    public final void animateMapStatus(MapStatusUpdate mapStatusUpdate) {
        this.animateMapStatus(mapStatusUpdate, 300);
    }

    private B a(MapStatusUpdate mapStatusUpdate) {
        if (this.h == null) {
            return null;
        }
        B b2 = this.h.y();
        MapStatus mapStatus = mapStatusUpdate.a(this.h, this.getMapStatus());
        B b3 = mapStatus.b(b2);
        return b3;
    }

    public final void setMapType(int n2) {
        if (this.h == null) {
            return;
        }
        switch (n2) {
            case 3: {
                if (this.h.x()) {
                    this.h.o(false);
                }
                this.h.d(false);
                break;
            }
            case 1: {
                this.h.a(false);
                this.h.o(this.J);
                this.h.d(true);
                break;
            }
            case 2: {
                this.h.a(true);
                this.h.o(this.J);
                this.h.d(true);
                break;
            }
        }
    }

    public final int getMapType() {
        if (this.h == null) {
            return 1;
        }
        if (!this.h.k()) {
            return 3;
        }
        return this.h.j() ? 2 : 1;
    }

    public final float getMaxZoomLevel() {
        if (this.h == null) {
            return 0.0f;
        }
        return this.h.a;
    }

    public final void setMaxAndMinZoomLevel(float f2, float f3) {
        if (f2 > 21.0f) {
            return;
        }
        if (f3 < 3.0f) {
            return;
        }
        if (f2 < f3) {
            return;
        }
        if (this.h != null) {
            this.h.a(f2, f3);
        }
    }

    public final float getMinZoomLevel() {
        if (this.h == null) {
            return 0.0f;
        }
        return this.h.b;
    }

    public final Projection getProjection() {
        return this.e;
    }

    public final UiSettings getUiSettings() {
        return this.f;
    }

    public final void setBuildingsEnabled(boolean bl) {
        if (this.h != null) {
            this.h.g(bl);
        }
    }

    public final boolean isBuildingsEnabled() {
        if (this.h == null) {
            return false;
        }
        return this.h.l();
    }

    public final void setMyLocationEnabled(boolean bl) {
        if (this.h != null) {
            this.h.i(bl);
        }
    }

    public final boolean isMyLocationEnabled() {
        if (this.h == null) {
            return false;
        }
        return this.h.p();
    }

    public final void setMyLocationData(MyLocationData myLocationData) {
        this.H = myLocationData;
        if (this.I == null) {
            this.I = new MyLocationConfiguration(MyLocationConfiguration.LocationMode.NORMAL, false, null);
        }
        this.a(myLocationData, this.I);
    }

    public final MyLocationData getLocationData() {
        return this.H;
    }

    public final void setMyLocationConfigeration(MyLocationConfiguration myLocationConfiguration) {
        this.I = myLocationConfiguration;
        this.a(this.H, this.I);
    }

    public final MyLocationConfiguration getLocationConfigeration() {
        return this.I;
    }

    private final void a(MyLocationData myLocationData, MyLocationConfiguration myLocationConfiguration) {
        Object object;
        Bundle bundle;
        if (myLocationData == null || myLocationConfiguration == null || !this.isMyLocationEnabled()) {
            return;
        }
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        JSONObject jSONObject3 = new JSONObject();
        LatLng latLng = new LatLng(myLocationData.latitude, myLocationData.longitude);
        GeoPoint geoPoint = CoordUtil.ll2mc(latLng);
        try {
            jSONObject.put("type", 0);
            jSONObject2.put("ptx", geoPoint.getLongitudeE6());
            jSONObject2.put("pty", geoPoint.getLatitudeE6());
            float f2 = CoordUtil.getMCDistanceByOneLatLngAndRadius(latLng, (int)myLocationData.accuracy);
            jSONObject2.put("radius", (double)f2);
            float f3 = myLocationData.direction;
            if (myLocationConfiguration.enableDirection) {
                f3 = myLocationData.direction % 360.0f;
                if (f3 > 180.0f) {
                    f3 -= 360.0f;
                } else if (f3 < -180.0f) {
                    f3 += 360.0f;
                }
            } else {
                f3 = -1.0f;
            }
            jSONObject2.put("direction", (double)f3);
            jSONObject2.put("iconarrownor", (Object)"NormalLocArrow");
            jSONObject2.put("iconarrownorid", 28);
            jSONObject2.put("iconarrowfoc", (Object)"FocusLocArrow");
            jSONObject2.put("iconarrowfocid", 29);
            jSONObject2.put("lineid", myLocationConfiguration.accuracyCircleStrokeColor);
            jSONObject2.put("areaid", myLocationConfiguration.accuracyCircleFillColor);
            jSONArray.put((Object)jSONObject2);
            jSONObject.put("data", (Object)jSONArray);
            if (myLocationConfiguration.locationMode == MyLocationConfiguration.LocationMode.COMPASS) {
                jSONObject3.put("ptx", geoPoint.getLongitudeE6());
                jSONObject3.put("pty", geoPoint.getLatitudeE6());
                jSONObject3.put("radius", 0);
                jSONObject3.put("direction", 0);
                jSONObject3.put("iconarrownor", (Object)"direction_wheel");
                jSONObject3.put("iconarrownorid", 54);
                jSONObject3.put("iconarrowfoc", (Object)"direction_wheel");
                jSONObject3.put("iconarrowfocid", 54);
                jSONArray.put((Object)jSONObject3);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        if (myLocationConfiguration.customMarker == null) {
            bundle = null;
        } else {
            ArrayList<BitmapDescriptor> arrayList = new ArrayList<BitmapDescriptor>();
            arrayList.add(myLocationConfiguration.customMarker);
            bundle = new Bundle();
            object = new ArrayList();
            for (BitmapDescriptor bitmapDescriptor : arrayList) {
                ParcelItem parcelItem = new ParcelItem();
                Bundle bundle2 = new Bundle();
                Bitmap bitmap = bitmapDescriptor.a;
                ByteBuffer byteBuffer = ByteBuffer.allocate(bitmap.getWidth() * bitmap.getHeight() * 4);
                bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
                byte[] byArray = byteBuffer.array();
                bundle2.putByteArray("imgdata", byArray);
                bundle2.putInt("imgindex", bitmapDescriptor.hashCode());
                bundle2.putInt("imgH", bitmap.getHeight());
                bundle2.putInt("imgW", bitmap.getWidth());
                parcelItem.setBundle(bundle2);
                ((ArrayList)object).add(parcelItem);
            }
            if (((ArrayList)object).size() > 0) {
                Parcelable[] parcelableArray = new ParcelItem[((ArrayList)object).size()];
                for (int i2 = 0; i2 < ((ArrayList)object).size(); ++i2) {
                    parcelableArray[i2] = (ParcelItem)((ArrayList)object).get(i2);
                }
                bundle.putParcelableArray("icondata", parcelableArray);
            }
        }
        if (this.h != null) {
            this.h.a(jSONObject.toString(), bundle);
        }
        switch (myLocationConfiguration.locationMode) {
            case COMPASS: {
                MapStatus mapStatus = new MapStatus.Builder().rotate(myLocationData.direction).overlook(-45.0f).target(new LatLng(myLocationData.latitude, myLocationData.longitude)).targetScreen(this.getMapStatus().targetScreen).zoom(this.getMapStatus().zoom).build();
                object = MapStatusUpdateFactory.newMapStatus(mapStatus);
                this.animateMapStatus((MapStatusUpdate)object);
                break;
            }
            case FOLLOWING: {
                MapStatus mapStatus = new MapStatus.Builder().target(new LatLng(myLocationData.latitude, myLocationData.longitude)).zoom(this.getMapStatus().zoom).rotate(this.getMapStatus().rotate).overlook(this.getMapStatus().overlook).targetScreen(this.getMapStatus().targetScreen).build();
                object = MapStatusUpdateFactory.newMapStatus(mapStatus);
                this.animateMapStatus((MapStatusUpdate)object);
                break;
            }
            case NORMAL: {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeatMap(HeatMap heatMap) {
        if (heatMap == null) {
            return;
        }
        this.B.lock();
        try {
            if (heatMap == this.A) {
                return;
            }
            if (this.A != null) {
                this.A.b();
                this.A.c();
                this.A.a = null;
                this.h.n();
            }
            this.A = heatMap;
            this.A.a = this;
            this.h.j(true);
        }
        finally {
            this.B.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(HeatMap heatMap) {
        this.B.lock();
        try {
            if (this.A != null && this.h != null && heatMap == this.A) {
                this.A.b();
                this.A.c();
                this.A.a = null;
                this.h.n();
                this.A = null;
                this.h.j(false);
            }
        }
        finally {
            this.B.unlock();
        }
    }

    void a() {
        if (this.h == null) {
            return;
        }
        this.h.q();
    }

    public final void setBaiduHeatMapEnabled(boolean bl) {
        if (this.h != null) {
            this.h.e(bl);
        }
    }

    public void setCompassPosition(Point point) {
        this.h.a(point);
    }

    public final Point getCompassPosition() {
        if (this.h != null) {
            String string = this.h.g();
            return this.a(string);
        }
        return null;
    }

    private Point a(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        for (String string2 : string.replaceAll("^\\{", "").replaceAll("\\}$", "").split(",")) {
            String[] stringArray = string2.replaceAll("\"", "").split(":");
            if ("x".equals(stringArray[0])) {
                n2 = Integer.valueOf(stringArray[1]);
            }
            if (!"y".equals(stringArray[0])) continue;
            n3 = Integer.valueOf(stringArray[1]);
        }
        return new Point(n2, n3);
    }

    public final boolean isBaiduHeatMapEnabled() {
        if (this.h == null) {
            return false;
        }
        return this.h.h();
    }

    public final boolean isSupportBaiduHeatMap() {
        if (this.h == null) {
            return false;
        }
        return this.h.i();
    }

    public final void setTrafficEnabled(boolean bl) {
        if (this.h != null) {
            this.h.f(bl);
        }
    }

    public final boolean isTrafficEnabled() {
        if (this.h == null) {
            return false;
        }
        return this.h.f();
    }

    public final void showMapPoi(boolean bl) {
        if (this.h != null) {
            this.h.o(bl);
            this.J = bl;
        }
    }

    public final void setPadding(int n2, int n3, int n4, int n5) {
        if (n2 < 0 || n3 < 0 || n4 < 0 || n5 < 0) {
            return;
        }
        if (this.h == null) {
            return;
        }
        B b2 = this.h.y();
        int n6 = (int)(40.0f * SysOSUtil.getDensity());
        int n7 = (int)(40.0f * SysOSUtil.getDensity());
        switch (this.c) {
            case b: {
                if (this.b == null) {
                    return;
                }
                float f2 = (float)(this.b.getWidth() - n2 - n4) / (float)this.b.getWidth();
                float f3 = (float)(this.b.getHeight() - n3 - n5) / (float)this.b.getHeight();
                int n8 = (int)((float)b2.f * f2 + (float)n2);
                int n9 = (int)((float)b2.g * f3 + (float)n3);
                MapStatus mapStatus = new MapStatus.Builder().targetScreen(new Point(n8, n9)).build();
                MapStatusUpdate mapStatusUpdate = MapStatusUpdateFactory.newMapStatus(mapStatus);
                this.h.a(new Point((int)((float)n2 + (float)n6 * f2), (int)((float)n3 + (float)n7 * f3)));
                this.setMapStatus(mapStatusUpdate);
                this.b.setPadding(n2, n3, n4, n5);
                this.b.invalidate();
                break;
            }
            case a: {
                if (this.a == null) {
                    return;
                }
                float f4 = (float)(this.a.getWidth() - n2 - n4) / (float)this.a.getWidth();
                float f5 = (float)(this.a.getHeight() - n3 - n5) / (float)this.a.getHeight();
                int n10 = (int)((float)b2.f * f4 + (float)n2);
                int n11 = (int)((float)b2.g * f5 + (float)n3);
                MapStatus mapStatus = new MapStatus.Builder().targetScreen(new Point(n10, n11)).build();
                MapStatusUpdate mapStatusUpdate = MapStatusUpdateFactory.newMapStatus(mapStatus);
                this.h.a(new Point((int)((float)n2 + (float)n6 * f4), (int)((float)n3 + (float)n7 * f5)));
                this.setMapStatus(mapStatusUpdate);
                this.a.setPadding(n2, n3, n4, n5);
                this.a.invalidate();
                break;
            }
        }
    }

    public final void snapshot(SnapshotReadyCallback snapshotReadyCallback) {
        this.x = snapshotReadyCallback;
        switch (this.c) {
            case b: {
                if (this.i == null) break;
                this.i.a("anything", null);
                break;
            }
            case a: {
                if (this.g == null) break;
                this.g.a("anything", null);
                break;
            }
        }
    }

    public final void snapshotScope(Rect rect, SnapshotReadyCallback snapshotReadyCallback) {
        this.x = snapshotReadyCallback;
        switch (this.c) {
            case b: {
                if (this.i == null) break;
                this.i.a("anything", rect);
                break;
            }
            case a: {
                if (this.g == null) break;
                this.g.a("anything", rect);
                break;
            }
        }
    }

    public void showInfoWindow(InfoWindow infoWindow) {
        if (infoWindow != null) {
            Object object;
            Object object2;
            this.hideInfoWindow();
            if (infoWindow.b != null) {
                this.F = infoWindow.b;
                this.F.destroyDrawingCache();
                object2 = new MapViewLayoutParams.Builder();
                object = ((MapViewLayoutParams.Builder)object2).layoutMode(MapViewLayoutParams.ELayoutMode.mapMode).position(infoWindow.c).yOffset(infoWindow.e).build();
                switch (this.c) {
                    case b: {
                        if (this.b == null) break;
                        this.b.addView(this.F, (ViewGroup.LayoutParams)object);
                        break;
                    }
                    case a: {
                        if (this.g == null) break;
                        this.a.addView(this.F, (ViewGroup.LayoutParams)object);
                        break;
                    }
                }
            }
            this.D = infoWindow;
            object2 = infoWindow.b != null ? BitmapDescriptorFactory.fromView(infoWindow.b) : infoWindow.a;
            object = new MarkerOptions().perspective(false).icon((BitmapDescriptor)object2).position(infoWindow.c).zIndex(Integer.MAX_VALUE).a(infoWindow.e);
            Overlay overlay = ((MarkerOptions)object).a();
            overlay.listener = this.m;
            overlay.q = com.baidu.platform.comapi.map.f.b;
            Bundle bundle = new Bundle();
            overlay.a(bundle);
            if (this.h != null) {
                this.h.b(bundle);
            }
            this.j.add(overlay);
            this.E = (Marker)overlay;
        }
    }

    public void hideInfoWindow() {
        if (this.D != null) {
            if (this.D.b != null) {
                switch (this.c) {
                    case b: {
                        if (this.b == null) break;
                        this.b.removeView(this.F);
                        break;
                    }
                    case a: {
                        if (this.g == null) break;
                        this.a.removeView(this.F);
                        break;
                    }
                }
                this.F = null;
            }
            this.D = null;
            this.E.remove();
            this.E = null;
        }
    }

    public final void setOnMapStatusChangeListener(OnMapStatusChangeListener onMapStatusChangeListener) {
        this.n = onMapStatusChangeListener;
    }

    public final void setOnMapTouchListener(OnMapTouchListener onMapTouchListener) {
        this.o = onMapTouchListener;
    }

    public final void setOnMapClickListener(OnMapClickListener onMapClickListener) {
        this.p = onMapClickListener;
    }

    public void setOnMapLoadedCallback(OnMapLoadedCallback onMapLoadedCallback) {
        this.q = onMapLoadedCallback;
    }

    public final void setOnMapDoubleClickListener(OnMapDoubleClickListener onMapDoubleClickListener) {
        this.r = onMapDoubleClickListener;
    }

    public final void setOnMapLongClickListener(OnMapLongClickListener onMapLongClickListener) {
        this.s = onMapLongClickListener;
    }

    public final void setOnPolylineClickListener(OnPolylineClickListener onPolylineClickListener) {
        if (onPolylineClickListener != null) {
            this.u.add(onPolylineClickListener);
        }
    }

    public final void setOnMarkerClickListener(OnMarkerClickListener onMarkerClickListener) {
        if (onMarkerClickListener != null && !this.t.contains(onMarkerClickListener)) {
            this.t.add(onMarkerClickListener);
        }
    }

    public final void setOnMarkerDragListener(OnMarkerDragListener onMarkerDragListener) {
        this.v = onMarkerDragListener;
    }

    public final void setOnMyLocationClickListener(OnMyLocationClickListener onMyLocationClickListener) {
        this.w = onMyLocationClickListener;
    }

    public final void setOnMapDrawFrameCallback(OnMapDrawFrameCallback onMapDrawFrameCallback) {
        this.y = onMapDrawFrameCallback;
    }

    public final void removeMarkerClickListener(OnMarkerClickListener onMarkerClickListener) {
        if (this.t.contains(onMarkerClickListener)) {
            this.t.remove(onMarkerClickListener);
        }
    }

    public TileOverlay addTileLayer(TileOverlayOptions tileOverlayOptions) {
        if (tileOverlayOptions == null) {
            return null;
        }
        if (this.z != null) {
            this.z.b();
            this.z.a = null;
        }
        if (this.h != null && this.h.a(tileOverlayOptions.a())) {
            TileOverlay tileOverlay;
            this.z = tileOverlay = tileOverlayOptions.a(this);
            return tileOverlay;
        }
        return null;
    }

    boolean b() {
        if (this.h == null) {
            return false;
        }
        return this.h.d();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(TileOverlay tileOverlay) {
        this.C.lock();
        try {
            if (tileOverlay != null && this.z == tileOverlay) {
                tileOverlay.b();
                tileOverlay.a = null;
                tileOverlay = null;
                if (this.h != null) {
                    this.h.c(false);
                }
            }
        }
        finally {
            this.z = null;
            this.C.unlock();
        }
    }

    static /* synthetic */ List a(BaiduMap baiduMap) {
        return baiduMap.j;
    }

    static /* synthetic */ com.baidu.platform.comapi.map.c b(BaiduMap baiduMap) {
        return baiduMap.h;
    }

    static /* synthetic */ List c(BaiduMap baiduMap) {
        return baiduMap.l;
    }

    static /* synthetic */ List d(BaiduMap baiduMap) {
        return baiduMap.k;
    }

    static /* synthetic */ View e(BaiduMap baiduMap) {
        return baiduMap.F;
    }

    static /* synthetic */ OnMapStatusChangeListener f(BaiduMap baiduMap) {
        return baiduMap.n;
    }

    static /* synthetic */ OnMapTouchListener g(BaiduMap baiduMap) {
        return baiduMap.o;
    }

    static /* synthetic */ OnMapClickListener h(BaiduMap baiduMap) {
        return baiduMap.p;
    }

    static /* synthetic */ OnMapDoubleClickListener i(BaiduMap baiduMap) {
        return baiduMap.r;
    }

    static /* synthetic */ OnMapLongClickListener j(BaiduMap baiduMap) {
        return baiduMap.s;
    }

    static /* synthetic */ Projection a(BaiduMap baiduMap, Projection projection) {
        baiduMap.e = projection;
        return baiduMap.e;
    }

    static /* synthetic */ boolean a(BaiduMap baiduMap, boolean bl) {
        baiduMap.K = bl;
        return baiduMap.K;
    }

    static /* synthetic */ OnMapLoadedCallback k(BaiduMap baiduMap) {
        return baiduMap.q;
    }

    static /* synthetic */ SnapshotReadyCallback l(BaiduMap baiduMap) {
        return baiduMap.x;
    }

    static /* synthetic */ OnMyLocationClickListener m(BaiduMap baiduMap) {
        return baiduMap.w;
    }

    static /* synthetic */ InfoWindow n(BaiduMap baiduMap) {
        return baiduMap.D;
    }

    static /* synthetic */ Marker o(BaiduMap baiduMap) {
        return baiduMap.E;
    }

    static /* synthetic */ CopyOnWriteArrayList p(BaiduMap baiduMap) {
        return baiduMap.t;
    }

    static /* synthetic */ CopyOnWriteArrayList q(BaiduMap baiduMap) {
        return baiduMap.u;
    }

    static /* synthetic */ Marker r(BaiduMap baiduMap) {
        return baiduMap.G;
    }

    static /* synthetic */ Projection s(BaiduMap baiduMap) {
        return baiduMap.e;
    }

    static /* synthetic */ OnMarkerDragListener t(BaiduMap baiduMap) {
        return baiduMap.v;
    }

    static /* synthetic */ Marker a(BaiduMap baiduMap, Marker marker) {
        baiduMap.G = marker;
        return baiduMap.G;
    }

    static /* synthetic */ Lock u(BaiduMap baiduMap) {
        return baiduMap.B;
    }

    static /* synthetic */ HeatMap v(BaiduMap baiduMap) {
        return baiduMap.A;
    }

    static /* synthetic */ OnMapDrawFrameCallback w(BaiduMap baiduMap) {
        return baiduMap.y;
    }

    static /* synthetic */ Lock x(BaiduMap baiduMap) {
        return baiduMap.C;
    }

    static /* synthetic */ TileOverlay y(BaiduMap baiduMap) {
        return baiduMap.z;
    }

    public static interface OnMapDrawFrameCallback {
        public void onMapDrawFrame(GL10 var1, MapStatus var2);
    }

    public static interface SnapshotReadyCallback {
        public void onSnapshotReady(Bitmap var1);
    }

    public static interface OnMyLocationClickListener {
        public boolean onMyLocationClick();
    }

    public static interface OnMarkerDragListener {
        public void onMarkerDrag(Marker var1);

        public void onMarkerDragEnd(Marker var1);

        public void onMarkerDragStart(Marker var1);
    }

    public static interface OnPolylineClickListener {
        public boolean onPolylineClick(Polyline var1);
    }

    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(Marker var1);
    }

    public static interface OnMapLongClickListener {
        public void onMapLongClick(LatLng var1);
    }

    public static interface OnMapDoubleClickListener {
        public void onMapDoubleClick(LatLng var1);
    }

    public static interface OnMapLoadedCallback {
        public void onMapLoaded();
    }

    public static interface OnMapClickListener {
        public void onMapClick(LatLng var1);

        public boolean onMapPoiClick(MapPoi var1);
    }

    public static interface OnMapTouchListener {
        public void onTouch(MotionEvent var1);
    }

    public static interface OnMapStatusChangeListener {
        public void onMapStatusChangeStart(MapStatus var1);

        public void onMapStatusChange(MapStatus var1);

        public void onMapStatusChangeFinish(MapStatus var1);
    }
}

