/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.store.hbase;

import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.query.Condition;
import com.baidu.hugegraph.backend.query.ConditionQuery;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.backend.serializer.BinaryBackendEntry;
import com.baidu.hugegraph.backend.serializer.BinaryEntryIterator;
import com.baidu.hugegraph.backend.serializer.BinarySerializer;
import com.baidu.hugegraph.backend.store.BackendEntry;
import com.baidu.hugegraph.backend.store.BackendEntryIterator;
import com.baidu.hugegraph.backend.store.hbase.HbaseSessions;
import com.baidu.hugegraph.backend.store.hbase.HbaseTable;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.type.define.HugeKeys;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.NumericUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;

public class HbaseTables {

    public static class RangeIndex
    extends IndexTable {
        public static final String TABLE = "ri";

        public RangeIndex(String store) {
            super(RangeIndex.joinTableName((String)store, (String)TABLE));
        }

        @Override
        protected HbaseSessions.RowIterator queryByCond(HbaseSessions.Session session, ConditionQuery query) {
            assert (!query.conditions().isEmpty());
            List conds = query.syspropConditions(HugeKeys.ID);
            E.checkArgument((!conds.isEmpty() ? 1 : 0) != 0, (String)"Please specify the index conditions", (Object[])new Object[0]);
            Id prefix = null;
            Id min = null;
            boolean minEq = false;
            Id max = null;
            boolean maxEq = false;
            block7: for (Condition c : conds) {
                Condition.Relation r = (Condition.Relation)c;
                switch (r.relation()) {
                    case PREFIX: {
                        prefix = (Id)r.value();
                        continue block7;
                    }
                    case GTE: {
                        minEq = true;
                    }
                    case GT: {
                        min = (Id)r.value();
                        continue block7;
                    }
                    case LTE: {
                        maxEq = true;
                    }
                    case LT: {
                        max = (Id)r.value();
                        continue block7;
                    }
                }
                E.checkArgument((boolean)false, (String)"Unsupported relation '%s'", (Object[])new Object[]{r.relation()});
            }
            E.checkArgumentNotNull(min, (String)"Range index begin key is missing", (Object[])new Object[0]);
            byte[] begin = min.asBytes();
            if (max == null) {
                E.checkArgumentNotNull(prefix, (String)"Range index prefix is missing", (Object[])new Object[0]);
                byte[] prefixFilter = prefix.asBytes();
                return session.scan(this.table(), begin, minEq, prefixFilter);
            }
            byte[] end = max.asBytes();
            if (maxEq) {
                maxEq = false;
                end = Arrays.copyOfRange(end, 0, end.length + 1);
            }
            return session.scan(this.table(), begin, minEq, end, maxEq);
        }
    }

    public static class SearchIndex
    extends IndexTable {
        public static final String TABLE = "fi";

        public SearchIndex(String store) {
            super(SearchIndex.joinTableName((String)store, (String)TABLE));
        }
    }

    public static class SecondaryIndex
    extends IndexTable {
        public static final String TABLE = "si";

        public SecondaryIndex(String store) {
            super(SecondaryIndex.joinTableName((String)store, (String)TABLE));
        }
    }

    public static class IndexTable
    extends HbaseTable {
        private static final int INDEX_DELETE_BATCH = 1000;

        public IndexTable(String table) {
            super(table);
        }

        @Override
        public void insert(HbaseSessions.Session session, BackendEntry entry) {
            assert (entry.columns().size() == 1);
            BackendEntry.BackendColumn col = (BackendEntry.BackendColumn)entry.columns().iterator().next();
            session.put(this.table(), CF, col.name, BinarySerializer.EMPTY_BYTES, col.value);
        }

        @Override
        public void eliminate(HbaseSessions.Session session, BackendEntry entry) {
            assert (entry.columns().size() == 1);
            BackendEntry.BackendColumn col = (BackendEntry.BackendColumn)entry.columns().iterator().next();
            session.delete(this.table(), CF, col.name);
        }

        @Override
        public void delete(HbaseSessions.Session session, BackendEntry entry) {
            int count = 0;
            for (BackendEntry.BackendColumn column : entry.columns()) {
                session.commit();
                HbaseSessions.RowIterator iter = session.scan(this.table(), column.name);
                while (iter.hasNext()) {
                    session.delete(this.table(), CF, iter.next().getRow());
                    if (++count < 1000) continue;
                    session.commit();
                    count = 0;
                }
            }
            if (count > 0) {
                session.commit();
            }
        }

        @Override
        protected BackendEntryIterator newEntryIterator(HbaseSessions.RowIterator rows, Query query) {
            return new BinaryEntryIterator((BackendEntry.BackendIterator)rows, query, (entry, row) -> {
                assert (row.size() == 1);
                BackendEntry.BackendColumn col = BackendEntry.BackendColumn.of((byte[])row.getRow(), (byte[])row.value());
                entry = new BinaryBackendEntry(query.resultType(), col.name);
                entry.columns(new BackendEntry.BackendColumn[]{col});
                return entry;
            });
        }
    }

    public static class Edge
    extends HbaseTable {
        public static final String TABLE_SUFFIX = "e";

        public Edge(String store, boolean out) {
            super(Edge.joinTableName((String)store, (String)Edge.table(out)));
        }

        private static String table(boolean out) {
            return (out ? (char)'o' : 'i') + TABLE_SUFFIX;
        }

        public static Edge out(String store) {
            return new Edge(store, true);
        }

        public static Edge in(String store) {
            return new Edge(store, false);
        }

        @Override
        public void insert(HbaseSessions.Session session, BackendEntry entry) {
            for (BackendEntry.BackendColumn col : entry.columns()) {
                E.checkArgument((col.name.length == 0 ? 1 : 0) != 0, (String)"Expect empty column name, please ensure hbase serializer is used", (Object[])new Object[0]);
            }
            super.insert(session, entry);
        }

        @Override
        protected void parseRowColumns(Result row, BackendEntry entry, Query query) throws IOException {
            byte[] key = row.getRow();
            key = Arrays.copyOfRange(key, entry.id().length(), key.length);
            long total = query.total();
            CellScanner cellScanner = row.cellScanner();
            while (cellScanner.advance() && total-- > 0L) {
                Cell cell = cellScanner.current();
                assert (CellUtil.cloneQualifier((Cell)cell).length == 0);
                entry.columns(new BackendEntry.BackendColumn[]{BackendEntry.BackendColumn.of((byte[])key, (byte[])CellUtil.cloneValue((Cell)cell))});
            }
        }
    }

    public static class Vertex
    extends HbaseTable {
        public static final String TABLE = "v";

        public Vertex(String store) {
            super(Vertex.joinTableName((String)store, (String)TABLE));
        }
    }

    public static class IndexLabel
    extends HbaseTable {
        public static final String TABLE = "il";

        public IndexLabel() {
            super(TABLE);
        }
    }

    public static class PropertyKey
    extends HbaseTable {
        public static final String TABLE = "pk";

        public PropertyKey() {
            super(TABLE);
        }
    }

    public static class EdgeLabel
    extends HbaseTable {
        public static final String TABLE = "el";

        public EdgeLabel() {
            super(TABLE);
        }
    }

    public static class VertexLabel
    extends HbaseTable {
        public static final String TABLE = "vl";

        public VertexLabel() {
            super(TABLE);
        }
    }

    public static class Counters
    extends HbaseTable {
        private static final String TABLE = "c";
        private static final byte[] COL = Bytes.toBytes((String)"c");

        public Counters() {
            super(TABLE);
        }

        public long getCounter(HbaseSessions.Session session, HugeType type) {
            byte[] key = new byte[]{type.code()};
            HbaseSessions.RowIterator results = session.get(this.table(), CF, key);
            if (results.hasNext()) {
                Result row = results.next();
                return NumericUtil.bytesToLong((byte[])row.getValue(CF, COL));
            }
            return 0L;
        }

        public void increaseCounter(HbaseSessions.Session session, HugeType type, long increment) {
            byte[] key = new byte[]{type.code()};
            session.increase(this.table(), CF, key, COL, increment);
        }
    }
}

