/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.store.hbase;

import com.baidu.hugegraph.backend.BackendException;
import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.query.Condition;
import com.baidu.hugegraph.backend.query.ConditionQuery;
import com.baidu.hugegraph.backend.query.Query;
import com.baidu.hugegraph.backend.serializer.BinaryBackendEntry;
import com.baidu.hugegraph.backend.serializer.BinaryEntryIterator;
import com.baidu.hugegraph.backend.store.BackendEntry;
import com.baidu.hugegraph.backend.store.BackendEntryIterator;
import com.baidu.hugegraph.backend.store.BackendTable;
import com.baidu.hugegraph.backend.store.Shard;
import com.baidu.hugegraph.backend.store.hbase.HbaseSessions;
import com.baidu.hugegraph.backend.store.hbase.HbaseStore;
import com.baidu.hugegraph.exception.NotSupportException;
import com.baidu.hugegraph.iterator.ExtendableIterator;
import com.baidu.hugegraph.type.HugeType;
import com.baidu.hugegraph.util.Bytes;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.Log;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Result;
import org.slf4j.Logger;

public class HbaseTable
extends BackendTable<HbaseSessions.Session, BackendEntry> {
    private static final Logger LOG = Log.logger(HbaseStore.class);
    protected static final byte[] CF = "f".getBytes();
    private final HbaseShardSpliter shardSpliter = new HbaseShardSpliter(this.table());

    public HbaseTable(String table) {
        super(table);
    }

    public static List<byte[]> cfs() {
        return ImmutableList.of((Object)CF);
    }

    protected void registerMetaHandlers() {
        this.registerMetaHandler("splits", (session, meta, args) -> {
            E.checkArgument((args.length == 1 ? 1 : 0) != 0, (String)"The args count of %s must be 1", (Object[])new Object[]{meta});
            long splitSize = (Long)args[0];
            return this.shardSpliter.getSplits(session, splitSize);
        });
    }

    public void init(HbaseSessions.Session session) {
    }

    public void clear(HbaseSessions.Session session) {
    }

    public void insert(HbaseSessions.Session session, BackendEntry entry) {
        assert (!entry.columns().isEmpty());
        session.put(this.table(), CF, entry.id().asBytes(), entry.columns());
    }

    public void delete(HbaseSessions.Session session, BackendEntry entry) {
        if (entry.columns().isEmpty()) {
            session.delete(this.table(), CF, entry.id().asBytes());
        } else {
            for (BackendEntry.BackendColumn col : entry.columns()) {
                session.remove(this.table(), CF, entry.id().asBytes(), col.name);
            }
        }
    }

    public void append(HbaseSessions.Session session, BackendEntry entry) {
        assert (entry.columns().size() == 1);
        this.insert(session, entry);
    }

    public void eliminate(HbaseSessions.Session session, BackendEntry entry) {
        assert (entry.columns().size() == 1);
        this.delete(session, entry);
    }

    public Iterator<BackendEntry> query(HbaseSessions.Session session, Query query) {
        if (query.limit() == 0L && query.limit() != Long.MAX_VALUE) {
            LOG.debug("Return empty result(limit=0) for query {}", (Object)query);
            return ImmutableList.of().iterator();
        }
        if (query.empty()) {
            return this.newEntryIterator(this.queryAll(session, query), query);
        }
        if (query.conditions().isEmpty()) {
            assert (!query.ids().isEmpty());
            ExtendableIterator rs = new ExtendableIterator();
            for (Id id : query.ids()) {
                rs.extend((Iterator)this.newEntryIterator(this.queryById(session, id), query));
            }
            return rs;
        }
        ConditionQuery cq = (ConditionQuery)query;
        return this.newEntryIterator(this.queryByCond(session, cq), query);
    }

    protected HbaseSessions.RowIterator queryAll(HbaseSessions.Session session, Query query) {
        if (query.paging()) {
            BinaryEntryIterator.PageState page = BinaryEntryIterator.PageState.fromString((String)query.page());
            byte[] begin = page.position();
            return session.scan(this.table(), begin, null);
        }
        return session.scan(this.table(), -1L);
    }

    protected HbaseSessions.RowIterator queryById(HbaseSessions.Session session, Id id) {
        return session.get(this.table(), null, id.asBytes());
    }

    protected HbaseSessions.RowIterator queryByCond(HbaseSessions.Session session, ConditionQuery query) {
        if (query.containsScanCondition()) {
            E.checkArgument((query.relations().size() == 1 ? 1 : 0) != 0, (String)"Invalid scan with multi conditions: %s", (Object[])new Object[]{query});
            Condition.Relation scan = (Condition.Relation)query.relations().iterator().next();
            Shard shard = (Shard)scan.value();
            return this.queryByRange(session, shard);
        }
        throw new NotSupportException("query: %s", new Object[]{query});
    }

    protected HbaseSessions.RowIterator queryByRange(HbaseSessions.Session session, Id begin, Id end) {
        return session.scan(this.table(), begin.asBytes(), end.asBytes());
    }

    protected HbaseSessions.RowIterator queryByRange(HbaseSessions.Session session, Shard shard) {
        byte[] start = this.shardSpliter.position(shard.start());
        byte[] end = this.shardSpliter.position(shard.end());
        return session.scan(this.table(), start, end);
    }

    private BackendEntryIterator newEntryIterator(HbaseSessions.RowIterator rows, Query query) {
        return new BinaryEntryIterator((BackendEntry.BackendIterator)rows, query, (entry, row) -> {
            E.checkState((!row.isEmpty() ? 1 : 0) != 0, (String)"Can't parse empty HBase result", (Object[])new Object[0]);
            byte[] id = row.getRow();
            if (entry == null || !Bytes.prefixWith((byte[])id, (byte[])entry.id().asBytes())) {
                HugeType type = query.resultType();
                entry = new BinaryBackendEntry(type, id);
            }
            try {
                this.parseRowColumns((Result)row, (BackendEntry)entry);
            }
            catch (IOException e) {
                throw new BackendException("Failed to read HBase columns", (Throwable)e);
            }
            return entry;
        });
    }

    protected void parseRowColumns(Result row, BackendEntry entry) throws IOException {
        CellScanner cellScanner = row.cellScanner();
        while (cellScanner.advance()) {
            Cell cell = cellScanner.current();
            entry.columns(new BackendEntry.BackendColumn[]{BackendEntry.BackendColumn.of((byte[])CellUtil.cloneQualifier((Cell)cell), (byte[])CellUtil.cloneValue((Cell)cell))});
        }
    }

    private static class HbaseShardSpliter
    extends BackendTable.ShardSpliter<HbaseSessions.Session> {
        public HbaseShardSpliter(String table) {
            super(table);
        }

        public long estimateDataSize(HbaseSessions.Session session) {
            try {
                return session.storeSize(this.table());
            }
            catch (IOException ignored) {
                return -1L;
            }
        }

        public long estimateNumKeys(HbaseSessions.Session session) {
            return 100000L;
        }
    }
}

