/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.store.hbase;

import com.baidu.hugegraph.backend.id.Id;
import com.baidu.hugegraph.backend.serializer.BinaryBackendEntry;
import com.baidu.hugegraph.backend.serializer.BinarySerializer;
import com.baidu.hugegraph.backend.serializer.BytesBuffer;
import com.baidu.hugegraph.backend.store.BackendEntry;
import com.baidu.hugegraph.structure.HugeIndex;

public class HbaseSerializer
extends BinarySerializer {
    public HbaseSerializer() {
        super(false);
    }

    protected byte[] formatIndexName(HugeIndex index) {
        Id elemId = index.elementId();
        BytesBuffer buffer = BytesBuffer.allocate((int)(1 + elemId.length()));
        buffer.writeId(elemId, true);
        return buffer.bytes();
    }

    protected void parseIndexName(BinaryBackendEntry entry, HugeIndex index, Object fieldValues) {
        for (BackendEntry.BackendColumn col : entry.columns()) {
            if (HbaseSerializer.indexFieldValuesUnmatched((byte[])col.value, (Object)fieldValues)) continue;
            BytesBuffer buffer = BytesBuffer.wrap((byte[])col.name);
            index.elementIds(new Id[]{buffer.readId(true)});
        }
    }
}

