/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.backend.store.hbase;

import com.baidu.hugegraph.backend.store.BackendMetrics;
import com.baidu.hugegraph.backend.store.hbase.HbaseSessions;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.InsertionOrderUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;

public class HbaseMetrics
implements BackendMetrics {
    private final Connection hbase;

    public HbaseMetrics(HbaseSessions hbase) {
        E.checkArgumentNotNull((Object)((Object)hbase), (String)"HBase connection is not opened", (Object[])new Object[0]);
        this.hbase = hbase.hbase();
    }

    public Map<String, Object> getMetrics() {
        Map results = InsertionOrderUtil.newMap();
        try (Admin admin = this.hbase.getAdmin();){
            ClusterMetrics clusterMetrics = admin.getClusterMetrics();
            results.put("cluster_id", clusterMetrics.getClusterId());
            results.put("average_load", clusterMetrics.getAverageLoad());
            results.put("hbase_version", clusterMetrics.getHBaseVersion());
            results.put("region_count", clusterMetrics.getRegionCount());
            Collection servers = admin.getRegionServers();
            results.put("nodes", servers.size());
            Map metrics = clusterMetrics.getLiveServerMetrics();
            Map regionServers = InsertionOrderUtil.newMap();
            for (Map.Entry e : metrics.entrySet()) {
                ServerName server = (ServerName)e.getKey();
                ServerMetrics serverMetrics = (ServerMetrics)e.getValue();
                List regions = admin.getRegionMetrics(server);
                regionServers.put(server.getAddress().toString(), HbaseMetrics.formatMetrics(serverMetrics, regions));
            }
            results.put("region_servers", regionServers);
        }
        catch (Throwable e) {
            results.put("exception", e.getMessage());
        }
        return results;
    }

    private static Map<String, Object> formatMetrics(ServerMetrics serverMetrics, List<RegionMetrics> regions) {
        Map metrics = InsertionOrderUtil.newMap();
        metrics.put("max_heap_size", serverMetrics.getMaxHeapSize().get(Size.Unit.MEGABYTE));
        metrics.put("used_heap_size", serverMetrics.getUsedHeapSize().get(Size.Unit.MEGABYTE));
        metrics.put("heap_size_unit", "MB");
        metrics.put("request_count", serverMetrics.getRequestCount());
        metrics.put("request_count_per_second", serverMetrics.getRequestCountPerSecond());
        metrics.put("regions", HbaseMetrics.formatMetrics(regions));
        return metrics;
    }

    private static Map<String, Object> formatMetrics(List<RegionMetrics> regions) {
        Map metrics = InsertionOrderUtil.newMap();
        for (RegionMetrics region : regions) {
            metrics.put(region.getNameAsString(), HbaseMetrics.formatMetrics(region));
        }
        return metrics;
    }

    private static Map<String, Object> formatMetrics(RegionMetrics region) {
        Map metrics = InsertionOrderUtil.newMap();
        metrics.put("mem_store_size", region.getMemStoreSize().get(Size.Unit.MEGABYTE));
        metrics.put("file_store_size", region.getStoreFileSize().get(Size.Unit.MEGABYTE));
        metrics.put("store_size_unit", "MB");
        return metrics;
    }
}

