/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.spring;

import com.baidu.brpc.interceptor.Interceptor;
import com.baidu.brpc.protocol.NamingOptions;
import com.baidu.brpc.server.RpcServer;
import com.baidu.brpc.server.RpcServerOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class RpcServiceExporter
extends RpcServerOptions
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(RpcServiceExporter.class);
    private RpcServer prRpcServer;
    private int servicePort;
    private List<Object> registerServices = new ArrayList<Object>();
    private Map<RpcServerOptions, Object> customOptionsServiceMap = new HashMap<RpcServerOptions, Object>();
    private Map<Object, NamingOptions> serviceNamingOptions = new HashMap<Object, NamingOptions>();
    private List<Interceptor> interceptors = new ArrayList<Interceptor>();
    private AtomicBoolean started = new AtomicBoolean(false);

    public void destroy() throws Exception {
        if (this.prRpcServer != null) {
            this.prRpcServer.shutdown();
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            NamingOptions namingOptions;
            Assert.isTrue((this.servicePort > 0 ? 1 : 0) != 0, (String)("invalid service port: " + this.servicePort));
            if (this.registerServices.size() == 0 && this.customOptionsServiceMap.size() == 0) {
                throw new IllegalArgumentException("No register service specified.");
            }
            this.prRpcServer = new RpcServer(this.servicePort, (RpcServerOptions)this, this.interceptors);
            for (Object object : this.registerServices) {
                namingOptions = this.serviceNamingOptions.get(object);
                this.prRpcServer.registerService(object, AopUtils.getTargetClass((Object)object), namingOptions, null);
            }
            for (Map.Entry entry : this.customOptionsServiceMap.entrySet()) {
                namingOptions = this.serviceNamingOptions.get(entry.getValue());
                this.prRpcServer.registerService(entry.getValue(), AopUtils.getTargetClass(entry.getValue()), namingOptions, (RpcServerOptions)entry.getKey());
            }
            this.prRpcServer.start();
        } else {
            log.warn("service port [" + this.servicePort + "] ignored due to server already started.");
        }
    }

    public void setPrRpcServer(RpcServer prRpcServer) {
        this.prRpcServer = prRpcServer;
    }

    public void setServicePort(int servicePort) {
        this.servicePort = servicePort;
    }

    public void setRegisterServices(List<Object> registerServices) {
        this.registerServices = registerServices;
    }

    public void setCustomOptionsServiceMap(Map<RpcServerOptions, Object> customOptionsServiceMap) {
        this.customOptionsServiceMap = customOptionsServiceMap;
    }

    public void setServiceNamingOptions(Map<Object, NamingOptions> serviceNamingOptions) {
        this.serviceNamingOptions = serviceNamingOptions;
    }

    public void setInterceptors(List<Interceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public void setStarted(AtomicBoolean started) {
        this.started = started;
    }

    public RpcServer getPrRpcServer() {
        return this.prRpcServer;
    }

    public int getServicePort() {
        return this.servicePort;
    }

    public List<Object> getRegisterServices() {
        return this.registerServices;
    }

    public Map<RpcServerOptions, Object> getCustomOptionsServiceMap() {
        return this.customOptionsServiceMap;
    }

    public Map<Object, NamingOptions> getServiceNamingOptions() {
        return this.serviceNamingOptions;
    }

    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public AtomicBoolean getStarted() {
        return this.started;
    }
}

