/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.spring;

import com.baidu.brpc.client.BrpcProxy;
import com.baidu.brpc.client.RpcClient;
import com.baidu.brpc.client.RpcClientOptions;
import com.baidu.brpc.interceptor.Interceptor;
import com.baidu.brpc.protocol.NamingOptions;
import java.util.List;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class RpcProxyFactoryBean
extends RpcClientOptions
implements FactoryBean,
InitializingBean,
DisposableBean {
    private Class serviceInterface;
    private String namingServiceUrl;
    private String group = "normal";
    private String version = "1.0.0";
    private boolean ignoreFailOfNamingService = false;
    private String serviceId;
    private List<Interceptor> interceptors;
    private Object serviceProxy;
    private RpcClient rpcClient;

    public void setServiceInterface(Class serviceInterface) {
        if (serviceInterface != null && !serviceInterface.isInterface()) {
            throw new IllegalArgumentException("'serviceInterface' must be an interface");
        }
        this.serviceInterface = serviceInterface;
    }

    public Class getServiceInterface() {
        return this.serviceInterface;
    }

    public Object getObject() throws Exception {
        return this.serviceProxy;
    }

    public Class getObjectType() {
        return this.serviceInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.rpcClient == null) {
            this.rpcClient = new RpcClient(this.namingServiceUrl, (RpcClientOptions)this, this.interceptors);
        }
        NamingOptions namingOptions = new NamingOptions();
        namingOptions.setGroup(this.group);
        namingOptions.setVersion(this.version);
        namingOptions.setIgnoreFailOfNamingService(this.ignoreFailOfNamingService);
        namingOptions.setServiceId(this.serviceId);
        this.serviceProxy = BrpcProxy.getProxy((RpcClient)this.rpcClient, (Class)this.serviceInterface, (NamingOptions)namingOptions);
    }

    public void destroy() throws Exception {
        if (this.rpcClient != null) {
            this.rpcClient.stop();
        }
    }

    public void setNamingServiceUrl(String namingServiceUrl) {
        this.namingServiceUrl = namingServiceUrl;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setIgnoreFailOfNamingService(boolean ignoreFailOfNamingService) {
        this.ignoreFailOfNamingService = ignoreFailOfNamingService;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public void setInterceptors(List<Interceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public void setServiceProxy(Object serviceProxy) {
        this.serviceProxy = serviceProxy;
    }

    public void setRpcClient(RpcClient rpcClient) {
        this.rpcClient = rpcClient;
    }

    public String getNamingServiceUrl() {
        return this.namingServiceUrl;
    }

    public String getGroup() {
        return this.group;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isIgnoreFailOfNamingService() {
        return this.ignoreFailOfNamingService;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public Object getServiceProxy() {
        return this.serviceProxy;
    }

    public RpcClient getRpcClient() {
        return this.rpcClient;
    }
}

