/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.ratelimit;

import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.ratelimit.RateLimiter;
import com.baidu.brpc.utils.CustomThreadFactory;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenBucketRateLimiter
implements RateLimiter {
    private static final Logger log = LoggerFactory.getLogger(TokenBucketRateLimiter.class);
    private final int bucketSize;
    private final int timeIntervalMs = 200;
    private int tokenPerInterval;
    private AtomicInteger currentToken;
    private Timer timer = new HashedWheelTimer((ThreadFactory)new CustomThreadFactory("tokenBucketLimiter-timer-thread"));

    public TokenBucketRateLimiter(int bucketSize, int tokenInputRate) {
        if (bucketSize <= 0 || tokenInputRate <= 0) {
            throw new IllegalArgumentException("bucketSize and rate must be positive!");
        }
        this.bucketSize = bucketSize;
        this.tokenPerInterval = tokenInputRate / 5;
        if (this.tokenPerInterval == 0) {
            this.tokenPerInterval = 1;
        }
        this.currentToken = new AtomicInteger(bucketSize);
        this.timer.newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                TokenBucketRateLimiter.this.supply();
                TokenBucketRateLimiter.this.timer.newTimeout((TimerTask)this, 200L, TimeUnit.MILLISECONDS);
            }
        }, 200L, TimeUnit.MILLISECONDS);
    }

    private boolean acquire() {
        int curToken;
        do {
            if ((curToken = this.currentToken.get()) > 0) continue;
            return false;
        } while (!this.currentToken.compareAndSet(curToken, curToken - 1));
        return true;
    }

    private void supply() {
        if (this.currentToken.getAndAdd(this.tokenPerInterval) > this.bucketSize) {
            this.currentToken.set(this.bucketSize);
        }
    }

    @Override
    public boolean isAllowable(Request request) {
        return this.acquire();
    }
}

