/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.naming;

import com.baidu.brpc.client.CommunicationClient;
import com.baidu.brpc.client.CommunicationOptions;
import com.baidu.brpc.client.InterceptCommunicationClient;
import com.baidu.brpc.client.channel.BootstrapManager;
import com.baidu.brpc.client.channel.Endpoint;
import com.baidu.brpc.client.channel.ServiceInstance;
import com.baidu.brpc.naming.BrpcURL;
import com.baidu.brpc.naming.HealthyCheckTimer;
import com.baidu.brpc.naming.ListNamingService;
import com.baidu.brpc.naming.NamingService;
import com.baidu.brpc.naming.NamingServiceFactory;
import com.baidu.brpc.naming.NamingServiceFactoryManager;
import com.baidu.brpc.naming.NotifyListener;
import com.baidu.brpc.protocol.NamingOptions;
import com.baidu.brpc.protocol.SubscribeInfo;
import com.baidu.brpc.thread.BrpcThreadPoolManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamingServiceProcessor {
    private static final Logger log = LoggerFactory.getLogger(NamingServiceProcessor.class);
    private NamingService namingService;
    private Class serviceInterface;
    private SubscribeInfo subscribeInfo;
    private CopyOnWriteArrayList<ServiceInstance> allInstances = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<CommunicationClient> healthyInstances = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<CommunicationClient> unhealthyInstances = new CopyOnWriteArrayList();
    private Lock lock = new ReentrantLock();
    private HealthyCheckTimer healthyCheckTimer;
    private CommunicationOptions communicationOptions;

    public NamingServiceProcessor(String serviceUrl, Class serviceInterface, NamingOptions namingOptions, int healthyCheckIntervalMillis, CommunicationOptions communicationOptions) {
        this.communicationOptions = communicationOptions;
        this.serviceInterface = serviceInterface;
        BrpcURL url = new BrpcURL(serviceUrl);
        NamingServiceFactory namingServiceFactory = NamingServiceFactoryManager.getInstance().getNamingServiceFactory(url.getSchema());
        this.namingService = namingServiceFactory.createNamingService(url);
        this.subscribeInfo = namingOptions != null ? new SubscribeInfo(namingOptions) : new SubscribeInfo();
        this.subscribeInfo.setInterfaceName(serviceInterface.getName());
        List<ServiceInstance> instances = this.namingService.lookup(this.subscribeInfo);
        this.addInstances(instances);
        if (!(this.namingService instanceof ListNamingService)) {
            this.namingService.subscribe(this.subscribeInfo, new NotifyListener(){

                @Override
                public void notify(Collection<ServiceInstance> addList, Collection<ServiceInstance> deleteList) {
                    log.info("receive {} added instances, {} deleted instances from naming service", (Object)addList.size(), (Object)deleteList.size());
                    NamingServiceProcessor.this.addInstances(addList);
                    NamingServiceProcessor.this.deleteInstances(deleteList);
                }
            });
        }
        this.startHealthyCheckTimer(healthyCheckIntervalMillis);
    }

    public NamingServiceProcessor(List<Endpoint> endpoints, Class serviceInterface, int healthyCheckIntervalMillis, CommunicationOptions communicationOptions) {
        this.serviceInterface = serviceInterface;
        this.communicationOptions = communicationOptions;
        this.subscribeInfo = new SubscribeInfo();
        this.subscribeInfo.setInterfaceName(serviceInterface.getName());
        for (Endpoint endpoint : endpoints) {
            ServiceInstance instance = new ServiceInstance(endpoint);
            instance.setServiceName(this.subscribeInfo.getServiceId());
            this.addInstance(instance);
        }
        if (this.allInstances.size() > 1) {
            this.startHealthyCheckTimer(healthyCheckIntervalMillis);
        }
    }

    private void startHealthyCheckTimer(int healthyCheckIntervalMillis) {
        this.healthyCheckTimer = new HealthyCheckTimer(this, healthyCheckIntervalMillis);
        this.healthyCheckTimer.start();
    }

    public void addInstances(Collection<ServiceInstance> instances) {
        for (ServiceInstance instance : instances) {
            this.addInstance(instance);
        }
    }

    public void addInstance(ServiceInstance instance) {
        this.lock.lock();
        try {
            if (!this.allInstances.contains(instance)) {
                this.allInstances.add(instance);
                InterceptCommunicationClient communicationClient = new InterceptCommunicationClient(instance, this.communicationOptions, this.communicationOptions.getInterceptors());
                this.healthyInstances.add((CommunicationClient)communicationClient);
            } else {
                log.debug("service instance already exist, {}:{}", (Object)instance.getIp(), (Object)instance.getPort());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void deleteInstances(Collection<ServiceInstance> instances) {
        ArrayList<CommunicationClient> removedClients = new ArrayList<CommunicationClient>();
        for (ServiceInstance instance : instances) {
            CommunicationClient communicationClient = this.deleteInstance(instance);
            if (communicationClient == null) continue;
            removedClients.add(communicationClient);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            log.warn("InterruptedException:", (Throwable)ex);
        }
        for (CommunicationClient communicationClient : removedClients) {
            communicationClient.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommunicationClient deleteInstance(ServiceInstance instance) {
        this.lock.lock();
        try {
            if (this.allInstances.remove(instance)) {
                CommunicationClient communicationClient = this.deleteInstance(this.healthyInstances, instance);
                if (communicationClient == null) {
                    communicationClient = this.deleteInstance(this.unhealthyInstances, instance);
                }
                if (communicationClient == null) {
                    log.warn("instance {} exist in allInstances, but not in healthyInstances and unhealthyInstances", (Object)instance);
                }
                CommunicationClient communicationClient2 = communicationClient;
                return communicationClient2;
            }
        }
        catch (Exception e) {
            log.error("delete instance {}, error msg {}", (Object)instance, (Object)e.getMessage());
        }
        finally {
            this.lock.unlock();
        }
        return null;
    }

    public List<CommunicationClient> getInstances() {
        ArrayList<CommunicationClient> instances = new ArrayList<CommunicationClient>();
        if (this.healthyInstances.size() > 0) {
            instances.addAll(this.healthyInstances);
        } else {
            instances.addAll(this.unhealthyInstances);
        }
        return instances;
    }

    public void stop() {
        if (this.healthyCheckTimer != null) {
            this.healthyCheckTimer.stop();
        }
        if (this.namingService != null && !(this.namingService instanceof ListNamingService)) {
            this.namingService.unsubscribe(this.subscribeInfo);
            this.namingService.destroy();
        }
        for (CommunicationClient client : this.healthyInstances) {
            client.stop();
        }
        for (CommunicationClient client : this.unhealthyInstances) {
            client.stop();
        }
        if (!this.communicationOptions.isGlobalThreadPoolSharing()) {
            BrpcThreadPoolManager threadPoolManager = BrpcThreadPoolManager.getInstance();
            threadPoolManager.stopServiceThreadPool(this.subscribeInfo.getServiceId());
        }
        BootstrapManager bootstrapManager = BootstrapManager.getInstance();
        bootstrapManager.removeBootstrap(this.subscribeInfo.getServiceId());
    }

    private CommunicationClient deleteInstance(CopyOnWriteArrayList<CommunicationClient> list, ServiceInstance item) {
        CommunicationClient instance = null;
        for (CommunicationClient toCheck : list) {
            if (!toCheck.getServiceInstance().equals((Object)item)) continue;
            instance = toCheck;
            list.remove(instance);
            break;
        }
        return instance;
    }

    public NamingService getNamingService() {
        return this.namingService;
    }

    public Class getServiceInterface() {
        return this.serviceInterface;
    }

    public SubscribeInfo getSubscribeInfo() {
        return this.subscribeInfo;
    }

    public CopyOnWriteArrayList<ServiceInstance> getAllInstances() {
        return this.allInstances;
    }

    public CopyOnWriteArrayList<CommunicationClient> getHealthyInstances() {
        return this.healthyInstances;
    }

    public CopyOnWriteArrayList<CommunicationClient> getUnhealthyInstances() {
        return this.unhealthyInstances;
    }

    public Lock getLock() {
        return this.lock;
    }

    public HealthyCheckTimer getHealthyCheckTimer() {
        return this.healthyCheckTimer;
    }

    public CommunicationOptions getCommunicationOptions() {
        return this.communicationOptions;
    }
}

