/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.naming;

import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.naming.BrpcURL;
import com.baidu.brpc.naming.NamingService;
import com.baidu.brpc.naming.NotifyListener;
import com.baidu.brpc.naming.RegisterInfo;
import com.baidu.brpc.protocol.SubscribeInfo;
import com.baidu.brpc.utils.CustomThreadFactory;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import io.netty.util.internal.ConcurrentSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FailbackNamingService
implements NamingService {
    private static final Logger log = LoggerFactory.getLogger(FailbackNamingService.class);
    protected ConcurrentSet<RegisterInfo> failedRegisters = new ConcurrentSet();
    protected ConcurrentSet<RegisterInfo> failedUnregisters = new ConcurrentSet();
    protected ConcurrentMap<SubscribeInfo, NotifyListener> failedSubscribes = new ConcurrentHashMap<SubscribeInfo, NotifyListener>();
    protected ConcurrentSet<SubscribeInfo> failedUnsubscribes = new ConcurrentSet();
    private Timer timer;
    private int retryInterval;
    private BrpcURL url;

    public FailbackNamingService(BrpcURL url) {
        this.url = url;
        this.retryInterval = url.getIntParameter("interval", 5000);
        String namingServiceClassName = this.getClass().getSimpleName();
        this.timer = new HashedWheelTimer((ThreadFactory)new CustomThreadFactory(namingServiceClassName + "-retry-timer-thread"));
        this.timer.newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                try {
                    for (RegisterInfo registerInfo : FailbackNamingService.this.failedRegisters) {
                        FailbackNamingService.this.register(registerInfo);
                    }
                    for (RegisterInfo registerInfo : FailbackNamingService.this.failedUnregisters) {
                        FailbackNamingService.this.unregister(registerInfo);
                    }
                    for (Map.Entry entry : FailbackNamingService.this.failedSubscribes.entrySet()) {
                        FailbackNamingService.this.subscribe((SubscribeInfo)entry.getKey(), (NotifyListener)entry.getValue());
                    }
                    for (SubscribeInfo subscribeInfo : FailbackNamingService.this.failedUnsubscribes) {
                        FailbackNamingService.this.unsubscribe(subscribeInfo);
                    }
                }
                catch (Exception ex) {
                    log.warn("retry timer exception:", (Throwable)ex);
                }
                FailbackNamingService.this.timer.newTimeout((TimerTask)this, (long)FailbackNamingService.this.retryInterval, TimeUnit.MILLISECONDS);
            }
        }, (long)this.retryInterval, TimeUnit.MILLISECONDS);
    }

    @Override
    public void subscribe(SubscribeInfo subscribeInfo, NotifyListener listener) {
        try {
            this.doSubscribe(subscribeInfo, listener);
            this.failedSubscribes.remove(subscribeInfo);
        }
        catch (Exception ex) {
            if (!subscribeInfo.isIgnoreFailOfNamingService()) {
                throw new RpcException("subscribe failed from " + this.url, (Throwable)ex);
            }
            this.failedSubscribes.putIfAbsent(subscribeInfo, listener);
        }
    }

    @Override
    public void unsubscribe(SubscribeInfo subscribeInfo) {
        try {
            this.doUnsubscribe(subscribeInfo);
            this.failedUnsubscribes.remove((Object)subscribeInfo);
        }
        catch (Exception ex) {
            if (!subscribeInfo.isIgnoreFailOfNamingService()) {
                throw new RpcException("unsubscribe failed from " + this.url, (Throwable)ex);
            }
            this.failedUnsubscribes.add((Object)subscribeInfo);
        }
    }

    @Override
    public void register(RegisterInfo registerInfo) {
        try {
            this.doRegister(registerInfo);
            this.failedRegisters.remove((Object)registerInfo);
        }
        catch (Exception ex) {
            if (!registerInfo.isIgnoreFailOfNamingService()) {
                throw new RpcException("Failed to register to " + this.url, (Throwable)ex);
            }
            this.failedRegisters.add((Object)registerInfo);
        }
    }

    @Override
    public void unregister(RegisterInfo registerInfo) {
        try {
            this.doUnregister(registerInfo);
            this.failedUnregisters.remove((Object)registerInfo);
        }
        catch (Exception ex) {
            if (!registerInfo.isIgnoreFailOfNamingService()) {
                throw new RpcException("Failed to unregister from " + this.url, (Throwable)ex);
            }
            this.failedUnregisters.add((Object)registerInfo);
        }
    }

    @Override
    public void destroy() {
        this.timer.stop();
    }

    public abstract void doSubscribe(SubscribeInfo var1, NotifyListener var2) throws Exception;

    public abstract void doUnsubscribe(SubscribeInfo var1) throws Exception;

    public abstract void doRegister(RegisterInfo var1) throws Exception;

    public abstract void doUnregister(RegisterInfo var1) throws Exception;

    public ConcurrentSet<RegisterInfo> getFailedRegisters() {
        return this.failedRegisters;
    }

    public ConcurrentSet<RegisterInfo> getFailedUnregisters() {
        return this.failedUnregisters;
    }

    public ConcurrentMap<SubscribeInfo, NotifyListener> getFailedSubscribes() {
        return this.failedSubscribes;
    }

    public ConcurrentSet<SubscribeInfo> getFailedUnsubscribes() {
        return this.failedUnsubscribes;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public BrpcURL getUrl() {
        return this.url;
    }
}

