/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.loadbalance;

import com.baidu.brpc.client.CommunicationClient;
import com.baidu.brpc.client.RpcClient;
import com.baidu.brpc.loadbalance.LoadBalanceStrategy;
import com.baidu.brpc.protocol.Request;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class WeightStrategy
implements LoadBalanceStrategy {
    private Random random = new Random(System.currentTimeMillis());

    @Override
    public void init(RpcClient rpcClient) {
    }

    @Override
    public CommunicationClient selectInstance(Request request, List<CommunicationClient> instances, Set<CommunicationClient> selectedInstances) {
        long instanceNum = instances.size();
        if (instanceNum == 0L) {
            return null;
        }
        long sum = 0L;
        for (CommunicationClient instance : instances) {
            sum += this.getWeight(instance.getBrpcChannel().getFailedNum());
        }
        long randWeight = this.random.nextLong() % sum;
        for (CommunicationClient instance : instances) {
            if ((randWeight -= this.getWeight(instance.getBrpcChannel().getFailedNum())) > 0L) continue;
            return instance;
        }
        return null;
    }

    @Override
    public void destroy() {
    }

    private long getWeight(long failedNum) {
        return 1000000000L / (failedNum + 1L);
    }
}

