/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.loadbalance;

import com.baidu.brpc.client.CommunicationClient;
import com.baidu.brpc.client.RpcClient;
import com.baidu.brpc.loadbalance.LoadBalanceStrategy;
import com.baidu.brpc.protocol.Request;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class RoundRobinStrategy
implements LoadBalanceStrategy {
    private AtomicLong counter = new AtomicLong(0L);

    @Override
    public void init(RpcClient rpcClient) {
    }

    @Override
    public CommunicationClient selectInstance(Request request, List<CommunicationClient> instances, Set<CommunicationClient> selectedInstances) {
        long instanceNum = instances.size();
        if (instanceNum == 0L) {
            return null;
        }
        int index = (int)(this.counter.getAndIncrement() % instanceNum);
        CommunicationClient serviceInstance = instances.get(index);
        return serviceInstance;
    }

    @Override
    public void destroy() {
    }
}

