/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.server;

import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.interceptor.DefaultInterceptorChain;
import com.baidu.brpc.interceptor.Interceptor;
import com.baidu.brpc.interceptor.ServerInvokeInterceptor;
import com.baidu.brpc.interceptor.ServerTraceInterceptor;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import com.baidu.brpc.server.CommunicationServer;
import com.baidu.brpc.server.RpcServerOptions;
import com.baidu.brpc.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterceptCommunicationServer
extends CommunicationServer {
    private static final Logger log = LoggerFactory.getLogger(InterceptCommunicationServer.class);
    private List<Interceptor> interceptors = new ArrayList<Interceptor>();

    public InterceptCommunicationServer(int port) {
        this(null, port, new RpcServerOptions(), null);
    }

    public InterceptCommunicationServer(String host, int port) {
        this(host, port, new RpcServerOptions(), null);
    }

    public InterceptCommunicationServer(int port, RpcServerOptions options) {
        this(null, port, options, null);
    }

    public InterceptCommunicationServer(String host, int port, RpcServerOptions options) {
        this(host, port, options, null);
    }

    public InterceptCommunicationServer(int port, RpcServerOptions options, List<Interceptor> interceptors) {
        this(null, port, options, interceptors);
    }

    public InterceptCommunicationServer(String host, int port, RpcServerOptions options, List<Interceptor> interceptors) {
        super(host, port, options);
        if (CollectionUtils.isNotEmpty(interceptors)) {
            this.interceptors.addAll(interceptors);
        }
        this.interceptors.add(new ServerTraceInterceptor());
        this.interceptors.add(new ServerInvokeInterceptor());
    }

    @Override
    public void execute(Request request, Response response) throws RpcException {
        DefaultInterceptorChain interceptorChain = new DefaultInterceptorChain(this.interceptors);
        interceptorChain.intercept(request, response);
    }
}

