/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.protocol.http;

import com.baidu.brpc.protocol.http.BrpcHttpObjectAggregator;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectDecoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.StringUtil;
import java.util.LinkedList;

public class BrpcHttpObjectDecoder
extends HttpObjectDecoder {
    private static final FastThreadLocal<BrpcHttpObjectDecoder> CURRENT_RPC_RESPONSE = new FastThreadLocal<BrpcHttpObjectDecoder>(){

        protected BrpcHttpObjectDecoder initialValue() {
            return new BrpcHttpObjectDecoder(true);
        }
    };
    private static final HttpResponseStatus UNKNOWN_STATUS = new HttpResponseStatus(999, "Unknown");
    private boolean isDecodingRequest;

    public static BrpcHttpObjectDecoder getDecoder(boolean isDecodingRequest) {
        BrpcHttpObjectDecoder decoder = (BrpcHttpObjectDecoder)((Object)CURRENT_RPC_RESPONSE.get());
        decoder.isDecodingRequest = isDecodingRequest;
        return decoder;
    }

    private BrpcHttpObjectDecoder(boolean isDecodingRequest) {
        this.isDecodingRequest = isDecodingRequest;
    }

    protected HttpMessage createMessage(String[] initialLine) throws Exception {
        return this.isDecodingRequest() ? new DefaultHttpRequest(HttpVersion.valueOf((String)initialLine[2]), HttpMethod.valueOf((String)initialLine[0]), initialLine[1], this.validateHeaders) : new DefaultHttpResponse(HttpVersion.valueOf((String)initialLine[0]), HttpResponseStatus.valueOf((int)Integer.parseInt(initialLine[1]), (String)initialLine[2]), this.validateHeaders);
    }

    protected HttpMessage createInvalidMessage() {
        return this.isDecodingRequest() ? new DefaultFullHttpRequest(HttpVersion.HTTP_1_0, HttpMethod.GET, "/bad-request", this.validateHeaders) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_0, UNKNOWN_STATUS, this.validateHeaders);
    }

    protected boolean isDecodingRequest() {
        return this.isDecodingRequest;
    }

    public Object decode(ChannelHandlerContext ctx, ByteBuf in) {
        BrpcHttpObjectAggregator httpObjectAggregator = new BrpcHttpObjectAggregator(0xA00000);
        this.reset();
        LinkedList httpParts = new LinkedList();
        LinkedList<Object> httpResult = new LinkedList<Object>();
        try {
            int i;
            int outSize;
            while (in.isReadable()) {
                outSize = httpParts.size();
                if (outSize > 0) {
                    for (i = 0; i < outSize; ++i) {
                        httpObjectAggregator.aggregate(ctx, httpParts.get(i), httpResult);
                        if (httpResult.size() <= 0) continue;
                        return httpResult.get(0);
                    }
                    httpParts.clear();
                    if (ctx.isRemoved()) break;
                    outSize = 0;
                }
                int oldInputLength = in.readableBytes();
                this.decode(ctx, in, httpParts);
                if (ctx.isRemoved()) break;
                if (outSize == httpParts.size()) {
                    if (oldInputLength != in.readableBytes()) continue;
                    break;
                }
                if (oldInputLength == in.readableBytes()) {
                    throw new DecoderException(StringUtil.simpleClassName(((Object)((Object)this)).getClass()) + ".decode() did not read anything but decoded a message.");
                }
                if (!this.isSingleDecode()) continue;
                break;
            }
            if ((outSize = httpParts.size()) > 0) {
                for (i = 0; i < outSize; ++i) {
                    httpObjectAggregator.aggregate(ctx, httpParts.get(i), httpResult);
                    if (httpResult.size() <= 0) continue;
                    return httpResult.get(0);
                }
            }
            httpObjectAggregator.abort();
            return null;
        }
        catch (DecoderException e) {
            throw e;
        }
        catch (Exception cause) {
            throw new DecoderException((Throwable)cause);
        }
    }
}

