/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.protocol.dubbo;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;

public class DubboHeader {
    private short magic = (short)-9541;
    private byte flag;
    private byte status;
    private long correlationId;
    private int bodyLength;

    public ByteBuf encode() {
        ByteBuf byteBuf = Unpooled.buffer((int)16);
        byteBuf.writeShort(-9541);
        byteBuf.writeByte((int)this.flag);
        byteBuf.writeByte((int)this.status);
        byteBuf.writeLong(this.correlationId);
        byteBuf.writeInt(this.bodyLength);
        return byteBuf;
    }

    public static DubboHeader decode(ByteBuf byteBuf) {
        DubboHeader header = new DubboHeader();
        header.setMagic(byteBuf.readShort());
        header.setFlag(byteBuf.readByte());
        header.setStatus(byteBuf.readByte());
        header.setCorrelationId(byteBuf.readLong());
        header.setBodyLength(byteBuf.readInt());
        return header;
    }

    public void setMagic(short magic) {
        this.magic = magic;
    }

    public void setFlag(byte flag) {
        this.flag = flag;
    }

    public void setStatus(byte status) {
        this.status = status;
    }

    public void setCorrelationId(long correlationId) {
        this.correlationId = correlationId;
    }

    public void setBodyLength(int bodyLength) {
        this.bodyLength = bodyLength;
    }

    public short getMagic() {
        return this.magic;
    }

    public byte getFlag() {
        return this.flag;
    }

    public byte getStatus() {
        return this.status;
    }

    public long getCorrelationId() {
        return this.correlationId;
    }

    public int getBodyLength() {
        return this.bodyLength;
    }
}

