/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.interceptor;

import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.interceptor.AbstractInterceptor;
import com.baidu.brpc.interceptor.InterceptorChain;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerInvokeInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ServerInvokeInterceptor.class);

    @Override
    public void aroundProcess(Request request, Response response, InterceptorChain chain) throws RpcException {
        try {
            response.setResult(request.getTargetMethod().invoke(request.getTarget(), request.getArgs()));
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getTargetException();
            if (targetException == null) {
                targetException = ex;
            }
            String errorMsg = String.format("invoke method failed, msg=%s", targetException.getMessage());
            log.warn(errorMsg, targetException);
            response.setException(targetException);
        }
        catch (Throwable ex) {
            String errorMsg = String.format("invoke method failed, msg=%s", ex.getMessage());
            log.warn(errorMsg, ex);
            response.setException(ex);
        }
    }
}

