/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.acu.pie.demo;

import com.baidu.acu.pie.client.AsrClient;
import com.baidu.acu.pie.client.AsrClientFactory;
import com.baidu.acu.pie.client.Consumer;
import com.baidu.acu.pie.model.AsrConfig;
import com.baidu.acu.pie.model.AsrProduct;
import com.baidu.acu.pie.model.RecognitionResult;
import com.baidu.acu.pie.model.RequestMetaData;
import com.baidu.acu.pie.model.StreamContext;
import com.baidu.acu.pie.util.JacksonUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;

public class JavaDemo {
    public static void main(String[] args) {
        JavaDemo javaDemo = new JavaDemo();
        javaDemo.asyncRecognition();
    }

    private AsrClient createAsrClient() {
        AsrConfig asrConfig = AsrConfig.builder().serverIp("127.0.0.1").serverPort(80).appName("simpleDemo").product(AsrProduct.CUSTOMER_SERVICE_FINANCE).userName("user").password("123").build();
        return AsrClientFactory.buildClient(asrConfig);
    }

    private RequestMetaData createRequestMeta() {
        RequestMetaData requestMetaData = new RequestMetaData();
        requestMetaData.setSendPackageRatio(1.0);
        requestMetaData.setSleepRatio(1.0);
        requestMetaData.setTimeoutMinutes(120);
        requestMetaData.setEnableFlushData(false);
        HashMap<String, String> extra_info = new HashMap<String, String>();
        extra_info.put("demo", "java");
        requestMetaData.setExtraInfo(JacksonUtil.objectToString(extra_info));
        return requestMetaData;
    }

    public void recognizeFileWithRequestMeta() {
        File audioFile = new File("testaudio/10s.wav");
        AsrClient asrClient = this.createAsrClient();
        DateTime startTime = DateTime.now();
        List<RecognitionResult> results = asrClient.syncRecognize(audioFile, this.createRequestMeta());
        DateTime endTime = DateTime.now();
        Duration duration = new Duration((ReadableInstant)startTime, (ReadableInstant)endTime);
        System.out.println("time cost millis : " + duration.getMillis());
        asrClient.shutdown();
        for (RecognitionResult result : results) {
            System.out.println(String.format("%-40s\t%-36s\t%-36s\t%-14s\t%-13s\t%s", "file_name", "trace_id", "serial_num", "start_time", "end_time", "result"));
            System.out.println(String.format("%-40s\t%-36s\t%-36s\t%-14s\t%-13s\t%s", audioFile.getName(), result.getTraceId(), result.getSerialNum(), result.getStartTime(), result.getEndTime(), result.getResult()));
        }
    }

    public void recognizeDirectory() {
        AsrClient asrClient = this.createAsrClient();
        RequestMetaData requestMetaData = this.createRequestMeta();
        String audioFileDir = "testaudio";
        File dir = new File(audioFileDir);
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith("wav");
            }
        });
        int count = 0;
        for (File file : files) {
            List<RecognitionResult> results = asrClient.syncRecognize(file, requestMetaData);
            ++count;
        }
        System.out.println("***********************  count: " + count);
        asrClient.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncRecognition() {
        String longAudioFilePath = "testaudio/1.wav";
        AsrClient asrClient = this.createAsrClient();
        RequestMetaData requestMetaData = this.createRequestMeta();
        StreamContext streamContext = asrClient.asyncRecognize(new Consumer<RecognitionResult>(){

            @Override
            public void accept(RecognitionResult it) {
                System.out.println(DateTime.now().toString() + "\t" + Thread.currentThread().getId() + " receive fragment: " + it);
            }
        }, requestMetaData);
        try (InputStream audioStream = Files.newInputStream(Paths.get(longAudioFilePath, new String[0]), new OpenOption[0]);){
            byte[] data = new byte[asrClient.getFragmentSize(requestMetaData)];
            System.out.println(new DateTime().toString() + "\t" + Thread.currentThread().getId() + " start to send");
            while (audioStream.read(data) != -1 && !streamContext.getFinishLatch().finished()) {
                streamContext.send(data);
                Thread.sleep(20L);
            }
            System.out.println(new DateTime().toString() + "\t" + Thread.currentThread().getId() + " send finish");
            streamContext.complete();
            streamContext.getFinishLatch().await();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            asrClient.shutdown();
        }
        System.out.println("all task finished");
    }
}

