/*
 * Decompiled with CFR 0.152.
 */
package com.badoo.reaktive.scheduler;

import com.badoo.reaktive.disposable.CompositeDisposable;
import com.badoo.reaktive.disposable.CompositeDisposableExtKt;
import com.badoo.reaktive.scheduler.Scheduler;
import com.badoo.reaktive.utils.UtilsKt;
import com.badoo.reaktive.utils.atomic.AtomicBoolean;
import com.badoo.reaktive.utils.atomic.AtomicLong;
import com.badoo.reaktive.utils.clock.Clock;
import com.badoo.reaktive.utils.clock.DefaultClock;
import com.badoo.reaktive.utils.serializer.PrioritySerializer;
import com.badoo.reaktive.utils.serializer.Serializer;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0010B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/badoo/reaktive/scheduler/TrampolineScheduler;", "Lcom/badoo/reaktive/scheduler/Scheduler;", "clock", "Lcom/badoo/reaktive/utils/clock/Clock;", "sleep", "Lkotlin/Function1;", "Lkotlin/time/Duration;", "", "<init>", "(Lcom/badoo/reaktive/utils/clock/Clock;Lkotlin/jvm/functions/Function1;)V", "disposables", "Lcom/badoo/reaktive/disposable/CompositeDisposable;", "newExecutor", "Lcom/badoo/reaktive/scheduler/Scheduler$Executor;", "destroy", "", "ExecutorImpl", "reaktive_release"})
public final class TrampolineScheduler
implements Scheduler {
    @NotNull
    private final Clock clock;
    @NotNull
    private final Function1<Duration, Boolean> sleep;
    @NotNull
    private final CompositeDisposable disposables;

    public TrampolineScheduler(@NotNull Clock clock, @NotNull Function1<? super Duration, Boolean> sleep) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter(sleep, (String)"sleep");
        this.clock = clock;
        this.sleep = sleep;
        this.disposables = new CompositeDisposable();
    }

    public /* synthetic */ TrampolineScheduler(Clock clock, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            clock = (Clock)DefaultClock.INSTANCE;
        }
        this(clock, (Function1<? super Duration, Boolean>)function1);
    }

    @Override
    @NotNull
    public Scheduler.Executor newExecutor() {
        return new ExecutorImpl(this.disposables, this.clock, this.sleep);
    }

    @Override
    public void destroy() {
        this.disposables.dispose();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J-\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u0019H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000eH\u0002J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/badoo/reaktive/scheduler/TrampolineScheduler$ExecutorImpl;", "Lcom/badoo/reaktive/scheduler/Scheduler$Executor;", "disposables", "Lcom/badoo/reaktive/disposable/CompositeDisposable;", "clock", "Lcom/badoo/reaktive/utils/clock/Clock;", "sleep", "Lkotlin/Function1;", "Lkotlin/time/Duration;", "", "<init>", "(Lcom/badoo/reaktive/disposable/CompositeDisposable;Lcom/badoo/reaktive/utils/clock/Clock;Lkotlin/jvm/functions/Function1;)V", "serializer", "Lcom/badoo/reaktive/utils/serializer/Serializer;", "Lcom/badoo/reaktive/scheduler/TrampolineScheduler$ExecutorImpl$Task;", "_isDisposed", "Lcom/badoo/reaktive/utils/atomic/AtomicBoolean;", "isDisposed", "()Z", "dispose", "", "submit", "delay", "period", "task", "Lkotlin/Function0;", "submit-NqJ4yvY", "(JJLkotlin/jvm/functions/Function0;)V", "cancel", "execute", "Task", "reaktive_release"})
    @SourceDebugExtension(value={"SMAP\nTrampolineScheduler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrampolineScheduler.kt\ncom/badoo/reaktive/scheduler/TrampolineScheduler$ExecutorImpl\n+ 2 PrioritySerializer.kt\ncom/badoo/reaktive/utils/serializer/PrioritySerializerKt\n*L\n1#1,117:1\n9#2,4:118\n*S KotlinDebug\n*F\n+ 1 TrampolineScheduler.kt\ncom/badoo/reaktive/scheduler/TrampolineScheduler$ExecutorImpl\n*L\n34#1:118,4\n*E\n"})
    private static final class ExecutorImpl
    implements Scheduler.Executor {
        @NotNull
        private final CompositeDisposable disposables;
        @NotNull
        private final Clock clock;
        @NotNull
        private final Function1<Duration, Boolean> sleep;
        @NotNull
        private final Serializer<Task> serializer;
        @NotNull
        private final AtomicBoolean _isDisposed;

        public ExecutorImpl(@NotNull CompositeDisposable disposables, @NotNull Clock clock, @NotNull Function1<? super Duration, Boolean> sleep) {
            Intrinsics.checkNotNullParameter((Object)disposables, (String)"disposables");
            Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
            Intrinsics.checkNotNullParameter(sleep, (String)"sleep");
            this.disposables = disposables;
            this.clock = clock;
            this.sleep = sleep;
            Comparator comparator$iv = Task::compareTo;
            boolean $i$f$serializer = false;
            this.serializer = new PrioritySerializer<Task>(comparator$iv, this){
                final /* synthetic */ ExecutorImpl $receiver$inlined;
                {
                    this.$receiver$inlined = executorImpl;
                    super($comparator);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                protected boolean onValue(Object value) {
                    Task p0 = (Task)value;
                    boolean bl = false;
                    return ExecutorImpl.access$execute(this.$receiver$inlined, p0);
                }
            };
            this._isDisposed = new AtomicBoolean(false, 1, null);
            CompositeDisposableExtKt.plusAssign(this.disposables, this);
        }

        @Override
        public boolean isDisposed() {
            return this._isDisposed.getValue();
        }

        @Override
        public void dispose() {
            if (this._isDisposed.compareAndSet(false, true)) {
                this.serializer.clear();
                CompositeDisposableExtKt.minusAssign(this.disposables, this);
            }
        }

        @Override
        public void submit-NqJ4yvY(long delay2, long period, @NotNull Function0<Unit> task) {
            Intrinsics.checkNotNullParameter(task, (String)"task");
            this.submit(new Task(TimeSource.Monotonic.ValueTimeMark.plus-LRDsOJo((long)this.clock.getUptime-z9LOYto(), (long)UtilsKt.coerceAtLeastZero-LRDsOJo((long)delay2)), UtilsKt.coerceAtLeastZero-LRDsOJo((long)period), task, null));
        }

        @Override
        public void cancel() {
            this.serializer.clear();
        }

        private final void submit(Task task) {
            if (!this.isDisposed()) {
                this.serializer.accept(task);
            }
        }

        private final boolean execute(Task task) {
            if (this.isDisposed()) {
                return false;
            }
            long delay2 = TimeSource.Monotonic.ValueTimeMark.minus-6eNON_k((long)task.getStartTime-z9LOYto(), (long)this.clock.getUptime-z9LOYto());
            if (Duration.isPositive-impl((long)delay2) && !((Boolean)this.sleep.invoke((Object)Duration.box-impl((long)delay2))).booleanValue()) {
                return false;
            }
            if (this.isDisposed()) {
                return false;
            }
            TimeSource.Monotonic.ValueTimeMark nextStart = Duration.isInfinite-impl((long)task.getPeriod-UwyO8pc()) ? null : TimeSource.Monotonic.ValueTimeMark.box-impl((long)TimeSource.Monotonic.ValueTimeMark.plus-LRDsOJo((long)this.clock.getUptime-z9LOYto(), (long)task.getPeriod-UwyO8pc()));
            task.getTask().invoke();
            if (nextStart != null) {
                this.submit(Task.copy-r6Rifso$default(task, nextStart.unbox-impl(), 0L, null, 6, null));
            }
            return true;
        }

        public static final /* synthetic */ boolean access$execute(ExecutorImpl $this, Task task) {
            return $this.execute(task);
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001$B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0011\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0000H\u0096\u0002J\u0010\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\u0017\u0010\fJ\u0010\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0019\u0010\fJ\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J4\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0015\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0013\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000e\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/badoo/reaktive/scheduler/TrampolineScheduler$ExecutorImpl$Task;", "", "startTime", "Lkotlin/time/TimeSource$Monotonic$ValueTimeMark;", "period", "Lkotlin/time/Duration;", "task", "Lkotlin/Function0;", "", "<init>", "(JJLkotlin/jvm/functions/Function0;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getStartTime-z9LOYto", "()J", "J", "getPeriod-UwyO8pc", "getTask", "()Lkotlin/jvm/functions/Function0;", "sequenceNumber", "", "compareTo", "", "other", "component1", "component1-z9LOYto", "component2", "component2-UwyO8pc", "component3", "copy", "copy-r6Rifso", "(JJLkotlin/jvm/functions/Function0;)Lcom/badoo/reaktive/scheduler/TrampolineScheduler$ExecutorImpl$Task;", "equals", "", "", "hashCode", "toString", "", "Companion", "reaktive_release"})
        @SourceDebugExtension(value={"SMAP\nTrampolineScheduler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrampolineScheduler.kt\ncom/badoo/reaktive/scheduler/TrampolineScheduler$ExecutorImpl$Task\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1#2:118\n*E\n"})
        private static final class Task
        implements Comparable<Task> {
            @NotNull
            private static final Companion Companion = new Companion(null);
            private final long startTime;
            private final long period;
            @NotNull
            private final Function0<Unit> task;
            private final long sequenceNumber;
            @NotNull
            private static final AtomicLong sequencer = new AtomicLong(0L, 1, null);

            private Task(long startTime, long period, Function0<Unit> task) {
                Intrinsics.checkNotNullParameter(task, (String)"task");
                this.startTime = startTime;
                this.period = period;
                this.task = task;
                this.sequenceNumber = sequencer.addAndGet(1L);
            }

            public final long getStartTime-z9LOYto() {
                return this.startTime;
            }

            public final long getPeriod-UwyO8pc() {
                return this.period;
            }

            @NotNull
            public final Function0<Unit> getTask() {
                return this.task;
            }

            @Override
            public int compareTo(@NotNull Task other) {
                int n;
                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                if (this == other) {
                    n = 0;
                } else {
                    Integer n2 = TimeSource.Monotonic.ValueTimeMark.compareTo-6eNON_k((long)this.startTime, (long)other.startTime);
                    int it = ((Number)n2).intValue();
                    boolean bl = false;
                    Integer n3 = !(it == 0) ? n2 : null;
                    n = n3 != null ? n3 : Intrinsics.compare((long)this.sequenceNumber, (long)other.sequenceNumber);
                }
                return n;
            }

            public final long component1-z9LOYto() {
                return this.startTime;
            }

            public final long component2-UwyO8pc() {
                return this.period;
            }

            @NotNull
            public final Function0<Unit> component3() {
                return this.task;
            }

            @NotNull
            public final Task copy-r6Rifso(long startTime, long period, @NotNull Function0<Unit> task) {
                Intrinsics.checkNotNullParameter(task, (String)"task");
                return new Task(startTime, period, task, null);
            }

            public static /* synthetic */ Task copy-r6Rifso$default(Task task, long l, long l2, Function0 function0, int n, Object object) {
                if ((n & 1) != 0) {
                    l = task.startTime;
                }
                if ((n & 2) != 0) {
                    l2 = task.period;
                }
                if ((n & 4) != 0) {
                    function0 = task.task;
                }
                return task.copy-r6Rifso(l, l2, function0);
            }

            @NotNull
            public String toString() {
                return "Task(startTime=" + TimeSource.Monotonic.ValueTimeMark.toString-impl((long)this.startTime) + ", period=" + Duration.toString-impl((long)this.period) + ", task=" + this.task + ')';
            }

            public int hashCode() {
                int result = TimeSource.Monotonic.ValueTimeMark.hashCode-impl((long)this.startTime);
                result = result * 31 + Duration.hashCode-impl((long)this.period);
                result = result * 31 + this.task.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Task)) {
                    return false;
                }
                Task task = (Task)other;
                if (!TimeSource.Monotonic.ValueTimeMark.equals-impl0((long)this.startTime, (long)task.startTime)) {
                    return false;
                }
                if (!Duration.equals-impl0((long)this.period, (long)task.period)) {
                    return false;
                }
                return Intrinsics.areEqual(this.task, task.task);
            }

            public /* synthetic */ Task(long startTime, long period, Function0 task, DefaultConstructorMarker $constructor_marker) {
                this(startTime, period, (Function0<Unit>)task);
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/badoo/reaktive/scheduler/TrampolineScheduler$ExecutorImpl$Task$Companion;", "", "<init>", "()V", "sequencer", "Lcom/badoo/reaktive/utils/atomic/AtomicLong;", "reaktive_release"})
            private static final class Companion {
                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

