/*
 * Decompiled with CFR 0.152.
 */
package com.badoo.reaktive.scheduler;

import com.badoo.reaktive.scheduler.CachedExecutorServiceStrategy;
import com.badoo.reaktive.scheduler.ExecutorServiceStrategy;
import com.badoo.reaktive.utils.ExpirationPool;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/badoo/reaktive/scheduler/CachedExecutorServiceStrategy;", "Lcom/badoo/reaktive/scheduler/ExecutorServiceStrategy;", "keepAliveTimeoutMillis", "", "threadFactory", "Ljava/util/concurrent/ThreadFactory;", "<init>", "(JLjava/util/concurrent/ThreadFactory;)V", "get", "Ljava/util/concurrent/ScheduledExecutorService;", "recycle", "", "executorService", "destroy", "Companion", "reaktive_release"})
public final class CachedExecutorServiceStrategy
implements ExecutorServiceStrategy {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final long keepAliveTimeoutMillis;
    @NotNull
    private final ThreadFactory threadFactory;
    @NotNull
    private static final Lazy<ExpirationPool<ScheduledExecutorService>> pool$delegate = LazyKt.lazy(CachedExecutorServiceStrategy::pool_delegate$lambda$0);

    public CachedExecutorServiceStrategy(long keepAliveTimeoutMillis, @NotNull ThreadFactory threadFactory) {
        Intrinsics.checkNotNullParameter((Object)threadFactory, (String)"threadFactory");
        this.keepAliveTimeoutMillis = keepAliveTimeoutMillis;
        this.threadFactory = threadFactory;
    }

    @Override
    @NotNull
    public ScheduledExecutorService get() {
        ScheduledExecutorService scheduledExecutorService = (ScheduledExecutorService)CachedExecutorServiceStrategy.Companion.getPool().acquire();
        if (scheduledExecutorService == null) {
            ScheduledExecutorService scheduledExecutorService2 = Executors.newSingleThreadScheduledExecutor(this.threadFactory);
            scheduledExecutorService = scheduledExecutorService2;
            Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService2, (String)"newSingleThreadScheduledExecutor(...)");
        }
        return scheduledExecutorService;
    }

    @Override
    public void recycle(@NotNull ScheduledExecutorService executorService) {
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        CachedExecutorServiceStrategy.Companion.getPool().release(executorService, this.keepAliveTimeoutMillis);
    }

    @Override
    public void destroy() {
    }

    private static final ExpirationPool pool_delegate$lambda$0() {
        return new ExpirationPool(Companion.pool.2.1.INSTANCE);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/badoo/reaktive/scheduler/CachedExecutorServiceStrategy$Companion;", "", "<init>", "()V", "pool", "Lcom/badoo/reaktive/utils/ExpirationPool;", "Ljava/util/concurrent/ScheduledExecutorService;", "getPool", "()Lcom/badoo/reaktive/utils/ExpirationPool;", "pool$delegate", "Lkotlin/Lazy;", "reaktive_release"})
    private static final class Companion {
        private Companion() {
        }

        private final ExpirationPool<ScheduledExecutorService> getPool() {
            Lazy lazy = pool$delegate;
            return (ExpirationPool)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

