/*
 * Decompiled with CFR 0.152.
 */
package com.badoo.reaktive.scheduler;

import com.badoo.reaktive.scheduler.ExecutorServiceStrategy;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/badoo/reaktive/scheduler/UnboundExecutorServiceStrategy;", "Lcom/badoo/reaktive/scheduler/ExecutorServiceStrategy;", "threadFactory", "Ljava/util/concurrent/ThreadFactory;", "<init>", "(Ljava/util/concurrent/ThreadFactory;)V", "get", "Ljava/util/concurrent/ScheduledExecutorService;", "recycle", "", "executorService", "destroy", "reaktive_release"})
public final class UnboundExecutorServiceStrategy
implements ExecutorServiceStrategy {
    @NotNull
    private final ThreadFactory threadFactory;

    public UnboundExecutorServiceStrategy(@NotNull ThreadFactory threadFactory) {
        Intrinsics.checkNotNullParameter((Object)threadFactory, (String)"threadFactory");
        this.threadFactory = threadFactory;
    }

    @Override
    @NotNull
    public ScheduledExecutorService get() {
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(this.threadFactory);
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newSingleThreadScheduledExecutor(...)");
        return scheduledExecutorService;
    }

    @Override
    public void recycle(@NotNull ScheduledExecutorService executorService) {
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        executorService.shutdown();
    }

    @Override
    public void destroy() {
    }
}

